/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.player;

import com.frostwire.gui.player.MPlayerUIEventListener;
import java.util.LinkedList;

public class MPlayerUIEventHandler {
    private static MPlayerUIEventHandler instance = null;
    private LinkedList<MPlayerUIEventListener> listeners = new LinkedList();

    public static MPlayerUIEventHandler instance() {
        if (instance == null) {
            instance = new MPlayerUIEventHandler();
        }
        return instance;
    }

    private MPlayerUIEventHandler() {
    }

    public void addListener(MPlayerUIEventListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(MPlayerUIEventListener listener) {
        this.listeners.remove(listener);
    }

    public void onVolumeChanged(float volume) {
        for (MPlayerUIEventListener listener : this.listeners) {
            listener.onUIVolumeChanged(volume);
        }
    }

    public void onVolumeIncremented() {
        for (MPlayerUIEventListener listener : this.listeners) {
            listener.onUIVolumeIncremented();
        }
    }

    public void onVolumeDecremented() {
        for (MPlayerUIEventListener listener : this.listeners) {
            listener.onUIVolumeDecremented();
        }
    }

    public void onSeekToTime(float seconds) {
        for (MPlayerUIEventListener listener : this.listeners) {
            listener.onUISeekToTime(seconds);
        }
    }

    public void onTogglePlayPausePressed() {
        for (MPlayerUIEventListener listener : this.listeners) {
            listener.onUITogglePlayPausePressed();
        }
    }

    public void onPlayPressed() {
        for (MPlayerUIEventListener listener : this.listeners) {
            listener.onUIPlayPressed();
        }
    }

    public void onPausePressed() {
        for (MPlayerUIEventListener listener : this.listeners) {
            listener.onUIPausePressed();
        }
    }

    public void onFastForwardPressed() {
        for (MPlayerUIEventListener listener : this.listeners) {
            listener.onUIFastForwardPressed();
        }
    }

    public void onRewindPressed() {
        for (MPlayerUIEventListener listener : this.listeners) {
            listener.onUIRewindPressed();
        }
    }

    public void onToggleFullscreenPressed() {
        for (MPlayerUIEventListener listener : this.listeners) {
            listener.onUIToggleFullscreenPressed();
        }
    }

    public void onProgressSlideStart() {
        for (MPlayerUIEventListener listener : this.listeners) {
            listener.onUIProgressSlideStart();
        }
    }

    public void onProgressSlideEnd() {
        for (MPlayerUIEventListener listener : this.listeners) {
            listener.onUIProgressSlideEnd();
        }
    }
}

