/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library;

import com.frostwire.alexandria.PlaylistItem;
import com.frostwire.gui.library.LibraryUtils;
import com.limegroup.gnutella.gui.dnd.FileTransferable;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class LibraryPlaylistsTableTransferable
implements Transferable {
    static final DataFlavor ITEM_ARRAY = new DataFlavor(Item[].class, "LibraryPlaylistTransferable.Item Array");
    static final DataFlavor PLAYLIST_ITEM_ARRAY = new DataFlavor(Item[].class, "LibraryPlaylistTransferable.PlaylistItemArray");
    private final List<Item> items;
    private final int playlistID;
    private final FileTransferable fileTransferable;
    private final int[] selectedIndexes;

    LibraryPlaylistsTableTransferable(List<PlaylistItem> playlistItems, int playlistID, int[] selectedIndexes) {
        this.items = LibraryUtils.convertToItems(playlistItems);
        ArrayList<File> files = new ArrayList<File>(this.items.size());
        for (PlaylistItem item : playlistItems) {
            files.add(new File(item.getFilePath()));
        }
        this.fileTransferable = new FileTransferable(files);
        this.playlistID = playlistID;
        this.selectedIndexes = selectedIndexes;
    }

    LibraryPlaylistsTableTransferable(List<PlaylistItem> playlistItems) {
        this.items = LibraryUtils.convertToItems(playlistItems);
        ArrayList<File> files = new ArrayList<File>(this.items.size());
        int playlistId = -1;
        for (PlaylistItem item : playlistItems) {
            files.add(new File(item.getFilePath()));
            if (playlistId != -1 || item.getPlaylist() == null) continue;
            playlistId = item.getPlaylist().getId();
        }
        this.fileTransferable = new FileTransferable(files);
        this.selectedIndexes = null;
        this.playlistID = playlistId;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        ArrayList<DataFlavor> list = new ArrayList<DataFlavor>();
        list.addAll(Arrays.asList(this.fileTransferable.getTransferDataFlavors()));
        list.add(ITEM_ARRAY);
        if (this.selectedIndexes != null) {
            list.add(PLAYLIST_ITEM_ARRAY);
        }
        return list.toArray(new DataFlavor[0]);
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        if (flavor.equals(PLAYLIST_ITEM_ARRAY)) {
            return this.selectedIndexes != null;
        }
        return flavor.equals(ITEM_ARRAY) || this.fileTransferable.isDataFlavorSupported(flavor);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor.equals(PLAYLIST_ITEM_ARRAY)) {
            return new PlaylistItemContainer(this.playlistID, this.selectedIndexes, this.items);
        }
        if (flavor.equals(ITEM_ARRAY)) {
            return this.items.toArray(new Item[0]);
        }
        return this.fileTransferable.getTransferData(flavor);
    }

    public static final class Item
    implements Serializable {
        public int id;
        public String filePath;
        public String fileName;
        public long fileSize;
        String fileExtension;
        public String trackTitle;
        float trackDurationInSecs;
        String trackArtist;
        String trackAlbum;
        String coverArtPath;
        String trackBitrate;
        String trackComment;
        String trackGenre;
        String trackNumber;
        String trackYear;
        public boolean starred;

        Item() {
        }
    }

    public static final class PlaylistItemContainer
    implements Serializable {
        final int playlistID;
        final int[] selectedIndexes;
        public final List<Item> items;

        PlaylistItemContainer(int playlistID, int[] selectedIndexes, List<Item> items) {
            this.playlistID = playlistID;
            this.selectedIndexes = selectedIndexes;
            this.items = items;
        }
    }
}

