/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library;

import com.frostwire.alexandria.Library;
import com.frostwire.alexandria.Playlist;
import com.frostwire.alexandria.PlaylistItem;
import com.frostwire.gui.library.AbstractLibraryListPanel;
import com.frostwire.gui.library.AbstractLibraryTableMediator;
import com.frostwire.gui.library.DirectoryHolder;
import com.frostwire.gui.library.LibraryCoverArtPanel;
import com.frostwire.gui.library.LibraryExplorer;
import com.frostwire.gui.library.LibraryFilesTableMediator;
import com.frostwire.gui.library.LibraryLeftPanel;
import com.frostwire.gui.library.LibraryPlaylists;
import com.frostwire.gui.library.LibraryPlaylistsTableMediator;
import com.frostwire.gui.library.LibrarySearch;
import com.frostwire.gui.library.MediaTypeSavedFilesDirectoryHolder;
import com.frostwire.gui.library.SavedFilesDirectoryHolder;
import com.frostwire.gui.library.TorrentDirectoryHolder;
import com.frostwire.gui.player.MediaPlayer;
import com.frostwire.gui.player.MediaSource;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.util.DividerLocationSettingUpdater;
import com.limegroup.gnutella.settings.LibrarySettings;
import com.limegroup.gnutella.settings.UISettings;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public class LibraryMediator {
    private static final String FILES_TABLE_KEY = "LIBRARY_FILES_TABLE";
    private static final String PLAYLISTS_TABLE_KEY = "LIBRARY_PLAYLISTS_TABLE";
    private static JPanel MAIN_PANEL;
    private static LibraryMediator INSTANCE;
    private LibraryExplorer libraryExplorer;
    private LibraryPlaylists libraryPlaylists;
    private LibraryCoverArtPanel libraryCoverArtPanel;
    private LibraryLeftPanel libraryLeftPanel;
    private LibrarySearch librarySearch;
    private static Library LIBRARY;
    private CardLayout _tablesViewLayout = new CardLayout();
    private JPanel _tablesPanel;
    private Map<Object, Integer> scrollbarValues;
    private Object lastSelectedKey;
    private AbstractLibraryTableMediator<?, ?, ?> lastSelectedMediator;
    private Set<Integer> idScanned;
    private AbstractLibraryTableMediator<?, ?, ?> currentMediator;

    public static LibraryMediator instance() {
        if (INSTANCE == null) {
            INSTANCE = new LibraryMediator();
        }
        return INSTANCE;
    }

    public LibraryMediator() {
        GUIMediator.setSplashScreenString(I18n.tr("Loading Library Window..."));
        this.idScanned = new HashSet<Integer>();
        this.getComponent();
        this.scrollbarValues = new HashMap<Object, Integer>();
        JSplitPane splitPane = new JSplitPane(1, this.getLibraryLeftPanel(), this.getLibraryRightPanel());
        splitPane.setContinuousLayout(true);
        splitPane.setResizeWeight(0.5);
        splitPane.addPropertyChangeListener("lastDividerLocation", evt -> {
            JSplitPane splitPane1 = (JSplitPane)evt.getSource();
            int current = splitPane1.getDividerLocation();
            if (current > 300) {
                splitPane1.setDividerLocation(300);
            } else if (current < 155) {
                splitPane1.setDividerLocation(155);
            }
        });
        DividerLocationSettingUpdater.install(splitPane, UISettings.UI_LIBRARY_MAIN_DIVIDER_LOCATION);
        MAIN_PANEL.add(splitPane);
    }

    private Object getSelectedKey() {
        if (this.getSelectedPlaylist() != null) {
            return this.getSelectedPlaylist();
        }
        return this.getLibraryExplorer().getSelectedDirectoryHolder();
    }

    public static Library getLibrary() {
        if (LIBRARY == null) {
            LIBRARY = new Library(LibrarySettings.LIBRARY_DATABASE);
        }
        return LIBRARY;
    }

    public LibraryExplorer getLibraryExplorer() {
        if (this.libraryExplorer == null) {
            this.libraryExplorer = new LibraryExplorer();
        }
        return this.libraryExplorer;
    }

    LibraryPlaylists getLibraryPlaylists() {
        if (this.libraryPlaylists == null) {
            this.libraryPlaylists = new LibraryPlaylists();
        }
        return this.libraryPlaylists;
    }

    Playlist getSelectedPlaylist() {
        return this.getLibraryPlaylists().getSelectedPlaylist();
    }

    public LibrarySearch getLibrarySearch() {
        if (this.librarySearch == null) {
            this.librarySearch = new LibrarySearch();
        }
        return this.librarySearch;
    }

    public LibraryCoverArtPanel getLibraryCoverArtPanel() {
        if (this.libraryCoverArtPanel == null) {
            this.libraryCoverArtPanel = new LibraryCoverArtPanel();
        }
        return this.libraryCoverArtPanel;
    }

    public JComponent getComponent() {
        if (MAIN_PANEL == null) {
            MAIN_PANEL = new JPanel(new BorderLayout());
        }
        return MAIN_PANEL;
    }

    private void showView(String key) {
        GUIMediator.safeInvokeAndWait(() -> {
            this.rememberScrollbarsOnMediators(key);
            this._tablesViewLayout.show(this._tablesPanel, key);
        });
        switch (key) {
            case "LIBRARY_FILES_TABLE": {
                this.currentMediator = LibraryFilesTableMediator.instance();
                break;
            }
            case "LIBRARY_PLAYLISTS_TABLE": {
                this.currentMediator = LibraryPlaylistsTableMediator.instance();
                break;
            }
            default: {
                this.currentMediator = null;
            }
        }
    }

    private void rememberScrollbarsOnMediators(String key) {
        if (key == null) {
            return;
        }
        AbstractLibraryTableMediator tableMediator = null;
        AbstractLibraryListPanel listPanel = null;
        if (key.equals(FILES_TABLE_KEY)) {
            tableMediator = LibraryFilesTableMediator.instance();
            listPanel = this.getLibraryExplorer();
        } else if (key.equals(PLAYLISTS_TABLE_KEY)) {
            tableMediator = LibraryPlaylistsTableMediator.instance();
            listPanel = this.getLibraryPlaylists();
        }
        if (tableMediator == null || listPanel == null) {
            return;
        }
        if (this.lastSelectedMediator != null && this.lastSelectedKey != null) {
            this.scrollbarValues.put(this.lastSelectedKey, this.lastSelectedMediator.getScrollbarValue());
        }
        this.lastSelectedMediator = tableMediator;
        this.lastSelectedKey = this.getSelectedKey();
        if (listPanel.getPendingRunnables().size() == 0) {
            int lastScrollValue = this.scrollbarValues.getOrDefault(this.lastSelectedKey, 0);
            tableMediator.scrollTo(lastScrollValue);
        }
    }

    void updateTableFiles(DirectoryHolder dirHolder) {
        this.clearLibraryTable();
        this.showView(FILES_TABLE_KEY);
        LibraryFilesTableMediator.instance().updateTableFiles(dirHolder);
    }

    public void clearDirectoryHolderCaches() {
        this.getLibraryExplorer().clearDirectoryHolderCaches();
    }

    void updateTableItems(Playlist playlist) {
        this.clearLibraryTable();
        this.showView(PLAYLISTS_TABLE_KEY);
        LibraryPlaylistsTableMediator.instance().updateTableItems(playlist);
    }

    void clearLibraryTable() {
        LibraryFilesTableMediator.instance().clearTable();
        LibraryPlaylistsTableMediator.instance().clearTable();
        this.getLibrarySearch().clear();
    }

    void addFilesToLibraryTable(List<File> files) {
        for (File file : files) {
            LibraryFilesTableMediator.instance().add(file);
        }
        this.getLibrarySearch().addResults(files.size());
    }

    void addItemsToLibraryTable(List<PlaylistItem> items) {
        for (PlaylistItem item : items) {
            LibraryPlaylistsTableMediator.instance().add(item);
        }
        LibraryPlaylistsTableMediator.instance().getTable().repaint();
        this.getLibrarySearch().addResults(items.size());
    }

    private JComponent getLibraryLeftPanel() {
        if (this.libraryLeftPanel == null) {
            this.libraryLeftPanel = new LibraryLeftPanel(this.getLibraryExplorer(), this.getLibraryPlaylists(), this.getLibraryCoverArtPanel());
        }
        return this.libraryLeftPanel;
    }

    private JComponent getLibraryRightPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this._tablesViewLayout = new CardLayout();
        this._tablesPanel = new JPanel(this._tablesViewLayout);
        this._tablesPanel.add((Component)LibraryFilesTableMediator.instance().getComponent(), FILES_TABLE_KEY);
        this._tablesPanel.add((Component)LibraryPlaylistsTableMediator.instance().getComponent(), PLAYLISTS_TABLE_KEY);
        panel.add((Component)this.getLibrarySearch(), "First");
        panel.add((Component)this._tablesPanel, "Center");
        return panel;
    }

    public void setSelectedFile(File file) {
        this.getLibraryExplorer().selectFinishedDownloads();
        LibraryFilesTableMediator.instance().setFileSelected(file);
    }

    public void selectCurrentMedia() {
        Playlist currentPlaylist = MediaPlayer.instance().getCurrentPlaylist();
        MediaSource currentMedia = MediaPlayer.instance().getCurrentMedia();
        if (currentPlaylist != null && currentMedia != null && currentMedia.getPlaylistItem() != null) {
            if (currentPlaylist.getId() != -3) {
                this.getLibraryPlaylists().enqueueRunnable(() -> GUIMediator.safeInvokeLater(() -> LibraryPlaylistsTableMediator.instance().setItemSelected(currentMedia.getPlaylistItem())));
                this.getLibraryPlaylists().selectPlaylist(currentPlaylist);
            } else {
                LibraryExplorer libraryFiles = this.getLibraryExplorer();
                libraryFiles.enqueueRunnable(() -> GUIMediator.safeInvokeLater(() -> LibraryPlaylistsTableMediator.instance().setItemSelected(currentMedia.getPlaylistItem())));
                libraryFiles.selectStarred();
            }
        } else if (currentMedia != null && currentMedia.getFile() != null) {
            LibraryExplorer libraryFiles = this.getLibraryExplorer();
            libraryFiles.enqueueRunnable(() -> GUIMediator.safeInvokeLater(() -> LibraryFilesTableMediator.instance().setFileSelected(currentMedia.getFile())));
            libraryFiles.selectAudio();
        }
    }

    public boolean isScanned(int id) {
        return this.idScanned.contains(id);
    }

    public void scan(int hashCode, File location) {
        block4: {
            block3: {
                if (location == null) {
                    return;
                }
                this.idScanned.add(hashCode);
                if (!location.isDirectory()) break block3;
                File[] files = location.listFiles();
                if (files == null) break block4;
                for (File file : files) {
                    this.scan(hashCode, file);
                }
                break block4;
            }
            List<MediaTypeSavedFilesDirectoryHolder> holders = this.getLibraryExplorer().getMediaTypeSavedFilesDirectoryHolders();
            for (MediaTypeSavedFilesDirectoryHolder holder : holders) {
                Set<File> cache = holder.getCache();
                if (!holder.accept(location) || cache.isEmpty() || cache.contains(location)) continue;
                cache.add(location);
            }
        }
    }

    File getSelectedFile() {
        boolean fileBasedDirectoryHolderSelected;
        File toExplore = null;
        DirectoryHolder selectedDirectoryHolder = LibraryMediator.instance().getLibraryExplorer().getSelectedDirectoryHolder();
        boolean bl = fileBasedDirectoryHolderSelected = selectedDirectoryHolder instanceof SavedFilesDirectoryHolder || selectedDirectoryHolder instanceof MediaTypeSavedFilesDirectoryHolder || selectedDirectoryHolder instanceof TorrentDirectoryHolder;
        if (fileBasedDirectoryHolderSelected && LibraryFilesTableMediator.instance().getSelectedLines().size() == 1) {
            toExplore = LibraryFilesTableMediator.instance().getSelectedLines().get(0).getFile();
        } else if (LibraryPlaylistsTableMediator.instance().getSelectedLines() != null && LibraryPlaylistsTableMediator.instance().getSelectedLines().size() == 1) {
            toExplore = LibraryPlaylistsTableMediator.instance().getSelectedLines().get(0).getFile();
        }
        return toExplore;
    }

    public void playCurrentSelection() {
        if (this.currentMediator != null) {
            this.currentMediator.playCurrentSelection();
        }
    }
}

