/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library;

import com.frostwire.bittorrent.BTInfoAdditionalMetadataHolder;
import com.frostwire.bittorrent.PaymentOptions;
import com.frostwire.gui.library.AbstractLibraryTableDataLine;
import com.frostwire.gui.library.LibraryActionsHolder;
import com.frostwire.gui.library.LibraryFilesTableModel;
import com.frostwire.gui.library.PlayableCell;
import com.frostwire.gui.library.PlayableIconCell;
import com.frostwire.gui.player.MediaPlayer;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.IconManager;
import com.limegroup.gnutella.gui.tables.LimeTableColumn;
import com.limegroup.gnutella.gui.tables.NameHolder;
import com.limegroup.gnutella.gui.tables.SizeHolder;
import com.limegroup.gnutella.gui.util.BackgroundExecutorService;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import javax.swing.Icon;
import org.apache.commons.io.FilenameUtils;

public final class LibraryFilesTableDataLine
extends AbstractLibraryTableDataLine<File> {
    static final int ACTIONS_IDX = 0;
    private static final int ICON_IDX = 1;
    private static final int NAME_IDX = 2;
    private static final int SIZE_IDX = 3;
    private static final int TYPE_IDX = 4;
    private static final int PATH_IDX = 5;
    static final int MODIFICATION_TIME_IDX = 6;
    static final int PAYMENT_OPTIONS_IDX = 7;
    private static final int LICENSE_IDX = 8;
    private static final SizeHolder ZERO_SIZED_HOLDER = new SizeHolder(0L);
    private static LimeTableColumn[] ltColumns;
    private String _type;
    private SizeHolder _sizeHolder;
    private String _path;
    private final LibraryFilesTableModel _model;
    private boolean _iconLoaded = false;
    private boolean _iconScheduledForLoad = false;
    private Date lastModified;
    private String license;
    private PaymentOptions paymentOptions;
    private LibraryActionsHolder actionsHolder;
    private NameHolder nameCell;

    LibraryFilesTableDataLine(LibraryFilesTableModel ltm) {
        this._model = ltm;
    }

    @Override
    public int getColumnCount() {
        return this.getLimeTableColumns().length;
    }

    @Override
    public void initialize(File file) {
        super.initialize(file);
        String fullPath = file.getPath();
        try {
            fullPath = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String _name = ((File)this.initializer).getName();
        this._type = "";
        if (!file.isDirectory()) {
            int index = _name.lastIndexOf(".");
            int index2 = fullPath.lastIndexOf(File.separator);
            this._path = fullPath.substring(0, index2);
            if (index != -1 && index != 0) {
                this._type = _name.substring(index + 1);
                _name = _name.substring(0, index);
            }
        } else {
            this._path = fullPath;
        }
        if (((File)this.initializer).isFile()) {
            long _size = ((File)this.initializer).length();
            this._sizeHolder = new SizeHolder(_size);
        } else {
            this._sizeHolder = ZERO_SIZED_HOLDER;
        }
        this.lastModified = new Date(((File)this.initializer).lastModified());
        this.actionsHolder = new LibraryActionsHolder(this, false);
        this.nameCell = new NameHolder(_name);
        if (this.initializer != null && ((File)this.initializer).isFile() && FilenameUtils.getExtension(((File)this.initializer).getName()) != null && FilenameUtils.getExtension(((File)this.initializer).getName()).toLowerCase().endsWith("torrent")) {
            boolean hasPaymentOptions;
            BTInfoAdditionalMetadataHolder additionalMetadataHolder = null;
            try {
                additionalMetadataHolder = new BTInfoAdditionalMetadataHolder((File)this.initializer, ((File)this.initializer).getName());
            }
            catch (Throwable t) {
                System.err.println("[InvalidTorrent] Can't create BTInfoAdditionalMetadataholder out of " + ((File)this.initializer).getAbsolutePath());
                t.printStackTrace();
            }
            boolean hasLicense = additionalMetadataHolder != null && additionalMetadataHolder.getLicenseBroker() != null;
            boolean bl = hasPaymentOptions = additionalMetadataHolder != null && additionalMetadataHolder.getPaymentOptions() != null;
            if (hasLicense) {
                this.license = additionalMetadataHolder.getLicenseBroker().getLicenseName();
            }
            if (this.license == null) {
                this.license = "";
            }
            this.paymentOptions = hasPaymentOptions ? additionalMetadataHolder.getPaymentOptions() : new PaymentOptions(null, null);
            this.paymentOptions.setItemName(_name);
        }
    }

    @Override
    public File getFile() {
        return (File)this.initializer;
    }

    @Override
    public Object getValueAt(int idx) {
        try {
            boolean isPlaying = this.isPlaying();
            switch (idx) {
                case 0: {
                    this.actionsHolder.setPlaying(isPlaying);
                    return this.actionsHolder;
                }
                case 1: {
                    return new PlayableIconCell(this.getIcon(), isPlaying);
                }
                case 2: {
                    return this.nameCell;
                }
                case 3: {
                    return new PlayableCell(this, this._sizeHolder, this._sizeHolder.toString(), isPlaying, idx);
                }
                case 4: {
                    return new PlayableCell(this, this._type, isPlaying, idx);
                }
                case 5: {
                    return new PlayableCell(this, this._path, isPlaying, idx);
                }
                case 6: {
                    return new PlayableCell(this, this.lastModified, this.lastModified.toString(), isPlaying, idx);
                }
                case 7: {
                    return this.paymentOptions;
                }
                case 8: {
                    return this.license;
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return null;
    }

    private boolean isPlaying() {
        return this.initializer != null && MediaPlayer.instance().isThisBeingPlayed((File)this.initializer);
    }

    @Override
    public LimeTableColumn getColumn(int idx) {
        return this.getLimeTableColumns()[idx];
    }

    @Override
    public boolean isClippable(int idx) {
        switch (idx) {
            case 1: {
                return false;
            }
        }
        return true;
    }

    @Override
    public int getTypeAheadColumn() {
        return 2;
    }

    @Override
    public boolean isDynamic(int idx) {
        return false;
    }

    @Override
    public String[] getToolTipArray(int col) {
        return new String[]{((File)this.getInitializeObject()).getAbsolutePath()};
    }

    private LimeTableColumn[] getLimeTableColumns() {
        if (ltColumns == null) {
            LimeTableColumn[] temp = new LimeTableColumn[]{new LimeTableColumn(0, "LIBRARY_TABLE_ACTIONS", I18n.tr("Actions"), 18, true, LibraryActionsHolder.class), new LimeTableColumn(1, "LIBRARY_TABLE_ICON", I18n.tr("Icon"), GUIMediator.getThemeImage("question_mark"), 18, true, PlayableIconCell.class), new LimeTableColumn(2, "LIBRARY_TABLE_NAME", I18n.tr("Name"), 239, true, NameHolder.class), new LimeTableColumn(3, "LIBRARY_TABLE_SIZE", I18n.tr("Size"), 62, true, PlayableCell.class), new LimeTableColumn(4, "LIBRARY_TABLE_TYPE", I18n.tr("Type"), 48, true, PlayableCell.class), new LimeTableColumn(5, "LIBRARY_TABLE_PATH", I18n.tr("Path"), 108, true, PlayableCell.class), new LimeTableColumn(6, "LIBRARY_TABLE_MODIFICATION_TIME", I18n.tr("Last Modified"), 20, true, PlayableCell.class), new LimeTableColumn(7, "LIBRARY_TABLE_PAYMENT_OPTIONS", I18n.tr("Tips/Donations"), 20, false, PaymentOptions.class), new LimeTableColumn(8, "LIBRARY_TABLE_LICENSE", I18n.tr("License"), 100, true, String.class)};
            ltColumns = temp;
        }
        return ltColumns;
    }

    private Icon getIcon() {
        boolean iconAvailable = IconManager.instance().isIconForFileAvailable((File)this.initializer);
        if (!iconAvailable && !this._iconScheduledForLoad) {
            this._iconScheduledForLoad = true;
            BackgroundExecutorService.schedule(new Runnable(){

                @Override
                public void run() {
                    GUIMediator.safeInvokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            IconManager.instance().getIconForFile((File)LibraryFilesTableDataLine.this.initializer);
                            LibraryFilesTableDataLine.this._iconLoaded = true;
                            LibraryFilesTableDataLine.this._model.refresh();
                        }
                    });
                }
            });
            return null;
        }
        if (this._iconLoaded || iconAvailable) {
            return IconManager.instance().getIconForFile((File)this.initializer);
        }
        return null;
    }
}

