/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.bittorrent;

import com.frostwire.bittorrent.PaymentOptions;
import com.frostwire.gui.bittorrent.CryptoCurrencyTextField;
import com.frostwire.gui.theme.ThemeMediator;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LimeTextField;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;

public class PaymentOptionsPanel
extends JPanel {
    private final JCheckBox confirmationCheckbox;
    private final CryptoCurrencyTextField bitcoinAddress;
    private final LimeTextField paypalUrlAddress;

    public PaymentOptionsPanel() {
        this.initBorder();
        this.confirmationCheckbox = new JCheckBox("<html><strong>" + I18n.tr("I am the content creator or I have the right to collect financial contributions for this work.") + "</strong><br>" + I18n.tr("I understand that incurring in financial gains from unauthorized copyrighted works can make me liable for counterfeiting and criminal copyright infringement.") + "</html>");
        this.bitcoinAddress = new CryptoCurrencyTextField(CryptoCurrencyTextField.CurrencyURIPrefix.BITCOIN);
        this.paypalUrlAddress = new LimeTextField();
        this.setLayout(new MigLayout("fill"));
        this.initComponents();
        this.initListeners();
    }

    private void initListeners() {
        this.confirmationCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaymentOptionsPanel.this.onConfirmationCheckbox();
            }
        });
        this.bitcoinAddress.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                PaymentOptionsPanel.this.onCryptoAddressPressed(PaymentOptionsPanel.this.bitcoinAddress);
            }
        });
    }

    protected void onConfirmationCheckbox() {
        this.bitcoinAddress.setEnabled(this.confirmationCheckbox.isSelected());
        this.paypalUrlAddress.setEnabled(this.confirmationCheckbox.isSelected());
    }

    protected void onCryptoAddressPressed(CryptoCurrencyTextField textField) {
        boolean hasValidPrefixOrNoPrefix = false;
        hasValidPrefixOrNoPrefix = textField.hasValidPrefixOrNoPrefix();
        if (!textField.hasValidAddress() || !hasValidPrefixOrNoPrefix) {
            textField.setForeground(Color.red);
        } else {
            textField.setForeground(Color.black);
        }
        int caretPosition = textField.getCaretPosition();
        int lengthBefore = textField.getText().length();
        int selectionStart = textField.getSelectionStart();
        int selectionEnd = textField.getSelectionEnd();
        textField.setText(textField.getText().replaceAll(" ", ""));
        int lengthAfter = textField.getText().length();
        if (lengthAfter < lengthBefore) {
            int delta = lengthBefore - lengthAfter;
            caretPosition -= delta;
            selectionEnd -= delta;
        }
        textField.setCaretPosition(caretPosition);
        textField.setSelectionStart(selectionStart);
        textField.setSelectionEnd(selectionEnd);
    }

    private void initComponents() {
        this.add((Component)this.confirmationCheckbox, "aligny top, gapbottom 10px, wrap, span");
        this.add((Component)new JLabel("<html>" + I18n.tr("<strong>Bitcoin</strong> receiving wallet address") + "</html>"), "wrap, span");
        this.add((Component)new JLabel(GUIMediator.getThemeImage("bitcoin_accepted.png")), "aligny top");
        this.bitcoinAddress.setPrompt("bitcoin:1xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx");
        this.add((Component)this.bitcoinAddress, "aligny top, growx, gapbottom 10px, wrap");
        this.add((Component)new JLabel("<html>" + I18n.tr("<strong>Paypal</strong> payment/donation page url") + "</html>"), "wrap, span");
        this.add((Component)new JLabel(GUIMediator.getThemeImage("paypal_accepted.png")), "aligny top");
        this.paypalUrlAddress.setPrompt("http://your.paypal.button/url/here");
        this.add((Component)this.paypalUrlAddress, "aligny top, growx, push");
        this.onConfirmationCheckbox();
    }

    private void initBorder() {
        TitledBorder titleBorder = BorderFactory.createTitledBorder(I18n.tr("\"Name your price\", \"Tips\", \"Donations\" payment options"));
        Border lineBorder = BorderFactory.createLineBorder(ThemeMediator.LIGHT_BORDER_COLOR);
        CompoundBorder border = BorderFactory.createCompoundBorder(lineBorder, titleBorder);
        this.setBorder(border);
    }

    public PaymentOptions getPaymentOptions() {
        boolean validBitcoin;
        PaymentOptions result = null;
        if (this.confirmationCheckbox.isSelected() && ((validBitcoin = this.bitcoinAddress.hasValidAddress()) || this.paypalUrlAddress.getText() != null && !this.paypalUrlAddress.getText().isEmpty())) {
            String bitcoin = validBitcoin ? this.bitcoinAddress.normalizeValidAddress() : null;
            String paypal = this.paypalUrlAddress != null && this.paypalUrlAddress.getText() != null && !this.paypalUrlAddress.getText().isEmpty() ? this.paypalUrlAddress.getText() : null;
            result = new PaymentOptions(bitcoin, paypal);
        }
        return result;
    }

    public boolean hasPaymentOptions() {
        return this.getPaymentOptions() != null;
    }
}

