/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.bittorrent;

import com.frostwire.bittorrent.BTDownloadItem;
import com.frostwire.bittorrent.BTDownloadListener;
import com.frostwire.bittorrent.BTInfoAdditionalMetadataHolder;
import com.frostwire.bittorrent.CopyrightLicenseBroker;
import com.frostwire.bittorrent.PaymentOptions;
import com.frostwire.gui.bittorrent.BTDownload;
import com.frostwire.gui.bittorrent.BTDownloadMediator;
import com.frostwire.gui.bittorrent.HttpDownload;
import com.frostwire.gui.bittorrent.ShareTorrentDialog;
import com.frostwire.gui.bittorrent.SoundcloudDownload;
import com.frostwire.gui.bittorrent.TorrentUtil;
import com.frostwire.gui.library.LibraryMediator;
import com.frostwire.gui.player.MediaPlayer;
import com.frostwire.jlibtorrent.TorrentInfo;
import com.frostwire.transfers.TransferItem;
import com.frostwire.transfers.TransferState;
import com.frostwire.util.Logger;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.iTunesMediator;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.settings.iTunesImportSettings;
import com.limegroup.gnutella.settings.iTunesSettings;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.limewire.util.OSUtils;

public class BittorrentDownload
implements BTDownload {
    private static final Logger LOG = Logger.getLogger(BittorrentDownload.class);
    private final com.frostwire.bittorrent.BTDownload dl;
    private String displayName;
    private long size;
    private List<TransferItem> items;
    private boolean partial;
    private boolean deleteTorrentWhenRemove;
    private boolean deleteDataWhenRemove;
    private BTInfoAdditionalMetadataHolder holder;
    private CopyrightLicenseBroker licenseBroker;
    private PaymentOptions paymentOptions;

    public BittorrentDownload(com.frostwire.bittorrent.BTDownload dl) {
        this.dl = dl;
        this.dl.setListener(new StatusListener());
        this.displayName = dl.getDisplayName();
        this.size = this.calculateSize(dl);
        this.items = this.calculateItems(dl);
        this.partial = dl.isPartial();
        if (dl.isFinished(true) && !SharingSettings.SEED_FINISHED_TORRENTS.getValue()) {
            dl.pause();
            this.finalCleanup(dl.getIncompleteFiles());
        }
        if (!dl.wasPaused()) {
            dl.resume();
        }
    }

    public com.frostwire.bittorrent.BTDownload getDl() {
        return this.dl;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getName() {
        return this.dl.getName();
    }

    @Override
    public boolean isResumable() {
        return this.dl.isPaused();
    }

    @Override
    public boolean isPausable() {
        return !this.dl.isPaused();
    }

    @Override
    public boolean isCompleted() {
        return this.dl.isFinished();
    }

    @Override
    public TransferState getState() {
        return this.dl.getState();
    }

    @Override
    public void remove() {
        this.dl.remove(this.deleteTorrentWhenRemove, this.deleteDataWhenRemove);
    }

    @Override
    public void pause() {
        this.dl.pause();
    }

    @Override
    public File getSaveLocation() {
        if (!this.partial) {
            return this.dl.getSavePath();
        }
        for (TransferItem item : this.items) {
            if (!item.getDisplayName().equals(this.getDisplayName())) continue;
            return item.getFile();
        }
        return this.dl.getSavePath();
    }

    @Override
    public void resume() {
        this.dl.resume();
    }

    @Override
    public int getProgress() {
        return this.dl.getProgress();
    }

    @Override
    public long getBytesReceived() {
        return this.dl.getBytesReceived();
    }

    @Override
    public long getBytesSent() {
        return this.dl.getTotalBytesSent();
    }

    @Override
    public double getDownloadSpeed() {
        return this.dl.getDownloadSpeed() / 1024L;
    }

    @Override
    public double getUploadSpeed() {
        return this.dl.getUploadSpeed() / 1024L;
    }

    @Override
    public long getETA() {
        return this.dl.getETA();
    }

    @Override
    public String getPeersString() {
        return this.dl.getConnectedPeers() + "/" + this.dl.getTotalPeers();
    }

    @Override
    public String getSeedsString() {
        return this.dl.getConnectedSeeds() + "/" + this.dl.getTotalSeeds();
    }

    @Override
    public void setDeleteTorrentWhenRemove(boolean deleteTorrentWhenRemove) {
        this.deleteTorrentWhenRemove = deleteTorrentWhenRemove;
    }

    @Override
    public void setDeleteDataWhenRemove(boolean deleteDataWhenRemove) {
        this.deleteDataWhenRemove = deleteDataWhenRemove;
    }

    @Override
    public String getHash() {
        return this.dl.getInfoHash();
    }

    @Override
    public String getSeedToPeerRatio() {
        return this.dl.getTotalSeeds() + "/" + this.dl.getTotalPeers();
    }

    @Override
    public String getShareRatio() {
        long sent = this.dl.getTotalBytesSent();
        long received = this.dl.getTotalBytesReceived();
        if (received < 0L) {
            return "0";
        }
        return String.valueOf((double)sent / (double)received);
    }

    @Override
    public boolean isPartialDownload() {
        return this.partial;
    }

    @Override
    public Date getDateCreated() {
        return this.dl.getCreated();
    }

    @Override
    public PaymentOptions getPaymentOptions() {
        this.setupMetadataHolder();
        return this.paymentOptions;
    }

    @Override
    public CopyrightLicenseBroker getCopyrightLicenseBroker() {
        this.setupMetadataHolder();
        return this.licenseBroker;
    }

    @Override
    public boolean canPreview() {
        this.checkSequentialDownload();
        return this.getPreviewFile() != null;
    }

    @Override
    public File getPreviewFile() {
        BTDownloadItem item = this.getFirstBiggestItem();
        if (item != null && MediaPlayer.isPlayableFile(item.getFile())) {
            long downloaded = item.getSequentialDownloaded();
            long size = item.getSize();
            if (size > 0L) {
                long percent = 100L * downloaded / size;
                String shareRatio = this.getShareRatio();
                return percent > 30L || downloaded > 0xA00000L || shareRatio.equalsIgnoreCase("Infinity") || shareRatio.equalsIgnoreCase("NaN") ? item.getFile() : null;
            }
        }
        return null;
    }

    void updateUI(com.frostwire.bittorrent.BTDownload dl) {
        this.displayName = dl.getDisplayName();
        this.size = this.calculateSize(dl);
        this.items = this.calculateItems(dl);
        this.partial = dl.isPartial();
    }

    private void checkSequentialDownload() {
        BTDownloadItem item = this.getFirstBiggestItem();
        if (item != null && MediaPlayer.isPlayableFile(item.getFile())) {
            long downloaded = item.getSequentialDownloaded();
            long size = item.getSize();
            if (size > 0L) {
                long percent = 100L * downloaded / size;
                if (percent > 30L || downloaded > 0xA00000L) {
                    if (this.dl.isSequentialDownload()) {
                        this.dl.setSequentialDownload(false);
                    }
                } else if (!this.dl.isSequentialDownload()) {
                    this.dl.setSequentialDownload(true);
                }
            }
        } else if (this.dl.isSequentialDownload()) {
            this.dl.setSequentialDownload(false);
        }
    }

    private BTDownloadItem getFirstBiggestItem() {
        BTDownloadItem item = null;
        for (TransferItem it : this.items) {
            if (!(it instanceof BTDownloadItem)) continue;
            BTDownloadItem bit = (BTDownloadItem)it;
            if (item == null) {
                item = bit;
                continue;
            }
            if (item.getSize() >= 0x200000L || item.getSize() >= bit.getSize()) continue;
            item = bit;
        }
        return item;
    }

    String makeMagnetUri() {
        return this.dl.magnetUri();
    }

    TorrentInfo getTorrentInfo() {
        return new TorrentInfo(this.dl.getTorrentFile());
    }

    private void setupMetadataHolder() {
        if (this.holder == null) {
            try {
                File torrent = this.dl.getTorrentFile();
                if (torrent != null && torrent.exists() && torrent.canRead()) {
                    this.holder = new BTInfoAdditionalMetadataHolder(torrent, this.getDisplayName());
                    this.licenseBroker = this.holder.getLicenseBroker();
                    this.paymentOptions = this.holder.getPaymentOptions();
                    if (this.paymentOptions != null) {
                        this.paymentOptions.setItemName(this.getDisplayName());
                    }
                }
            }
            catch (Throwable e) {
                LOG.error("Unable to setup licence holder");
            }
        }
    }

    private void finalCleanup(Set<File> incompleteFiles) {
        if (incompleteFiles != null) {
            for (File f : incompleteFiles) {
                try {
                    if (!f.exists() || f.delete()) continue;
                    LOG.warn("Can't delete file: " + f);
                }
                catch (Throwable e) {
                    LOG.warn("Can't delete file: " + f + ", ex: " + e.getMessage());
                }
            }
            File saveLocation = this.dl.getContentSavePath();
            if (saveLocation != null) {
                BittorrentDownload.deleteEmptyDirectoryRecursive(saveLocation);
                iTunesImportSettings.IMPORT_FILES.remove(saveLocation);
            }
        }
    }

    private static boolean deleteEmptyDirectoryRecursive(File directory) {
        String canonicalParent;
        try {
            canonicalParent = directory.getCanonicalPath();
        }
        catch (IOException ioe) {
            return false;
        }
        if (!directory.isDirectory()) {
            return false;
        }
        boolean canDelete = true;
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                try {
                    if (!file.getCanonicalPath().startsWith(canonicalParent)) {
                        continue;
                    }
                }
                catch (IOException ioe) {
                    canDelete = false;
                }
                if (BittorrentDownload.deleteEmptyDirectoryRecursive(file)) continue;
                canDelete = false;
            }
        }
        return canDelete && directory.delete();
    }

    private long calculateSize(com.frostwire.bittorrent.BTDownload dl) {
        long size = dl.getSize();
        boolean partial = dl.isPartial();
        if (partial) {
            List<TransferItem> items = dl.getItems();
            long totalSize = 0L;
            for (TransferItem item : items) {
                if (item.isSkipped()) continue;
                totalSize += item.getSize();
            }
            if (totalSize > 0L) {
                size = totalSize;
            }
        }
        return size;
    }

    private List<TransferItem> calculateItems(com.frostwire.bittorrent.BTDownload dl) {
        LinkedList<TransferItem> l = new LinkedList<TransferItem>();
        for (TransferItem item : dl.getItems()) {
            if (item.isSkipped()) continue;
            l.add(item);
        }
        return l;
    }

    static class RendererHelper {
        RendererHelper() {
        }

        static boolean canShareNow(BTDownload dl) {
            return dl instanceof BittorrentDownload && dl.isCompleted() || dl.isCompleted();
        }

        static void onSeedTransfer(BTDownload dl, boolean showShareTorrentDialog) {
            boolean canShareNow = RendererHelper.canShareNow(dl);
            if (!canShareNow) {
                System.out.println("Not doing anything.");
                return;
            }
            if (dl instanceof BittorrentDownload && dl.getState().equals((Object)TransferState.SEEDING) && !showShareTorrentDialog) {
                dl.pause();
                return;
            }
            GUIMediator.safeInvokeLater(() -> {
                if (dl instanceof BittorrentDownload && TorrentUtil.askForPermissionToSeedAndSeedDownloads(new BTDownload[]{dl}) && showShareTorrentDialog) {
                    new ShareTorrentDialog(GUIMediator.getAppFrame(), ((BittorrentDownload)dl).getTorrentInfo()).setVisible(true);
                } else if ((dl instanceof SoundcloudDownload || dl instanceof HttpDownload) && TorrentUtil.askForPermissionToSeedAndSeedDownloads(null)) {
                    new Thread(() -> {
                        TorrentUtil.makeTorrentAndDownload(dl.getSaveLocation(), null, showShareTorrentDialog);
                        dl.setDeleteDataWhenRemove(false);
                        GUIMediator.safeInvokeLater(() -> {
                            BTDownloadMediator.instance().remove(dl);
                            BTDownloadMediator.instance().updateTableFilters();
                        });
                    }).start();
                }
            });
        }
    }

    private class StatusListener
    implements BTDownloadListener {
        private StatusListener() {
        }

        @Override
        public void finished(com.frostwire.bittorrent.BTDownload dl) {
            if (!SharingSettings.SEED_FINISHED_TORRENTS.getValue()) {
                dl.pause();
                BittorrentDownload.this.finalCleanup(dl.getIncompleteFiles());
            }
            if (dl.getName() != null) {
                File saveLocation = new File(dl.getSavePath(), dl.getName());
                if (iTunesSettings.ITUNES_SUPPORT_ENABLED.getValue() && !iTunesMediator.instance().isScanned(saveLocation) && (OSUtils.isMacOSX() || OSUtils.isWindows())) {
                    iTunesMediator.instance().scanForSongs(saveLocation);
                }
                if (!LibraryMediator.instance().isScanned(dl.hashCode())) {
                    LibraryMediator.instance().scan(dl.hashCode(), saveLocation);
                }
            }
            GUIMediator.safeInvokeLater(() -> BTDownloadMediator.instance().updateTableFilters());
        }

        @Override
        public void removed(com.frostwire.bittorrent.BTDownload dl, Set<File> incompleteFiles) {
            BittorrentDownload.this.finalCleanup(incompleteFiles);
        }
    }
}

