/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.bittorrent;

import com.frostwire.gui.bittorrent.BTDownload;
import com.frostwire.gui.bittorrent.BTDownloadDataLine;
import com.frostwire.transfers.TransferState;
import com.limegroup.gnutella.gui.tables.BasicDataLineModel;
import java.util.HashSet;

public class BTDownloadModel
extends BasicDataLineModel<BTDownloadDataLine, BTDownload> {
    private HashSet<String> _hashDownloads = new HashSet();

    BTDownloadModel() {
        super(BTDownloadDataLine.class);
    }

    @Override
    public BTDownloadDataLine createDataLine() {
        return new BTDownloadDataLine();
    }

    int getActiveDownloads() {
        int size = this.getRowCount();
        int count = 0;
        for (int i = 0; i < size; ++i) {
            BTDownload downloader = (BTDownload)((BTDownloadDataLine)this.get(i)).getInitializeObject();
            if (downloader.isCompleted() || downloader.getState() != TransferState.DOWNLOADING) continue;
            ++count;
        }
        return count;
    }

    int getActiveUploads() {
        int size = this.getRowCount();
        int count = 0;
        for (int i = 0; i < size; ++i) {
            BTDownload downloader = (BTDownload)((BTDownloadDataLine)this.get(i)).getInitializeObject();
            if (!downloader.isCompleted() || downloader.getState() != TransferState.SEEDING) continue;
            ++count;
        }
        return count;
    }

    public int getTotalDownloads() {
        return this.getRowCount();
    }

    @Override
    public Object refresh() {
        try {
            int size = this.getRowCount();
            for (int i = 0; i < size; ++i) {
                BTDownloadDataLine ud = (BTDownloadDataLine)this.get(i);
                ud.update();
            }
            this.fireTableRowsUpdated(0, size);
        }
        catch (Exception e) {
            System.out.println("ATTENTION: Send the following output to the FrostWire Development team.");
            System.out.println("===============================START COPY & PASTE=======================================");
            e.printStackTrace();
            System.out.println("===============================END COPY & PASTE=======================================");
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public int add(BTDownload downloader) {
        this._hashDownloads.add(downloader.getHash());
        return super.add(downloader);
    }

    @Override
    public int add(BTDownload downloader, int row) {
        this._hashDownloads.add(downloader.getHash());
        return super.add(downloader, row);
    }

    @Override
    public void remove(int i) {
        BTDownloadDataLine line = (BTDownloadDataLine)this.get(i);
        BTDownload downloader = (BTDownload)line.getInitializeObject();
        downloader.remove();
        this._hashDownloads.remove(downloader.getHash());
        super.remove(i);
    }

    @Override
    public void remove(String hash) {
        this._hashDownloads.remove(hash);
    }

    public boolean isDownloading(String hash) {
        return this._hashDownloads.contains(hash);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == BTDownloadDataLine.PAYMENT_OPTIONS_COLUMN.getModelIndex() || columnIndex == BTDownloadDataLine.ACTIONS_COLUMN.getModelIndex() || columnIndex == BTDownloadDataLine.SEEDING_COLUMN.getModelIndex();
    }
}

