/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.database.sqlite;

import com.frostwire.content.Context;
import com.frostwire.database.sqlite.SQLiteDatabase;
import com.frostwire.database.sqlite.SQLiteException;
import com.frostwire.util.Logger;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;

public abstract class SQLiteOpenHelper {
    private static final Logger LOG = Logger.getLogger(SQLiteOpenHelper.class);
    private final String dbpath;
    private final SQLiteDatabase db;
    private String folderpath;

    public SQLiteOpenHelper(Context context, String name, SQLiteDatabase.CursorFactory factory, int version, String extraArgs) {
        this.dbpath = context.getDatabasePath(name).getAbsolutePath();
        this.db = this.openDatabase(this.dbpath, name, version, extraArgs);
    }

    public synchronized SQLiteDatabase getWritableDatabase() {
        return this.db;
    }

    public synchronized SQLiteDatabase getReadableDatabase() {
        return this.db;
    }

    public abstract void onCreate(SQLiteDatabase var1);

    public abstract void onUpgrade(SQLiteDatabase var1, int var2, int var3);

    public void onDowngrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        throw new SQLiteException("Can't downgrade database from version " + oldVersion + " to " + newVersion);
    }

    public void onOpen(SQLiteDatabase db) {
    }

    private SQLiteDatabase openDatabase(String dbpath, String name, int version, String extraArgs) {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("jdbc:h2:");
            this.folderpath = dbpath + "." + version;
            String fullpath = this.folderpath + File.separator + name;
            sb.append(fullpath);
            if (extraArgs != null) {
                sb.append(";").append(extraArgs);
            }
            boolean create = !new File(this.folderpath).exists();
            Connection connection = DriverManager.getConnection(sb.toString(), "SA", "");
            SQLiteDatabase db = new SQLiteDatabase(fullpath, connection);
            if (create) {
                this.onCreate(db);
            }
            return db;
        }
        catch (Throwable e) {
            LOG.error("Error opening the database", e);
            throw new RuntimeException(e);
        }
    }

    public long sizeInBytes() {
        File dbFolder;
        if (this.folderpath != null && (dbFolder = new File(this.folderpath)).exists() && dbFolder.isDirectory()) {
            return SQLiteOpenHelper.folderSize(dbFolder);
        }
        return 0L;
    }

    private static long folderSize(File directory) {
        long length = 0L;
        for (File file : directory.listFiles()) {
            if (file.isFile()) {
                length += file.length();
                continue;
            }
            length += SQLiteOpenHelper.folderSize(file);
        }
        return length;
    }
}

