/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.database.sqlite;

import com.frostwire.content.ContentValues;
import com.frostwire.database.Cursor;
import com.frostwire.database.SQLException;
import com.frostwire.util.Logger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;

public class SQLiteDatabase {
    private static final Logger LOG = Logger.getLogger(SQLiteDatabase.class);
    private String path;
    private Connection connection;
    private final AtomicBoolean open = new AtomicBoolean(false);

    public SQLiteDatabase(String path, Connection connection) {
        this.path = path;
        this.connection = connection;
        this.open.set(true);
    }

    public final String getPath() {
        return this.path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cursor rawQueryWithFactory(CursorFactory cursorFactory, String sql, String[] selectionArgs, String editTable) {
        this.verifyDbIsOpen();
        Cursor cursor = null;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            Connection connection = this.connection;
            synchronized (connection) {
                statement = this.prepareStatement(this.connection, sql, selectionArgs);
                resultSet = statement.executeQuery();
                return new Cursor(statement, resultSet);
            }
        }
        catch (Throwable e) {
            LOG.warn("Error performing SQL statement: " + sql, e);
            return cursor;
        }
    }

    public void execSQL(String sql) throws SQLException {
        this.executeSql(sql, null);
    }

    public void execSQL(String sql, Object[] bindArgs) throws SQLException {
        if (bindArgs == null) {
            throw new IllegalArgumentException("Empty bindArgs");
        }
        this.executeSql(sql, bindArgs);
    }

    public long insert(String table, String nullColumnHack, ContentValues values) {
        int size;
        this.verifyDbIsOpen();
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT");
        sql.append(" INTO ");
        sql.append(table);
        sql.append(" (");
        Object[] bindArgs = null;
        int n = size = values != null && values.size() > 0 ? values.size() : 0;
        if (size > 0) {
            bindArgs = new Object[size];
            int i = 0;
            for (String colName : values.keySet()) {
                sql.append(i > 0 ? "," : "");
                sql.append(colName);
                bindArgs[i++] = values.get(colName);
            }
            sql.append(')');
            sql.append(" VALUES (");
            for (i = 0; i < size; ++i) {
                sql.append(i > 0 ? ",?" : "?");
            }
        } else {
            sql.append(nullColumnHack + ") VALUES (NULL");
        }
        sql.append(')');
        return this.executeSql(sql.toString(), bindArgs);
    }

    public int delete(String table, String whereClause, String[] whereArgs) {
        this.verifyDbIsOpen();
        String sql = "DELETE FROM " + table + (!StringUtils.isEmpty(whereClause) ? " WHERE " + whereClause : "");
        return this.executeSql(sql, whereArgs);
    }

    public int update(String table, ContentValues values, String whereClause, String[] whereArgs) {
        this.verifyDbIsOpen();
        if (values == null || values.size() == 0) {
            throw new IllegalArgumentException("Empty values");
        }
        StringBuilder sql = new StringBuilder(120);
        sql.append("UPDATE ");
        sql.append(table);
        sql.append(" SET ");
        int setValuesSize = values.size();
        int bindArgsSize = whereArgs == null ? setValuesSize : setValuesSize + whereArgs.length;
        Object[] bindArgs = new Object[bindArgsSize];
        int i = 0;
        for (String colName : values.keySet()) {
            sql.append(i > 0 ? "," : "");
            sql.append(colName);
            bindArgs[i++] = values.get(colName);
            sql.append("=?");
        }
        if (whereArgs != null) {
            for (i = setValuesSize; i < bindArgsSize; ++i) {
                bindArgs[i] = whereArgs[i - setValuesSize];
            }
        }
        if (!StringUtils.isEmpty(whereClause)) {
            sql.append(" WHERE ");
            sql.append(whereClause);
        }
        return this.executeSql(sql.toString(), bindArgs);
    }

    public boolean isOpen() {
        return this.open.get();
    }

    public void close() {
        if (this.open.compareAndSet(true, false)) {
            try {
                Statement statement = this.connection.createStatement();
                statement.execute("SHUTDOWN");
                this.connection.close();
            }
            catch (Throwable e) {
                LOG.warn("Error closing the smart search database", e);
            }
        }
    }

    /*
     * Exception decompiling
     */
    private int executeSql(String sql, Object[] bindArgs) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String findEditTable(String tables) {
        if (!StringUtils.isEmpty(tables)) {
            int spacepos = tables.indexOf(32);
            int commapos = tables.indexOf(44);
            if (spacepos > 0 && (spacepos < commapos || commapos < 0)) {
                return tables.substring(0, spacepos);
            }
            if (commapos > 0 && (commapos < spacepos || spacepos < 0)) {
                return tables.substring(0, commapos);
            }
            return tables;
        }
        throw new IllegalStateException("Invalid tables");
    }

    void verifyDbIsOpen() {
        if (!this.isOpen()) {
            throw new IllegalStateException("database " + this.getPath() + " already closed");
        }
    }

    private PreparedStatement prepareStatement(Connection connection, String sql, Object ... arguments) throws Exception {
        PreparedStatement statement = connection.prepareStatement(sql, 1005, 1007);
        if (arguments != null) {
            for (int i = 0; i < arguments.length; ++i) {
                statement.setObject(i + 1, arguments[i]);
            }
        }
        return statement;
    }

    static {
        try {
            Class.forName("org.h2.Driver");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static interface CursorFactory {
    }
}

