/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.alexandria;

import com.frostwire.alexandria.Playlist;
import com.frostwire.alexandria.db.LibraryDB;
import com.frostwire.alexandria.db.LibraryDatabase;
import com.frostwire.alexandria.db.LibraryDatabaseEntity;
import com.frostwire.alexandria.db.PlaylistDB;
import java.io.File;
import java.util.Comparator;
import java.util.List;

public class Library
extends LibraryDatabaseEntity {
    private int _id;
    private String _name;
    private int _version;

    public Library(File libraryFile) {
        super(new LibraryDatabase(libraryFile));
        LibraryDB.fill(this.db, this);
    }

    public int getId() {
        return this._id;
    }

    public void setId(int id) {
        this._id = id;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public int getVersion() {
        return this._version;
    }

    public void setVersion(int version) {
        this._version = version;
    }

    public void close() {
        this.db.close();
    }

    public List<Playlist> getPlaylists() {
        List<Playlist> list = PlaylistDB.getPlaylists(this.db);
        list.sort(Comparator.comparing(Playlist::getName));
        return list;
    }

    public Playlist newPlaylist(String name, String description) {
        return new Playlist(this.db, -1, name, description);
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public Playlist getStarredPlaylist() {
        return PlaylistDB.getStarredPlaylist(this.db);
    }

    public void updatePlaylistItemProperties(String filePath, String title, String artist, String album, String comment, String genre, String track, String year) {
        PlaylistDB.updatePlaylistItemProperties(this.db, filePath, title, artist, album, comment, genre, track, year);
    }
}

