#include "ssh_diffie-hellman.h"
#include "ssh_crypto_common.h"
#include <stdlib.h>

static const int g = 2;

static const unsigned char prime_group1[]={
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xC9, 0x0F, 0xDA, 0xA2, 0x21, 0x68, 0xC2, 0x34,
	0xC4, 0xC6, 0x62, 0x8B, 0x80, 0xDC, 0x1C, 0xD1,
	0x29, 0x02, 0x4E, 0x08, 0x8A, 0x67, 0xCC, 0x74,
	0x02, 0x0B, 0xBE, 0xA6, 0x3B, 0x13, 0x9B, 0x22,
	0x51, 0x4A, 0x08, 0x79, 0x8E, 0x34, 0x04, 0xDD,
	0xEF, 0x95, 0x19, 0xB3, 0xCD, 0x3A, 0x43, 0x1B,
	0x30, 0x2B, 0x0A, 0x6D, 0xF2, 0x5F, 0x14, 0x37,
	0x4F, 0xE1, 0x35, 0x6D, 0x6D, 0x51, 0xC2, 0x45,
	0xE4, 0x85, 0xB5, 0x76, 0x62, 0x5E, 0x7E, 0xC6,
	0xF4, 0x4C, 0x42, 0xE9, 0xA6, 0x37, 0xED, 0x6B,
	0x0B, 0xFF, 0x5C, 0xB6, 0xF4, 0x06, 0xB7, 0xED,
	0xEE, 0x38, 0x6B, 0xFB, 0x5A, 0x89, 0x9F, 0xA5,
	0xAE, 0x9F, 0x24, 0x11, 0x7C, 0x4B, 0x1F, 0xE6,
	0x49, 0x28, 0x66, 0x51, 0xEC, 0xE6, 0x53, 0x81,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
};

static const unsigned char prime_group14[] = {
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xC9, 0x0F, 0xDA, 0xA2, 0x21, 0x68, 0xC2, 0x34,
	0xC4, 0xC6, 0x62, 0x8B, 0x80, 0xDC, 0x1C, 0xD1,
	0x29, 0x02, 0x4E, 0x08, 0x8A, 0x67, 0xCC, 0x74,
	0x02, 0x0B, 0xBE, 0xA6, 0x3B, 0x13, 0x9B, 0x22,
	0x51, 0x4A, 0x08, 0x79, 0x8E, 0x34, 0x04, 0xDD,
	0xEF, 0x95, 0x19, 0xB3, 0xCD, 0x3A, 0x43, 0x1B,
	0x30, 0x2B, 0x0A, 0x6D, 0xF2, 0x5F, 0x14, 0x37,
	0x4F, 0xE1, 0x35, 0x6D, 0x6D, 0x51, 0xC2, 0x45,
	0xE4, 0x85, 0xB5, 0x76, 0x62, 0x5E, 0x7E, 0xC6,
	0xF4, 0x4C, 0x42, 0xE9, 0xA6, 0x37, 0xED, 0x6B,
	0x0B, 0xFF, 0x5C, 0xB6, 0xF4, 0x06, 0xB7, 0xED,
	0xEE, 0x38, 0x6B, 0xFB, 0x5A, 0x89, 0x9F, 0xA5,
	0xAE, 0x9F, 0x24, 0x11, 0x7C, 0x4B, 0x1F, 0xE6,
	0x49, 0x28, 0x66, 0x51, 0xEC, 0xE4, 0x5B, 0x3D,
	0xC2, 0x00, 0x7C, 0xB8, 0xA1, 0x63, 0xBF, 0x05,
	0x98, 0xDA, 0x48, 0x36, 0x1C, 0x55, 0xD3, 0x9A,
	0x69, 0x16, 0x3F, 0xA8, 0xFD, 0x24, 0xCF, 0x5F,
	0x83, 0x65, 0x5D, 0x23, 0xDC, 0xA3, 0xAD, 0x96,
	0x1C, 0x62, 0xF3, 0x56, 0x20, 0x85, 0x52, 0xBB,
	0x9E, 0xD5, 0x29, 0x07, 0x70, 0x96, 0x96, 0x6D,
	0x67, 0x0C, 0x35, 0x4E, 0x4A, 0xBC, 0x98, 0x04,
	0xF1, 0x74, 0x6C, 0x08, 0xCA, 0x18, 0x21, 0x7C,
	0x32, 0x90, 0x5E, 0x46, 0x2E, 0x36, 0xCE, 0x3B,
	0xE3, 0x9E, 0x77, 0x2C, 0x18, 0x0E, 0x86, 0x03,
	0x9B, 0x27, 0x83, 0xA2, 0xEC, 0x07, 0xA2, 0x8F,
	0xB5, 0xC5, 0x5D, 0xF0, 0x6F, 0x4C, 0x52, 0xC9,
	0xDE, 0x2B, 0xCB, 0xF6, 0x95, 0x58, 0x17, 0x18,
	0x39, 0x95, 0x49, 0x7C, 0xEA, 0x95, 0x6A, 0xE5,
	0x15, 0xD2, 0x26, 0x18, 0x98, 0xFA, 0x05, 0x10,
	0x15, 0x72, 0x8E, 0x5A, 0x8A, 0xAC, 0xAA, 0x68,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
};

void
ssh_dh_free(SSH_DH *dh)
{
	BN_free(dh->g);
	BN_free(dh->p);
	ssh_md_ctx_free(dh->digest.mdctx);
	free(dh);
}

SSH_DH *
ssh_dh_group1_sha1(void)
{
	SSH_DH *dh = (SSH_DH*)malloc(sizeof(SSH_DH));
	dh->g = BN_new();
	dh->p = BN_new();
	dh->digest = (evp_md_t) {
		.mdctx = ssh_md_ctx_new(),
		.md = EVP_sha1(),
		.hashlen = SHA_DIGEST_LENGTH
	};
	BN_set_word(dh->g, g);
	BN_bin2bn(prime_group1, 128, dh->p);
	return dh;
}

SSH_DH *
ssh_dh_group14_sha1(void)
{
	SSH_DH *dh = (SSH_DH*)malloc(sizeof(SSH_DH));
	dh->g = BN_new();
	dh->p = BN_new();
	dh->digest = (evp_md_t) {
		.mdctx = ssh_md_ctx_new(),
		.md = EVP_sha1(),
		.hashlen = SHA_DIGEST_LENGTH
	};
	BN_set_word(dh->g, g);
	BN_bin2bn(prime_group14, 256, dh->p);
	return dh;
}

void
ssh_dh_hash(SSH_DH *dh, const unsigned char *in, unsigned char *out, size_t n)
{
	EVP_DigestInit_ex(dh->digest.mdctx, dh->digest.md, NULL);
	EVP_DigestUpdate(dh->digest.mdctx, in, n);
	EVP_DigestFinal_ex(dh->digest.mdctx, out, NULL);
}

struct
{
	const char *name;
	NEW_DH f;
} all_dh[] = {
	{ "diffie-hellman-group14-sha1", ssh_dh_group14_sha1 },
	{ "diffie-hellman-group1-sha1", ssh_dh_group1_sha1 },
	{ NULL, NULL }
};

NEW_DH
search_dh(const char *s)
{
	int i = search_name((name_sp)all_dh, s);
	if (i!=-1)
		return all_dh[i].f;
	else
		return NULL;
}

const char all_dh_list[] = "diffie-hellman-group14-sha1,diffie-hellman-group1-sha1";
