# Note that this is NOT a relocatable package
# This specfile is a generic one aimed primarily at obs builds

%define  RELEASE 1
%define  rel     %{?CUSTOM_RELEASE} %{!?CUSTOM_RELEASE:%RELEASE}

# define an appropriate suffix for the packages
%if 0%{?mgaversion}
%define sys     mga%{mgaversion}
%endif
%if 0%{?mageia}
%define sys     mga%{mageia}
%endif
%if 0%{?suse_version}
%define sys     suse%{suse_version}
%endif
%if 0%{?sles_version}
%define sys     sles%{sles_version}
%endif
%if 0%{?fedora_version}
%define sys     fdv%{fedora_version}
%endif
%if 0%{?rhel_version}
%define sys     rhel%{rhel_version}
%endif
%if 0%{?centos_version}
%define sys     centos%{centos_version}
%endif
%if 0%{?scientificlinux_version}
%define sys     sfl%{scientificlinux_version}
%endif

Name:           etherape
Summary:        Graphical network viewer modeled after etherman
Version:        0.9.20
Release:        %{rel}.obs%{sys}
License:        GPLv2+
URL:            http://etherape.sourceforge.io/
Source:         http://prdownloads.sourceforge.net/%{name}/%{name}-%{version}.tar.gz
Autoreqprov:    on

%if 0%{?fedora_version} || 0%{?rhel_version} || 0%{?centos_version} || 0%{?scientificlinux_version}
Group:          Applications/System
%else
%if 0%{?suse_version} || 0%{?sles_version}
Group:          Productivity/Networking/Diagnostic
%else
Group:          Monitoring
%endif
%endif

BuildRoot:      %{_tmppath}/%{name}-%{version}

#Docdir: %{prefix}/doc

# common requisites
BuildRequires: libpcap-devel
BuildRequires: gettext
BuildRequires: autoconf
BuildRequires: pkgconfig
BuildRequires: libtool
BuildRequires: popt-devel

# Mageia
%if 0%{?mageia}|| 0%{?mgaversion}
BuildRequires: libgoocanvas2-devel
BuildRequires: desktop-file-utils
BuildRequires: polkit-gnome
BuildRequires: gettext-devel
BuildRequires: autoconf-archive
%endif

# OpenSuSe - SLES
%if 0%{?suse_version} || 0%{?sles_version} || 0%{?sle_version}
BuildRequires: goocanvas-devel
BuildRequires: gettext-tools
BuildRequires: fdupes
BuildRequires: update-desktop-files
%if 0%{?is_opensuse}
BuildRequires: autoconf-archive
%endif
%endif

# CentOS
%if 0%{?centos_version}
BuildRequires: goocanvas2-devel
BuildRequires: gettext-devel
%endif

# ScientificLinux
%if 0%{?scientificlinux_version}
BuildRequires: goocanvas2-devel
BuildRequires: gettext-devel
%endif

# RHEL
%if 0%{?rhel_version}
BuildRequires: goocanvas2-devel
BuildRequires: gettext-devel
%if 0%{?centos_version} > 600
BuildRequires: autoconf-archive
%endif
%endif

# Fedora
%if 0%{?fedora_version}
BuildRequires: goocanvas2-devel
BuildRequires: gettext-devel
BuildRequires: autoconf-archive
%endif


#####
# help dependencies
#####
# common dependencies for autoreconf
BuildRequires: yelp-tools
BuildRequires: itstool

# mageia
%if 0%{?mageia}|| 0%{?mgaversion}
BuildRequires: gnome-doc-utils
BuildRequires: rarian
%endif

# OpenSuSe - SLES
%if 0%{?suse_version} || 0%{?sles_version}
BuildRequires: docbook_4
BuildRequires: fdupes
BuildRequires: sed
%if ( 0%{?is_opensuse} )
%if 0%{?suse_version} > 1320 || 0%{?suse_version} == 1315
# leap and tumbleweed
BuildRequires: scrollkeeper
%else
# others
BuildRequires: rarian-scrollkeeper-compat
%endif
%else
# !is_opensuse, i.e. SLES
%if 0%{?suse_version} > 1110
#BuildRequires: rarian-scrollkeeper-compat
%endif
%endif
%endif

# CentOS
%if 0%{?centos_version}
BuildRequires: rarian
BuildRequires: rarian-compat
%endif

# ScientificLinux
%if 0%{?scientificlinux_version}
BuildRequires: gnome-doc-utils
BuildRequires: rarian
BuildRequires: rarian-compat
%endif

# RHEL
%if 0%{?rhel_version}
BuildRequires: gnome-doc-utils
%if 0%{?rhel_version} < 600
BuildRequires: scrollkeeper
%else
BuildRequires: rarian
BuildRequires: rarian-compat
%endif
%endif

%if 0%{?fedora_version}
BuildRequires: gnome-doc-utils
BuildRequires: rarian
BuildRequires: rarian-compat
# fedora24 needs a text browser for docbook-utils
BuildRequires: w3m
%endif
#####
# help end
#####



%description
Etherape is a graphical network monitor for Unix modeled after
etherman. Featuring link level, ip and tcp modes, it displays network
activity graphically. Hosts and links change in size with traffic.
Color coded protocols display. It supports ethernet, fddi, ppp, slip, wlan
and other devices. It can filter traffic to be shown, and can read traffic
from a file as well as live from the network.


%prep
%setup -q
%{__rm} -rf .hg
%if 0%{?suse_version} || 0%{?sles_version}
%__sed -ie "s#http://www.oasis-open.org/docbook/xml/4.1.2/docbookx.dtd#file:///usr/share/sgml/docbook/dtd/4.2/docbookx.dtd#" doc/C/index.docbook
%__cat >> etherape.desktop.in << _EOF_
X-KDE-SubstituteUID=true
X-KDE-Username=root
_EOF_
%endif

%build
%if 0%{?suse_version} || 0%{?sles_version}
autoreconf -fi
%configure --with-pic --disable-scrollkeeper
#%if 0%{?is_opensuse} || ( ! 0%{?suse_version} == 1315 )
# apparently opensuse has a broken xmllib configuration, missing an alias
# for omf dtd
%__sed -ie "s#--dtdvalid 'http://scrollkeeper.sourceforge.net/dtds/scrollkeeper-omf-1.0/scrollkeeper-omf.dtd'#--dtdvalidfpi \\\"-//OMF//DTD Scrollkeeper OMF Variant V1.0//EN\\\"#" doc/Makefile
#%endif
%else
%if 0%{?fedora_version} || 0%{?rhel_version} || 0%{?centos_version} || 0%{?scientificlinux_version}
%if 0%{?rhel_version}>550 || 0%{?centos_version}>550 || 0%{?scientificlinux_version}>550
autoreconf -fi
%else
# using -fi on rhel5 and likes will fail build
autoreconf
%endif
%endif
%if 0%{?mgaversion}
%configure2_5x --bindir=%{_sbindir}
%else
%configure --bindir=%{_sbindir}
%endif
%endif

%__make %{?_smp_flags}

%check
%__make check

%install
%__rm -rf %{buildroot}
%__mkdir %{buildroot}
%__make install DESTDIR=%{buildroot}
%find_lang %{name}

%if 0%{?suse_version} || 0%{?sles_version}
%fdupes %{buildroot}
%endif

%clean
%{__rm} -rf %{buildroot}

%files -f %{name}.lang
%defattr(-, root, root)
%{_datadir}/applications/etherape.desktop
%{_datadir}/%{name}
%{_datadir}/pixmaps/etherape.png
%if 0%{?suse_version} || 0%{?sles_version}
%{_bindir}/etherape
%else
%{_sbindir}/etherape
%endif
%doc AUTHORS COPYING TODO NEWS README* FAQ
%{_mandir}/man1/%{name}.1*
%docdir %{_datadir}/help/C/%{name}
%doc %{_datadir}/help/C/%{name}/**

%post

%postun


%changelog
* Sat Nov 11 2017 R.Ghetta <bchiara@users.sf.net> 0.9.15
- move away from gnome-doc-utils and other deprecation work

* Sat Oct  8 2016 R.Ghetta <bchiara@users.sf.net> 0.9.15
- updates for new release

* Sat Feb  6 2016 R.Ghetta <bchiara@users.sf.net> 0.9.14
- fixes for newer distributions

* Sat Sep 19 2015 R.Ghetta <bchiara@users.sf.net> 0.9.14
- updated for newer distributions

* Sat Jun  6 2015 R.Ghetta <bchiara@users.sf.net>
- remove custom services file

* Tue Feb 15 2011 R.Ghetta <bchiara@users.sf.net>
- adapting for OpenSUSE build service

* Sun Jan 3 2010 R.Ghetta <bchiara@users.sf.net>
- change manual build

* Sat May 6 2006 R.Ghetta <bchiara@users.sf.net>
- a bit of modernization

* Mon Apr 3 2000 Juan Toledo <toledo@sourceforge.net>
- Initial spec file copied from electric eyes
