/*
 * Decompiled with CFR 0.152.
 */
package davmail.ui;

import davmail.util.IOUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.log4j.Logger;

public class OSXInfoPlist {
    protected static final Logger LOGGER = Logger.getLogger(OSXInfoPlist.class);
    protected static final String INFO_PLIST_PATH = "../Info.plist";

    private OSXInfoPlist() {
    }

    protected static boolean isOSX() {
        return System.getProperty("os.name").toLowerCase().startsWith("mac os x");
    }

    protected static String getInfoPlistContent() throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(OSXInfoPlist.getInfoPlistPath());){
            String string = new String(IOUtil.readFully(fileInputStream), StandardCharsets.UTF_8);
            return string;
        }
    }

    public static boolean isHideFromDock() {
        boolean result = false;
        try {
            result = OSXInfoPlist.isOSX() && OSXInfoPlist.getInfoPlistContent().contains("<key>LSUIElement</key><string>1</string>");
        }
        catch (IOException e) {
            LOGGER.warn((Object)"Unable to update Info.plist", (Throwable)e);
        }
        return result;
    }

    public static void setOSXHideFromDock(boolean hideFromDock) {
        block14: {
            try {
                boolean currentHideFromDock;
                if (!OSXInfoPlist.isOSX() || (currentHideFromDock = OSXInfoPlist.isHideFromDock()) == hideFromDock) break block14;
                String content = OSXInfoPlist.getInfoPlistContent();
                try (FileOutputStream fileOutputStream = new FileOutputStream(OSXInfoPlist.getInfoPlistPath());){
                    fileOutputStream.write(content.replaceFirst("<key>LSUIElement</key><string>" + (currentHideFromDock ? "1" : "0") + "</string>", "<key>LSUIElement</key><string>" + (hideFromDock ? "1" : "0") + "</string>").getBytes(StandardCharsets.UTF_8));
                }
            }
            catch (IOException e) {
                LOGGER.warn((Object)"Unable to update Info.plist", (Throwable)e);
            }
        }
    }

    private static String getInfoPlistPath() throws IOException {
        File file = new File(INFO_PLIST_PATH);
        if (file.exists()) {
            return INFO_PLIST_PATH;
        }
        throw new IOException("Info.plist file not found");
    }
}

