/*
 * Decompiled with CFR 0.152.
 */
package davmail.http.request;

import davmail.http.HttpClientAdapter;
import davmail.http.request.ResponseWrapper;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.message.BasicNameValuePair;

public class PostRequest
extends HttpPost
implements ResponseHandler<String>,
ResponseWrapper {
    private ArrayList<NameValuePair> parameters = new ArrayList();
    private String responseBodyAsString = null;
    private HttpResponse response;

    public PostRequest(URI uri) {
        super(uri);
    }

    public PostRequest(String url) {
        super(URI.create(url));
    }

    public void setRequestHeader(String name, String value) {
        this.setHeader(name, value);
    }

    public HttpEntity getEntity() {
        return new UrlEncodedFormEntity(this.parameters, Consts.UTF_8);
    }

    public String handleResponse(HttpResponse response) throws IOException {
        this.response = response;
        if (HttpClientAdapter.isRedirect(response)) {
            return null;
        }
        this.responseBodyAsString = new BasicResponseHandler().handleResponse(response);
        return this.responseBodyAsString;
    }

    public void setParameter(String name, String value) {
        this.parameters.add((NameValuePair)new BasicNameValuePair(name, value));
    }

    public void removeParameter(String name) {
        ArrayList<NameValuePair> toDelete = new ArrayList<NameValuePair>();
        for (NameValuePair param : this.parameters) {
            if (!param.getName().equals(name)) continue;
            toDelete.add(param);
        }
        this.parameters.removeAll(toDelete);
    }

    public ArrayList<NameValuePair> getParameters() {
        return this.parameters;
    }

    @Override
    public String getResponseBodyAsString() throws IOException {
        if (this.responseBodyAsString == null) {
            throw new IOException("No response body available");
        }
        return this.responseBodyAsString;
    }

    public Header getResponseHeader(String name) {
        this.checkResponse();
        return this.response.getFirstHeader(name);
    }

    @Override
    public int getStatusCode() {
        this.checkResponse();
        return this.response.getStatusLine().getStatusCode();
    }

    public String getReasonPhrase() {
        this.checkResponse();
        return this.response.getStatusLine().getReasonPhrase();
    }

    public URI getRedirectLocation() {
        this.checkResponse();
        return HttpClientAdapter.getRedirectLocation(this.response);
    }

    @Override
    public HttpResponse getHttpResponse() {
        return this.response;
    }

    private void checkResponse() {
        if (this.response == null) {
            throw new IllegalStateException("Should execute request first");
        }
    }
}

