/*
 * Decompiled with CFR 0.152.
 */
package davmail.http;

import davmail.http.KerberosHelper;
import javax.security.auth.login.LoginException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.auth.AuthChallengeException;
import org.apache.commons.httpclient.auth.AuthChallengeParser;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.auth.AuthenticationException;
import org.apache.commons.httpclient.auth.CredentialsNotAvailableException;
import org.apache.commons.httpclient.auth.InvalidCredentialsException;
import org.apache.commons.httpclient.auth.MalformedChallengeException;
import org.apache.commons.httpclient.util.EncodingUtil;
import org.ietf.jgss.GSSException;

public class SpNegoScheme
implements AuthScheme {
    private static final int UNINITIATED = 0;
    private static final int INITIATED = 1;
    private static final int TYPE1_MSG_GENERATED = 2;
    private static final int TYPE2_MSG_RECEIVED = 3;
    private static final int TYPE3_MSG_GENERATED = 4;
    private static final int FAILED = Integer.MAX_VALUE;
    private byte[] serverToken;
    private int state;

    public void processChallenge(String challenge) throws MalformedChallengeException {
        String authScheme = AuthChallengeParser.extractScheme((String)challenge);
        if (!authScheme.equalsIgnoreCase(this.getSchemeName())) {
            throw new MalformedChallengeException("Invalid Negotiate challenge: " + challenge);
        }
        int spaceIndex = challenge.indexOf(32);
        if (spaceIndex != -1) {
            this.serverToken = Base64.decodeBase64(EncodingUtil.getBytes((String)challenge.substring(spaceIndex).trim(), (String)"ASCII"));
            this.state = 3;
        } else {
            this.serverToken = null;
            this.state = this.state == 0 ? 1 : Integer.MAX_VALUE;
        }
    }

    public String getSchemeName() {
        return "Negotiate";
    }

    public String getParameter(String s) {
        return null;
    }

    public String getRealm() {
        return null;
    }

    @Deprecated
    public String getID() {
        throw new UnsupportedOperationException();
    }

    public boolean isConnectionBased() {
        return true;
    }

    public boolean isComplete() {
        return this.state == 4 || this.state == Integer.MAX_VALUE;
    }

    @Deprecated
    public String authenticate(Credentials credentials, String method, String uri) {
        throw new UnsupportedOperationException();
    }

    public String authenticate(Credentials credentials, HttpMethod httpMethod) throws AuthenticationException {
        String response;
        Header header;
        if (this.state == 0) {
            throw new IllegalStateException("Negotiate authentication process has not been initiated");
        }
        String host = null;
        try {
            host = httpMethod.getURI().getHost();
        }
        catch (URIException uRIException) {
            // empty catch block
        }
        if (host == null && (header = httpMethod.getRequestHeader("Host")) != null && (host = header.getValue()).indexOf(58) >= 0) {
            host = host.substring(0, host.indexOf(58));
        }
        if (host == null) {
            throw new IllegalStateException("Negotiate authentication failed: empty host");
        }
        try {
            if (this.state == 1 || this.state == Integer.MAX_VALUE) {
                response = EncodingUtil.getAsciiString((byte[])Base64.encodeBase64(KerberosHelper.initSecurityContext("HTTP", host, new byte[0])));
                this.state = 2;
            } else {
                response = EncodingUtil.getAsciiString((byte[])Base64.encodeBase64(KerberosHelper.initSecurityContext("HTTP", host, this.serverToken)));
                this.state = 4;
            }
        }
        catch (GSSException gsse) {
            this.state = Integer.MAX_VALUE;
            if (gsse.getMajor() == 9 || gsse.getMajor() == 8) {
                throw new InvalidCredentialsException(gsse.getMessage(), (Throwable)gsse);
            }
            if (gsse.getMajor() == 13) {
                throw new CredentialsNotAvailableException(gsse.getMessage(), (Throwable)gsse);
            }
            if (gsse.getMajor() == 10 || gsse.getMajor() == 19 || gsse.getMajor() == 20) {
                throw new AuthChallengeException(gsse.getMessage(), (Throwable)gsse);
            }
            throw new AuthenticationException(gsse.getMessage(), (Throwable)gsse);
        }
        catch (LoginException e) {
            this.state = Integer.MAX_VALUE;
            throw new InvalidCredentialsException(e.getMessage(), (Throwable)e);
        }
        return "Negotiate " + response;
    }
}

