/*
 * Decompiled with CFR 0.152.
 */
package davmail.exchange.auth;

import davmail.Settings;
import davmail.exception.DavMailAuthenticationException;
import davmail.exchange.auth.ExchangeAuthenticator;
import davmail.exchange.auth.O365Token;
import davmail.http.HttpClientAdapter;
import davmail.http.request.GetRequest;
import davmail.http.request.PostRequest;
import davmail.http.request.RestRequest;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.client.utils.URIBuilder;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class O365Authenticator
implements ExchangeAuthenticator {
    protected static final Logger LOGGER = Logger.getLogger(O365Authenticator.class);
    private static final String RESOURCE = "https://outlook.office365.com";
    private String tenantId;
    private String username;
    private String userid;
    private String password;
    private O365Token token;

    public static String buildAuthorizeUrl(String tenantId, String clientId, String redirectUri, String username) throws IOException {
        URI uri;
        try {
            URIBuilder uriBuilder = new URIBuilder().setScheme("https").setHost("login.microsoftonline.com").addParameter("client_id", clientId).addParameter("response_type", "code").addParameter("redirect_uri", redirectUri).addParameter("response_mode", "query").addParameter("login_hint", username);
            if (Settings.getBooleanProperty("davmail.enableOidc", false)) {
                uriBuilder.setPath("/" + tenantId + "/oauth2/v2.0/authorize").addParameter("scope", "openid https://outlook.office365.com/EWS.AccessAsUser.All");
            } else {
                uriBuilder.setPath("/" + tenantId + "/oauth2/authorize").addParameter("resource", RESOURCE);
            }
            uri = uriBuilder.build();
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        return uri.toString();
    }

    @Override
    public void setUsername(String username) {
        if (username.contains("|")) {
            this.userid = username.substring(0, username.indexOf("|"));
            this.username = username.substring(username.indexOf("|") + 1);
        } else {
            this.username = username;
            this.userid = username;
        }
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public O365Token getToken() {
        return this.token;
    }

    @Override
    public URI getExchangeUri() {
        return URI.create("https://outlook.office365.com/EWS/Exchange.asmx");
    }

    @Override
    public void authenticate() throws IOException {
        try (HttpClientAdapter httpClientAdapter = null;){
            String code;
            GetRequest getRequest;
            String clientId = Settings.getProperty("davmail.oauth.clientId", "facd6cff-a294-4415-b59f-c5b01937d7bd");
            String redirectUri = Settings.getProperty("davmail.oauth.redirectUri", "https://login.microsoftonline.com/common/oauth2/nativeclient");
            this.tenantId = Settings.getProperty("davmail.oauth.tenantId", "common");
            this.token = O365Token.load(this.tenantId, clientId, redirectUri, this.username, this.password);
            if (this.token != null) {
                return;
            }
            String url = O365Authenticator.buildAuthorizeUrl(this.tenantId, clientId, redirectUri, this.username);
            httpClientAdapter = new HttpClientAdapter(url, this.userid, this.password);
            String responseBodyAsString = this.executeFollowRedirect(httpClientAdapter, getRequest = new GetRequest(url));
            if (!responseBodyAsString.contains("Config=")) {
                code = this.authenticateADFS(httpClientAdapter, responseBodyAsString, url);
            } else {
                JSONObject config = this.extractConfig(responseBodyAsString);
                String context = config.getString("sCtx");
                String apiCanary = config.getString("apiCanary");
                String clientRequestId = config.getString("correlationId");
                String hpgact = config.getString("hpgact");
                String hpgid = config.getString("hpgid");
                String flowToken = config.getString("sFT");
                String canary = config.getString("canary");
                String sessionId = config.getString("sessionId");
                String referer = getRequest.getURI().toString();
                RestRequest getCredentialMethod = new RestRequest("https://login.microsoftonline.com/" + this.tenantId + "/GetCredentialType");
                getCredentialMethod.setRequestHeader("Accept", "application/json");
                getCredentialMethod.setRequestHeader("canary", apiCanary);
                getCredentialMethod.setRequestHeader("client-request-id", clientRequestId);
                getCredentialMethod.setRequestHeader("hpgact", hpgact);
                getCredentialMethod.setRequestHeader("hpgid", hpgid);
                getCredentialMethod.setRequestHeader("hpgrequestid", sessionId);
                getCredentialMethod.setRequestHeader("Referer", referer);
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("username", (Object)this.username);
                jsonObject.put("isOtherIdpSupported", true);
                jsonObject.put("checkPhones", false);
                jsonObject.put("isRemoteNGCSupported", false);
                jsonObject.put("isCookieBannerShown", false);
                jsonObject.put("isFidoSupported", false);
                jsonObject.put("flowToken", (Object)flowToken);
                jsonObject.put("originalRequest", (Object)context);
                getCredentialMethod.setJsonBody(jsonObject);
                JSONObject credentialType = httpClientAdapter.executeRestRequest(getCredentialMethod);
                LOGGER.debug((Object)("CredentialType=" + credentialType));
                JSONObject credentials = credentialType.getJSONObject("Credentials");
                String federationRedirectUrl = credentials.optString("FederationRedirectUrl");
                if (federationRedirectUrl != null && !federationRedirectUrl.isEmpty()) {
                    LOGGER.debug((Object)("Detected ADFS, redirecting to " + federationRedirectUrl));
                    code = this.authenticateRedirectADFS(httpClientAdapter, federationRedirectUrl, url);
                } else {
                    PostRequest logonMethod = new PostRequest("https://login.microsoftonline.com/" + this.tenantId + "/login");
                    logonMethod.setRequestHeader("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
                    logonMethod.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
                    logonMethod.setRequestHeader("Referer", referer);
                    logonMethod.setParameter("canary", canary);
                    logonMethod.setParameter("ctx", context);
                    logonMethod.setParameter("flowToken", flowToken);
                    logonMethod.setParameter("hpgrequestid", sessionId);
                    logonMethod.setParameter("login", this.username);
                    logonMethod.setParameter("loginfmt", this.username);
                    logonMethod.setParameter("passwd", this.password);
                    responseBodyAsString = httpClientAdapter.executePostRequest(logonMethod);
                    URI location = logonMethod.getRedirectLocation();
                    if (responseBodyAsString != null && responseBodyAsString.indexOf("arrUserProofs") > 0) {
                        location = this.handleMfa(httpClientAdapter, logonMethod, this.username, clientRequestId);
                    }
                    if (location == null || !location.toString().startsWith(redirectUri)) {
                        config = this.extractConfig(logonMethod.getResponseBodyAsString());
                        if (config.optJSONArray("arrScopes") != null || config.optJSONArray("urlPostRedirect") != null) {
                            LOGGER.debug((Object)"Authentication successful but user consent or validation needed, please open the following url in a browser");
                            LOGGER.debug((Object)url);
                            throw new DavMailAuthenticationException("EXCEPTION_AUTHENTICATION_FAILED");
                        }
                        if (config.optString("strServiceExceptionMessage") != null) {
                            LOGGER.debug((Object)("O365 returned error: " + config.optString("strServiceExceptionMessage")));
                            throw new DavMailAuthenticationException("EXCEPTION_AUTHENTICATION_FAILED");
                        }
                        if ("50126".equals(config.optString("sErrorCode"))) {
                            throw new DavMailAuthenticationException("EXCEPTION_AUTHENTICATION_FAILED");
                        }
                        throw new DavMailAuthenticationException("LOG_MESSAGE", "Authentication failed, unknown error: " + config);
                    }
                    String query = location.toString();
                    code = query.substring(query.indexOf("code=") + 5, query.indexOf("&session_state="));
                }
            }
            LOGGER.debug((Object)("Authentication Code: " + code));
            this.token = O365Token.build(this.tenantId, clientId, redirectUri, code, this.password);
            LOGGER.debug((Object)("Authenticated username: " + this.token.getUsername()));
            if (!this.username.equalsIgnoreCase(this.token.getUsername())) {
                throw new IOException("Authenticated username " + this.token.getUsername() + " does not match " + this.username);
            }
        }
    }

    private String authenticateRedirectADFS(HttpClientAdapter httpClientAdapter, String federationRedirectUrl, String authorizeUrl) throws IOException {
        GetRequest logonFormMethod = new GetRequest(federationRedirectUrl);
        String responseBodyAsString = httpClientAdapter.executeGetRequest(logonFormMethod);
        return this.authenticateADFS(httpClientAdapter, responseBodyAsString, authorizeUrl);
    }

    private String authenticateADFS(HttpClientAdapter httpClientAdapter, String responseBodyAsString, String authorizeUrl) throws IOException {
        String query;
        URI location;
        if (responseBodyAsString.contains("login.microsoftonline.com")) {
            LOGGER.info((Object)"Already authenticated through Basic or NTLM");
        } else {
            PostRequest logonMethod = new PostRequest(this.extract("method=\"post\" action=\"([^\"]+)\"", responseBodyAsString));
            logonMethod.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
            logonMethod.setParameter("UserName", this.userid);
            logonMethod.setParameter("Password", this.password);
            logonMethod.setParameter("AuthMethod", "FormsAuthentication");
            httpClientAdapter.executePostRequest(logonMethod);
            location = logonMethod.getRedirectLocation();
            if (location == null) {
                throw new DavMailAuthenticationException("EXCEPTION_AUTHENTICATION_FAILED");
            }
            GetRequest redirectMethod = new GetRequest(location);
            responseBodyAsString = httpClientAdapter.executeGetRequest(redirectMethod);
        }
        if (!responseBodyAsString.contains("login.microsoftonline.com")) {
            throw new DavMailAuthenticationException("EXCEPTION_AUTHENTICATION_FAILED");
        }
        String targetUrl = this.extract("action=\"([^\"]+)\"", responseBodyAsString);
        String wa = this.extract("name=\"wa\" value=\"([^\"]+)\"", responseBodyAsString);
        String wresult = this.extract("name=\"wresult\" value=\"([^\"]+)\"", responseBodyAsString);
        wresult = wresult.replaceAll("&quot;", "\"");
        wresult = wresult.replaceAll("&lt;", "<");
        wresult = wresult.replaceAll("&gt;", ">");
        String wctx = this.extract("name=\"wctx\" value=\"([^\"]+)\"", responseBodyAsString);
        wctx = wctx.replaceAll("&amp;", "&");
        PostRequest targetMethod = new PostRequest(targetUrl);
        targetMethod.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
        targetMethod.setParameter("wa", wa);
        targetMethod.setParameter("wresult", wresult);
        targetMethod.setParameter("wctx", wctx);
        responseBodyAsString = httpClientAdapter.executePostRequest(targetMethod);
        location = targetMethod.getRedirectLocation();
        LOGGER.debug((Object)targetMethod.getURI().toString());
        LOGGER.debug((Object)targetMethod.getReasonPhrase());
        LOGGER.debug((Object)responseBodyAsString);
        if (targetMethod.getStatusCode() == 200) {
            JSONObject config = this.extractConfig(responseBodyAsString);
            if (config.optJSONArray("arrScopes") != null || config.optJSONArray("urlPostRedirect") != null) {
                LOGGER.debug((Object)"Authentication successful but user consent or validation needed, please open the following url in a browser");
                LOGGER.debug((Object)authorizeUrl);
                throw new DavMailAuthenticationException("EXCEPTION_AUTHENTICATION_FAILED");
            }
        } else if (targetMethod.getStatusCode() != 302 || location == null) {
            throw new IOException("Unknown ADFS authentication failure");
        }
        if ("device.login.microsoftonline.com".equals(location.getHost())) {
            location = this.processDeviceLogin(httpClientAdapter, location);
        }
        if ((query = location.getQuery()) == null) {
            query = location.getSchemeSpecificPart();
        }
        if (query.contains("code=") && query.contains("&session_state=")) {
            String code = query.substring(query.indexOf("code=") + 5, query.indexOf("&session_state="));
            LOGGER.debug((Object)("Authentication Code: " + code));
            return code;
        }
        throw new IOException("Unknown ADFS authentication failure");
    }

    private URI processDeviceLogin(HttpClientAdapter httpClient, URI location) throws IOException {
        URI result = location;
        LOGGER.debug((Object)"Proceed to device authentication");
        GetRequest deviceLoginMethod = new GetRequest(location);
        String responseBodyAsString = httpClient.executeGetRequest(deviceLoginMethod);
        if (responseBodyAsString.contains("login.microsoftonline.com")) {
            String ctx = this.extract("name=\"ctx\" value=\"([^\"]+)\"", responseBodyAsString);
            String flowtoken = this.extract("name=\"flowtoken\" value=\"([^\"]+)\"", responseBodyAsString);
            PostRequest processMethod = new PostRequest(this.extract("action=\"([^\"]+)\"", responseBodyAsString));
            processMethod.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
            processMethod.setParameter("ctx", ctx);
            processMethod.setParameter("flowtoken", flowtoken);
            httpClient.executePostRequest(processMethod);
            result = processMethod.getRedirectLocation();
            if (result == null) {
                throw new DavMailAuthenticationException("EXCEPTION_AUTHENTICATION_FAILED");
            }
        }
        return result;
    }

    private URI handleMfa(HttpClientAdapter httpClientAdapter, PostRequest logonMethod, String username, String clientRequestId) throws JSONException, IOException {
        JSONObject config = this.extractConfig(logonMethod.getResponseBodyAsString());
        LOGGER.debug((Object)("Config=" + config));
        String urlBeginAuth = config.getString("urlBeginAuth");
        String urlEndAuth = config.getString("urlEndAuth");
        boolean isMFAMethodSupported = false;
        for (int i = 0; i < config.getJSONArray("arrUserProofs").length(); ++i) {
            JSONObject authMethod = (JSONObject)config.getJSONArray("arrUserProofs").get(i);
            LOGGER.debug((Object)("Authentication method: " + authMethod.getString("authMethodId")));
            if (!"PhoneAppNotification".equals(authMethod.getString("authMethodId"))) continue;
            LOGGER.debug((Object)("Found phone app auth method " + authMethod.getString("display")));
            isMFAMethodSupported = true;
        }
        if (!isMFAMethodSupported) {
            throw new IOException("MFA authentication methods not supported");
        }
        String context = config.getString("sCtx");
        String flowToken = config.getString("sFT");
        String canary = config.getString("canary");
        String apiCanary = config.getString("apiCanary");
        String hpgrequestid = logonMethod.getResponseHeader("x-ms-request-id").getValue();
        String hpgact = config.getString("hpgact");
        String hpgid = config.getString("hpgid");
        RestRequest beginAuthMethod = new RestRequest(urlBeginAuth);
        beginAuthMethod.setRequestHeader("Accept", "application/json");
        beginAuthMethod.setRequestHeader("canary", apiCanary);
        beginAuthMethod.setRequestHeader("client-request-id", clientRequestId);
        beginAuthMethod.setRequestHeader("hpgact", hpgact);
        beginAuthMethod.setRequestHeader("hpgid", hpgid);
        beginAuthMethod.setRequestHeader("hpgrequestid", hpgrequestid);
        JSONObject beginAuthJson = new JSONObject();
        beginAuthJson.put("AuthMethodId", (Object)"PhoneAppNotification");
        beginAuthJson.put("Ctx", (Object)context);
        beginAuthJson.put("FlowToken", (Object)flowToken);
        beginAuthJson.put("Method", (Object)"BeginAuth");
        beginAuthMethod.setJsonBody(beginAuthJson);
        config = httpClientAdapter.executeRestRequest(beginAuthMethod);
        LOGGER.debug((Object)config);
        if (!config.getBoolean("Success")) {
            throw new IOException("Authentication failed: " + config);
        }
        context = config.getString("Ctx");
        flowToken = config.getString("FlowToken");
        String sessionId = config.getString("SessionId");
        int i = 0;
        boolean success = false;
        while (!success && i++ < 12) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                LOGGER.debug((Object)"Interrupted");
                Thread.currentThread().interrupt();
            }
            RestRequest endAuthMethod = new RestRequest(urlEndAuth);
            endAuthMethod.setRequestHeader("Accept", "application/json");
            endAuthMethod.setRequestHeader("canary", apiCanary);
            endAuthMethod.setRequestHeader("client-request-id", clientRequestId);
            endAuthMethod.setRequestHeader("hpgact", hpgact);
            endAuthMethod.setRequestHeader("hpgid", hpgid);
            endAuthMethod.setRequestHeader("hpgrequestid", hpgrequestid);
            JSONObject endAuthJson = new JSONObject();
            endAuthJson.put("AuthMethodId", (Object)"PhoneAppNotification");
            endAuthJson.put("Ctx", (Object)context);
            endAuthJson.put("FlowToken", (Object)flowToken);
            endAuthJson.put("Method", (Object)"EndAuth");
            endAuthJson.put("PollCount", (Object)"1");
            endAuthJson.put("SessionId", (Object)sessionId);
            endAuthMethod.setJsonBody(endAuthJson);
            config = httpClientAdapter.executeRestRequest(endAuthMethod);
            LOGGER.debug((Object)config);
            String resultValue = config.getString("ResultValue");
            if ("PhoneAppDenied".equals(resultValue) || "PhoneAppNoResponse".equals(resultValue)) {
                throw new DavMailAuthenticationException("EXCEPTION_AUTHENTICATION_FAILED_REASON", resultValue);
            }
            if (!config.getBoolean("Success")) continue;
            success = true;
        }
        if (!success) {
            throw new IOException("Authentication failed: " + config);
        }
        String authMethod = "PhoneAppOTP";
        String type = "22";
        context = config.getString("Ctx");
        flowToken = config.getString("FlowToken");
        PostRequest processAuthMethod = new PostRequest("https://login.microsoftonline.com/" + this.tenantId + "/SAS/ProcessAuth");
        processAuthMethod.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
        processAuthMethod.setParameter("type", type);
        processAuthMethod.setParameter("request", context);
        processAuthMethod.setParameter("mfaAuthMethod", authMethod);
        processAuthMethod.setParameter("canary", canary);
        processAuthMethod.setParameter("login", username);
        processAuthMethod.setParameter("flowToken", flowToken);
        processAuthMethod.setParameter("hpgrequestid", hpgrequestid);
        httpClientAdapter.executePostRequest(processAuthMethod);
        return processAuthMethod.getRedirectLocation();
    }

    private String executeFollowRedirect(HttpClientAdapter httpClientAdapter, GetRequest getRequest) throws IOException {
        LOGGER.debug((Object)getRequest.getURI());
        GetRequest responseWrapper = httpClientAdapter.executeFollowRedirect(getRequest);
        if (responseWrapper.getURI().getHost().endsWith("okta.com")) {
            throw new DavMailAuthenticationException("LOG_MESSAGE", "Okta authentication not supported, please try O365Interactive");
        }
        return responseWrapper.getResponseBodyAsString();
    }

    public JSONObject extractConfig(String content) throws IOException {
        try {
            return new JSONObject(this.extract("Config=([^\n]+);", content));
        }
        catch (JSONException e1) {
            LOGGER.debug((Object)content);
            throw new IOException("Unable to extract config from response body");
        }
    }

    public String extract(String pattern, String content) throws IOException {
        Matcher matcher = Pattern.compile(pattern).matcher(content);
        if (!matcher.find()) {
            throw new IOException("pattern not found");
        }
        String value = matcher.group(1);
        return value;
    }
}

