/*
# Docsis cable modem diagnostics (cmdiag)
#
# Copyright (C) 2006-2007 Emil Penchev
#
# This program is free software, distributed under the terms of
# the GNU General Public License 2.0
#
*/

#ifndef BAR_H
#define BAR_H

#include <string>
#include <sstream>

using namespace std;

class Bar
{
	protected:
		int xpos, ypos, level, st_mark, end_mark, bar_lenght;
		string * type;
		string * st_mark_measure;
		string * end_mark_measure; 
		void draw_border();
		void set_color(int fg_color, int n_color, int on);
		void draw_part(int y, int start_pos, int end_pos);
		void erase(int barlen);
		string itos(int number);
		
	public:
		Bar(int x, int y, string tp, string s_meas, string e_meas, int s_mark, int e_mark, int len);
		~Bar() { delete type; delete st_mark_measure; delete end_mark_measure; }
		void DataUpdate(int lev);
		void RxUpdate(int lev);
		void CodeWordsUpdate(int cwords);
		void Draw();
};

#endif

