# -*- coding: ascii -*-

###########################################################################
# clive, video extraction utility
# Copyright (C) 2007-2008 Toni Gundogdu
#
# This file is part of clive.
#
# clive is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# clive is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with clive.  If not, see <http://www.gnu.org/licenses/>.
###########################################################################

## The module caching classes

__all__ = ['Modules']

from clive.singleton import Singleton

## The module caching class: designed to reduce import statement overhead
class Modules(Singleton):

    ## Constructor
    def __init__(self):
        self._lookup = {
            'urlgrabber':self._import_urlgrabber,
            'newt':self._import_newt,
            'feedparser':self._import_feedparser,
            'pysqlite':self._import_pysqlite,
            'pycrypto':self._import_pycrypto,
            'os':self._import_os,
            'sys':self._import_sys,
            'subprocess':self._import_subprocess,
            'errno':self._import_errno,
            'md5':self._import_md5,
            'time':self._import_time,
            'StringIO':self._import_stringio,
            'gzip':self._import_gzip,
            'string':self._import_string,
            'random':self._import_random,
            'urllib2':self._import_urllib2,
        }
        self._mods = {}
        for e in self._lookup:
            self._wrapper(e)

    def getinst(self, modname):
        m = self._mods[modname]
        if not m['installed']:
            raise SystemExit('error: %s' % m['error'])
        return m['instance']

    def check(self, modname):
        return self._mods[modname]

    def _wrapper(self, modname):
        error = None
        try:
            (mod,ver) = self._lookup[modname]()
        except ImportError, error:
            (mod,ver) = (None,'-')
        self._mods[modname] = \
            {'installed':ver!='-', 'instance':mod, 'version':ver, 'error':error}

    def _import_urlgrabber(self):
        import urlgrabber as u
        from urlgrabber.grabber import URLGrabber, URLGrabError
        return ((URLGrabber,URLGrabError), u.__version__)

    def _import_newt(self):
        import snack as newt
        # Available but the module itself does not contain version
        return (newt, '?')

    def _import_feedparser(self):
        import feedparser as fparser
        return (fparser, fparser.__version__)

    def _import_pysqlite(self):
        import sqlite3 as pysqlite
        return (pysqlite, pysqlite.version)

    def _import_pycrypto(self):
        import Crypto as c
        from Crypto.Cipher import AES as pycrypto
        return (pycrypto, c.__version__)

    def _import_os(self):
        import os
        return (os, None)

    def _import_sys(self):
        import sys
        return (sys, None)

    def _import_subprocess(self):
        import subprocess
        return (subprocess, None)

    def _import_errno(self):
        import errno
        return (errno, None)

    def _import_md5(self):
        import md5
        return (md5, None)

    def _import_time(self):
        import time
        return (time, None)

    def _import_stringio(self):
        try:
            from cStringIO import StringIO
        except ImportError:
            from StringIO import StringIO
        return (StringIO, None)

    def _import_gzip(self):
        import gzip
        return (gzip, None)

    def _import_string(self):
        import string
        return (string, None)

    def _import_random(self):
        import random
        return (random, None)

    def _import_urllib2(self):
        import urllib2
        return (urllib2, None)
