# Getting started

Once you have built or obtained a release, a webui will be enabled by default at http://127.0.0.1:1488/

Windows users are encouraged to use the webui if they can't use the command line tool

## Command Line (unix)

To use the command line tool you must symlink the `XD` binary to `XD-cli`

    $ ln -s XD XD-cli

Adding torrents from seed file over i2p:

    XD-cli add http://somesite.i2p/some/url/to/a/torrent.torrent

Listing active torrents:

    XD-cli list

To increase how many pieces to request in parallel use `set-piece-window` command (may be removed in future):

    XD-cli set-piece-window 10


## Command Line (windows)

On Windows: make a copy of the file called `XD-cli.exe`

All commands are done in the same manner as in unix, except `/` needs escaping depending on what terminal in use.

TODO: add more docs for windows

# Configuration

XD uses ini file format for configuration, the main config file is `torrents.ini` and is autogenerated with default values if not present


## SFTP storage config

XD can use a remote filesystem accessed via sftp, to use this behavior it must be configured.

Example config:

    [storage]
    rootdir=/mnt/storage/XD/
    metadata=/mnt/storage/XD/metadata
    downloads=/mnt/storage/XD/downloads
    sftp_host=remote.server.tld
    sftp_port=22
    sftp_user=your_ssh_user
    sftp_remotekey=base64dserverpublickeygoeshere
    sftp_keyfile=/path/to/ssh/private/key/to/login/with/id_rsa
    sftp=1

This will login to `remote.server.tld:22` with user `your_ssh_user` using (unencrypted) private key and use `/mnt/storage/XD/` on the remote server as the storage for torrents and metadata. 

The server's public key is usually located at `/etc/ssh/ssh_host_*.pub` in the form: `ssh-whatever base64goeshere root@hostname`, you want to use the base64 value in `sftp_remotekey` .
