/**************************************************************************
 *                                                                        *
 * Copyright (C) 2015 Felix Rohrbach <kde@fxrh.de>                        *
 *                                                                        *
 * This program is free software; you can redistribute it and/or          *
 * modify it under the terms of the GNU General Public License            *
 * as published by the Free Software Foundation; either version 3         *
 * of the License, or (at your option) any later version.                 *
 *                                                                        *
 * This program is distributed in the hope that it will be useful,        *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          *
 * GNU General Public License for more details.                           *
 *                                                                        *
 * You should have received a copy of the GNU General Public License      *
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.  *
 *                                                                        *
 **************************************************************************/

#pragma once

#include "dialog.h"

class QLineEdit;
class QCheckBox;

namespace QMatrixClient {
    class AccountSettings;
    class Connection;
}

class LoginDialog : public Dialog
{
        Q_OBJECT
    public:
        explicit LoginDialog(const QString& statusMessage,
                             QWidget* parent = nullptr,
                             const QStringList& knownAccounts = {});
        explicit LoginDialog(const QString& statusMessage, QWidget* parent,
                             const QMatrixClient::AccountSettings& reloginData);
        void setup(const QString &statusMessage);
        ~LoginDialog() override;

        QMatrixClient::Connection* releaseConnection();
        QString deviceName() const;
        bool keepLoggedIn() const;

    private slots:
        void apply() override;
        void loginWithBestFlow();
        void loginWithPassword();
        void loginWithSso();
        
    private:
        QLineEdit* userEdit;
        QLineEdit* passwordEdit;
        QLineEdit* initialDeviceName;
        QLineEdit* serverEdit;
        QCheckBox* saveTokenCheck;

        QScopedPointer<QMatrixClient::Connection, QScopedPointerDeleteLater>
            m_connection;
};
