/* Ghost In The Mail (gitmail)
 *  Copyright (C) 2004-2006 Clément Plantier <clem38fr at users dot sf.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "callbacks.h"

extern GtkWidget *mainwindow;

/* called when then "send" button is clicked */
void clicksend (GtkButton *button, gpointer user_data) {
	GtkWidget * entry1 = lookup_widget(GTK_WIDGET(button), "entry1");
	GtkWidget * entry2 = lookup_widget(GTK_WIDGET(button), "entry2");
	GtkWidget * comboboxentry1 = lookup_widget(GTK_WIDGET(button), "comboboxentry1");
	GtkWidget * comboboxentry2 = lookup_widget(GTK_WIDGET(button), "comboboxentry2");
	GtkWidget * comboboxentry3 = lookup_widget(GTK_WIDGET(button), "comboboxentry3");
	GtkWidget * comboboxentry4 = lookup_widget(GTK_WIDGET(button), "comboboxentry4");
	GtkWidget * textview1 = lookup_widget(GTK_WIDGET(button), "textview1");
	GtkTextBuffer * buffer;

	char *server = create_string (gtk_entry_get_text(GTK_ENTRY(GTK_BIN(comboboxentry1)->child)));
	char *from = create_string (gtk_entry_get_text(GTK_ENTRY(GTK_BIN(comboboxentry2)->child)));
	char *to = create_string (gtk_entry_get_text(GTK_ENTRY(GTK_BIN(comboboxentry4)->child)));
	char *name  = create_string (gtk_entry_get_text(GTK_ENTRY(GTK_BIN(comboboxentry3)->child)));
	char *subject = create_string (gtk_entry_get_text(GTK_ENTRY(entry1)));
	char *filepath = create_string (gtk_entry_get_text(GTK_ENTRY(entry2)));
	
	serverlistroot = additem (comboboxentry1, serverlistroot, server);
	fromlistroot = additem (comboboxentry2, fromlistroot, from);
	namelistroot = additem (comboboxentry3, namelistroot, name);
	tolistroot = additem (comboboxentry4, tolistroot, to);
	
	buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(textview1));
	GtkTextIter start;
	GtkTextIter end;
	gtk_text_buffer_get_start_iter(buffer,&start);
	gtk_text_buffer_get_end_iter(buffer,&end);
	char *text = gtk_text_buffer_get_text (buffer, &start, &end, 0);
	
	maildata *mdata = gitm_malloc (sizeof(maildata));
	
	mdata->server=server;
	mdata->from=from;
	mdata->name=name;
	mdata->to=to;
	mdata->subject=subject;
	mdata->filepath=filepath;
	mdata->text=text;
	
	gtk_widget_set_sensitive(GTK_WIDGET(button), FALSE);
	
	pthread_t thread_id;
	pthread_create(&thread_id, NULL, (void *)sendamail, mdata);
}

void clickattach (GtkButton *button, gpointer user_data) {
	GtkWidget *fileselection1=create_fileselection1();
	gtk_widget_show (fileselection1);
}

void file_ok_sel (GtkButton *button, gpointer user_data) {
	GtkWidget *fileselection1=lookup_widget(GTK_WIDGET(button), "fileselection1");
	char *file = create_string (gtk_file_selection_get_filename (GTK_FILE_SELECTION (fileselection1)));
	gtk_widget_destroy(fileselection1);
	GtkWidget *entry2=lookup_widget(GTK_WIDGET(mainwindow), "entry2");
	gtk_entry_set_text(GTK_ENTRY(entry2), file);
}

void on_about_activate (GtkMenuItem *menuitem, gpointer user_data) {
	GtkWidget *dialog1 = create_dialog1 ();
	GtkWidget *label20 = lookup_widget(dialog1, "label20");
	char *about_text = gitm_strcat ("Ghost In The Mail (gitmail) version ", GITM_VERSION);
	about_text = gitm_stradd (about_text, "\nCopyright (C) 2004-2006 \"DaCoder\" Clement Plantier\n<clem38fr@users.sf.net>\n\nThis program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.");
	gtk_label_set_text (GTK_LABEL(label20), about_text);
	gtk_widget_show (dialog1);
	free(about_text);
}

void
on_erase_all_items1_activate (GtkMenuItem *menuitem, gpointer user_data) {
	erase_all_items();
}
