/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.wizards;

import java.io.File;
import org.apache.directory.studio.common.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.ldapbrowser.common.widgets.FileBrowserWidget;
import org.apache.directory.studio.ldapbrowser.common.widgets.WidgetModifyEvent;
import org.apache.directory.studio.ldapbrowser.common.widgets.WidgetModifyListener;
import org.apache.directory.studio.ldapbrowser.ui.BrowserUIPlugin;
import org.apache.directory.studio.ldapbrowser.ui.wizards.Messages;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ImportConnectionsWizardPage
extends WizardPage {
    private FileBrowserWidget fileBrowserWidget;

    protected ImportConnectionsWizardPage() {
        super(ImportConnectionsWizardPage.class.getName());
        this.setTitle(Messages.getString("ImportConnectionsWizardPage.ImportConnections"));
        this.setDescription(Messages.getString("ImportConnectionsWizardPage.ImportConnectionsFromFilesystem"));
        this.setImageDescriptor(BrowserUIPlugin.getDefault().getImageDescriptor("resources/icons/import_connections_wizard.gif"));
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite composite = BaseWidgetUtils.createColumnContainer((Composite)parent, (int)3, (int)1);
        BaseWidgetUtils.createLabel((Composite)composite, (String)Messages.getString("ImportConnectionsWizardPage.FromFile"), (int)1);
        this.fileBrowserWidget = new FileBrowserWidget(Messages.getString("ImportConnectionsWizardPage.ChooseFile"), new String[]{"lbc"}, 4096);
        this.fileBrowserWidget.createWidget(composite);
        this.fileBrowserWidget.addWidgetModifyListener(new WidgetModifyListener(){

            public void widgetModified(WidgetModifyEvent event) {
                ImportConnectionsWizardPage.this.validate();
            }
        });
        this.setControl((Control)composite);
    }

    private void validate() {
        boolean ok = true;
        File file = new File(this.fileBrowserWidget.getFilename());
        if ("".equals(this.fileBrowserWidget.getFilename())) {
            this.setErrorMessage(null);
            ok = false;
        } else if (!file.exists()) {
            this.setErrorMessage(Messages.getString("ImportConnectionsWizardPage.ErrorFileNotExists"));
            ok = false;
        } else if (file.isDirectory()) {
            this.setErrorMessage(Messages.getString("ImportConnectionsWizardPage.ErrorFileNotFile"));
            ok = false;
        } else if (file.exists() && !file.canRead()) {
            this.setErrorMessage(Messages.getString("ImportConnectionsWizardPage.ErrorFileNotReadable"));
            ok = false;
        }
        if (ok) {
            this.setErrorMessage(null);
        }
        this.setPageComplete(ok);
    }

    public String getImportFileName() {
        return this.fileBrowserWidget.getFilename();
    }

    public void saveDialogSettings() {
        this.fileBrowserWidget.saveDialogSettings();
    }
}

