/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.wizards;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.directory.studio.connection.core.ConnectionCorePlugin;
import org.apache.directory.studio.connection.core.io.jndi.LdifModificationLogger;
import org.apache.directory.studio.connection.ui.ConnectionUIPlugin;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonConstants;
import org.apache.directory.studio.ldapbrowser.ui.wizards.ExportBaseWizard;
import org.apache.directory.studio.ldapbrowser.ui.wizards.ExportLogsToWizardPage;
import org.apache.directory.studio.ldapbrowser.ui.wizards.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.wizard.IWizardPage;

public class ExportModificationLogsWizard
extends ExportBaseWizard {
    private ExportLogsToWizardPage toPage;

    public ExportModificationLogsWizard() {
        super(Messages.getString("ExportModificationLogsWizard.ExportModificationLogs"));
    }

    public void addPages() {
        this.toPage = new ExportLogsToWizardPage(ExportLogsToWizardPage.class.getName(), this);
        this.addPage((IWizardPage)this.toPage);
    }

    public boolean performFinish() {
        this.toPage.saveDialogSettings();
        if (this.search.getBrowserConnection().getConnection() != null) {
            try {
                File targetFile = new File(this.exportFilename);
                FileOutputStream os = FileUtils.openOutputStream((File)targetFile);
                LdifModificationLogger modificationLogger = ConnectionCorePlugin.getDefault().getLdifModificationLogger();
                File[] files = modificationLogger.getFiles(this.search.getBrowserConnection().getConnection());
                for (int i = files.length - 1; i >= 0; --i) {
                    File file = files[i];
                    if (file == null || !file.exists() || !file.canRead()) continue;
                    FileInputStream is = FileUtils.openInputStream((File)file);
                    IOUtils.copy((InputStream)is, (OutputStream)os);
                    is.close();
                }
                os.close();
            }
            catch (IOException e) {
                ConnectionUIPlugin.getDefault().getExceptionHandler().handleException((IStatus)new Status(4, BrowserCommonConstants.PLUGIN_ID, 4, Messages.getString("ExportModificationLogsWizard.CantExportModificationLogs"), (Throwable)e));
            }
        }
        return true;
    }
}

