/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.views.searchlogs;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionCorePlugin;
import org.apache.directory.studio.connection.core.event.EventRunner;
import org.apache.directory.studio.connection.core.io.jndi.LdifSearchLogger;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonActivator;
import org.apache.directory.studio.ldapbrowser.common.actions.BrowserSelectionUtils;
import org.apache.directory.studio.ldapbrowser.core.BrowserCorePlugin;
import org.apache.directory.studio.ldapbrowser.core.events.AttributesInitializedEvent;
import org.apache.directory.studio.ldapbrowser.core.events.BrowserConnectionUpdateEvent;
import org.apache.directory.studio.ldapbrowser.core.events.BrowserConnectionUpdateListener;
import org.apache.directory.studio.ldapbrowser.core.events.ChildrenInitializedEvent;
import org.apache.directory.studio.ldapbrowser.core.events.EntryModificationEvent;
import org.apache.directory.studio.ldapbrowser.core.events.EntryUpdateListener;
import org.apache.directory.studio.ldapbrowser.core.events.EventRegistry;
import org.apache.directory.studio.ldapbrowser.core.events.SearchUpdateEvent;
import org.apache.directory.studio.ldapbrowser.core.events.SearchUpdateListener;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.ui.views.connection.ConnectionView;
import org.apache.directory.studio.ldapbrowser.ui.views.searchlogs.SearchLogsView;
import org.apache.directory.studio.ldapbrowser.ui.views.searchlogs.SearchLogsViewInput;
import org.apache.directory.studio.ldifparser.model.container.LdifContainer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.INullSelectionListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;

public class SearchLogsViewUniversalListener
implements BrowserConnectionUpdateListener,
SearchUpdateListener,
EntryUpdateListener {
    private SearchLogsView view;
    private SearchLogsViewInput input;
    private long lastRefreshTimestamp;
    private INullSelectionListener connectionSelectionListener = new INullSelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            Connection[] connections;
            if (SearchLogsViewUniversalListener.this.view != null && part != null && SearchLogsViewUniversalListener.this.view.getSite().getWorkbenchWindow() == part.getSite().getWorkbenchWindow() && (connections = BrowserSelectionUtils.getConnections((ISelection)selection)).length == 1) {
                IBrowserConnection connection = BrowserCorePlugin.getDefault().getConnectionManager().getBrowserConnectionById(connections[0].getId());
                SearchLogsViewInput input = new SearchLogsViewInput(connection, 0);
                SearchLogsViewUniversalListener.this.setInput(input);
                SearchLogsViewUniversalListener.this.scrollToNewest();
            }
        }
    };

    public SearchLogsViewUniversalListener(SearchLogsView view) {
        this.view = view;
        this.input = null;
        EventRegistry.addEntryUpdateListener((EntryUpdateListener)this, (EventRunner)BrowserCommonActivator.getDefault().getEventRunner());
        EventRegistry.addSearchUpdateListener((SearchUpdateListener)this, (EventRunner)BrowserCommonActivator.getDefault().getEventRunner());
        EventRegistry.addBrowserConnectionUpdateListener((BrowserConnectionUpdateListener)this, (EventRunner)BrowserCommonActivator.getDefault().getEventRunner());
        view.getSite().getWorkbenchWindow().getSelectionService().addPostSelectionListener(ConnectionView.getId(), (ISelectionListener)this.connectionSelectionListener);
    }

    public void dispose() {
        if (this.view != null) {
            this.view.getSite().getWorkbenchWindow().getSelectionService().removePostSelectionListener(ConnectionView.getId(), (ISelectionListener)this.connectionSelectionListener);
            EventRegistry.removeEntryUpdateListener((EntryUpdateListener)this);
            EventRegistry.removeSearchUpdateListener((SearchUpdateListener)this);
            EventRegistry.removeBrowserConnectionUpdateListener((BrowserConnectionUpdateListener)this);
            this.view = null;
        }
    }

    void refreshInput() {
        SearchLogsViewInput newInput = this.input;
        this.input = null;
        this.setInput(newInput);
    }

    void setInput(SearchLogsViewInput input) {
        if (this.input != input && input.getBrowserConnection().getConnection() != null) {
            this.input = input;
            LdifSearchLogger searchLogger = ConnectionCorePlugin.getDefault().getLdifSearchLogger();
            if (input != null && input.getBrowserConnection() != null && input.getBrowserConnection().getConnection() != null && searchLogger != null) {
                StringBuffer sb = new StringBuffer();
                File[] files = searchLogger.getFiles(input.getBrowserConnection().getConnection());
                int i = input.getIndex();
                if (0 <= i && i < files.length && files[i] != null && files[i].exists() && files[i].canRead()) {
                    try {
                        FileReader fr = new FileReader(files[i]);
                        char[] cbuf = new char[4096];
                        int length = fr.read(cbuf);
                        while (length > 0) {
                            sb.append(cbuf, 0, length);
                            length = fr.read(cbuf);
                        }
                    }
                    catch (Exception e) {
                        sb.append(e.getMessage());
                    }
                }
                this.view.getMainWidget().getSourceViewer().getDocument().set(sb.toString());
                this.view.getActionGroup().setInput(input);
            }
        }
    }

    public void entryUpdated(EntryModificationEvent event) {
        if (event instanceof AttributesInitializedEvent || event instanceof ChildrenInitializedEvent) {
            this.updateInput();
        }
    }

    public void searchUpdated(SearchUpdateEvent searchUpdateEvent) {
        if (searchUpdateEvent.getDetail() == SearchUpdateEvent.EventDetail.SEARCH_PERFORMED) {
            this.updateInput();
        }
    }

    public void browserConnectionUpdated(BrowserConnectionUpdateEvent browserConnectionUpdateEvent) {
        if (browserConnectionUpdateEvent.getDetail() == BrowserConnectionUpdateEvent.Detail.BROWSER_CONNECTION_OPENED || browserConnectionUpdateEvent.getDetail() == BrowserConnectionUpdateEvent.Detail.SCHEMA_UPDATED) {
            this.updateInput();
        }
    }

    private void updateInput() {
        long now = System.currentTimeMillis();
        if (this.lastRefreshTimestamp + 1000L < now) {
            this.refreshInput();
            this.scrollToNewest();
            this.lastRefreshTimestamp = now;
        }
    }

    public void scrollToOldest() {
        this.view.getMainWidget().getSourceViewer().setTopIndex(0);
    }

    public void scrollToNewest() {
        try {
            LdifContainer record = this.view.getMainWidget().getLdifModel().getLastContainer();
            int offset = record.getOffset();
            int line = this.view.getMainWidget().getSourceViewer().getDocument().getLineOfOffset(offset);
            if (line > 3) {
                line -= 3;
            }
            this.view.getMainWidget().getSourceViewer().setTopIndex(line);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void clearInput() {
        if (this.input.getBrowserConnection().getConnection() != null) {
            StringBuffer sb = new StringBuffer("");
            FileWriter fw = null;
            LdifSearchLogger searchLogger = ConnectionCorePlugin.getDefault().getLdifSearchLogger();
            File[] files = searchLogger.getFiles(this.input.getBrowserConnection().getConnection());
            searchLogger.dispose(this.input.getBrowserConnection().getConnection());
            for (int i = 0; i < files.length; ++i) {
                try {
                    if (files[i] == null || !files[i].exists() || files[i].delete()) continue;
                    fw = new FileWriter(files[i]);
                    fw.write("");
                    continue;
                }
                catch (Exception e) {
                    sb.append(e.getMessage());
                }
            }
            this.view.getMainWidget().getSourceViewer().setTopIndex(0);
            this.view.getMainWidget().getSourceViewer().getDocument().set(sb.toString());
        }
    }
}

