/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.editors.searchresult;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonActivator;
import org.apache.directory.studio.ldapbrowser.common.actions.BrowserAction;
import org.apache.directory.studio.ldapbrowser.common.actions.CopyAction;
import org.apache.directory.studio.ldapbrowser.common.actions.NewValueAction;
import org.apache.directory.studio.ldapbrowser.common.actions.PropertiesAction;
import org.apache.directory.studio.ldapbrowser.common.actions.RefreshAction;
import org.apache.directory.studio.ldapbrowser.common.actions.ShowDecoratedValuesAction;
import org.apache.directory.studio.ldapbrowser.common.actions.ValueEditorPreferencesAction;
import org.apache.directory.studio.ldapbrowser.common.actions.proxy.ActionHandlerManager;
import org.apache.directory.studio.ldapbrowser.common.actions.proxy.BrowserActionProxy;
import org.apache.directory.studio.ldapbrowser.core.model.ISearch;
import org.apache.directory.studio.ldapbrowser.ui.actions.CopyAttributeDescriptionAction;
import org.apache.directory.studio.ldapbrowser.ui.actions.CopyDnAction;
import org.apache.directory.studio.ldapbrowser.ui.actions.CopyEntryAsCsvAction;
import org.apache.directory.studio.ldapbrowser.ui.actions.CopySearchFilterAction;
import org.apache.directory.studio.ldapbrowser.ui.actions.CopyUrlAction;
import org.apache.directory.studio.ldapbrowser.ui.actions.CopyValueAction;
import org.apache.directory.studio.ldapbrowser.ui.actions.LocateDnInDitAction;
import org.apache.directory.studio.ldapbrowser.ui.actions.NewBatchOperationAction;
import org.apache.directory.studio.ldapbrowser.ui.actions.NewSearchAction;
import org.apache.directory.studio.ldapbrowser.ui.actions.OpenSchemaBrowserAction;
import org.apache.directory.studio.ldapbrowser.ui.actions.OpenSearchResultAction;
import org.apache.directory.studio.ldapbrowser.ui.actions.proxy.SearchResultEditorActionProxy;
import org.apache.directory.studio.ldapbrowser.ui.editors.searchresult.AbstractOpenEditorAction;
import org.apache.directory.studio.ldapbrowser.ui.editors.searchresult.Messages;
import org.apache.directory.studio.ldapbrowser.ui.editors.searchresult.OpenBestEditorAction;
import org.apache.directory.studio.ldapbrowser.ui.editors.searchresult.OpenDefaultEditorAction;
import org.apache.directory.studio.ldapbrowser.ui.editors.searchresult.OpenEditorAction;
import org.apache.directory.studio.ldapbrowser.ui.editors.searchresult.OpenEntryEditorAction;
import org.apache.directory.studio.ldapbrowser.ui.editors.searchresult.OpenSearchResultEditorPreferencePage;
import org.apache.directory.studio.ldapbrowser.ui.editors.searchresult.SearchResultDeleteAction;
import org.apache.directory.studio.ldapbrowser.ui.editors.searchresult.SearchResultEditor;
import org.apache.directory.studio.ldapbrowser.ui.editors.searchresult.SearchResultEditorCursor;
import org.apache.directory.studio.ldapbrowser.ui.editors.searchresult.SearchResultEditorPasteAction;
import org.apache.directory.studio.ldapbrowser.ui.editors.searchresult.ShowDNAction;
import org.apache.directory.studio.ldapbrowser.ui.editors.searchresult.ShowLinksAction;
import org.apache.directory.studio.ldapbrowser.ui.editors.searchresult.ShowQuickFilterAction;
import org.apache.directory.studio.utils.ActionUtils;
import org.apache.directory.studio.valueeditors.IValueEditor;
import org.apache.directory.studio.valueeditors.ValueEditorManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ContributionItemFactory;

public class SearchResultEditorActionGroup
implements ActionHandlerManager,
IMenuListener {
    private ShowDNAction showDNAction;
    private ShowLinksAction showLinksAction;
    private ShowDecoratedValuesAction showDecoratedValuesAction;
    private OpenSearchResultEditorPreferencePage openSearchResultEditorPreferencePage;
    private ShowQuickFilterAction showQuickFilterAction;
    private SearchResultEditorActionProxy openDefaultValueEditorActionProxy;
    private SearchResultEditorActionProxy openBestValueEditorActionProxy;
    private SearchResultEditorActionProxy[] openValueEditorActionProxies;
    private SearchResultEditorActionProxy openEntryValueEditorActionProxy;
    private ValueEditorPreferencesAction openValueEditorPreferencesAction;
    private static final String copyTableAction = "copyTableAction";
    private static final String refreshSearchAction = "refreshSearchAction";
    private static final String newValueAction = "newValueAction";
    private static final String newSearchAction = "newSearchAction";
    private static final String newBatchOperationAction = "newBatchOperationAction";
    private static final String copyAction = "copyAction";
    private static final String pasteAction = "pasteAction";
    private static final String deleteAction = "deleteAction";
    private static final String copyDnAction = "copyDnAction";
    private static final String copyUrlAction = "copyUrlAction";
    private static final String copyAttriuteDescriptionAction = "copyAttriuteDescriptionAction";
    private static final String copyDisplayValueAction = "copyDisplayValueAction";
    private static final String copyValueUtf8Action = "copyValueUtf8Action";
    private static final String copyValueBase64Action = "copyValueBase64Action";
    private static final String copyValueHexAction = "copyValueHexAction";
    private static final String copyValueAsLdifAction = "copyValueAsLdifAction";
    private static final String copySearchFilterAction = "copySearchFilterAction";
    private static final String copyNotSearchFilterAction = "copyNotSearchFilterAction";
    private static final String copyAndSearchFilterAction = "copyAndSearchFilterAction";
    private static final String copyOrSearchFilterAction = "copyOrSearchFilterAction";
    private static final String openSearchResultAction = "showEntryInSearchResultsAction";
    private static final String locateDnInDitAction = "locateDnInDitAction";
    private static final String showOcdAction = "showOcdAction";
    private static final String showAtdAction = "showAtdAction";
    private static final String showEqualityMrdAction = "showEqualityMrdAction";
    private static final String showSubstringMrdAction = "showSubstringMrdAction";
    private static final String showOrderingMrdAction = "showOrderingMrdAction";
    private static final String showLsdAction = "showLsdAction";
    private static final String propertyDialogAction = "propertyDialogAction";
    private Map<String, SearchResultEditorActionProxy> searchResultEditorActionMap;
    private IActionBars actionBars;
    private SearchResultEditor searchResultEditor;

    public SearchResultEditorActionGroup(SearchResultEditor searchResultEditor) {
        this.searchResultEditor = searchResultEditor;
        this.searchResultEditorActionMap = new HashMap<String, SearchResultEditorActionProxy>();
        TableViewer viewer = searchResultEditor.getMainWidget().getViewer();
        SearchResultEditorCursor cursor = searchResultEditor.getConfiguration().getCursor(viewer);
        ValueEditorManager valueEditorManager = searchResultEditor.getConfiguration().getValueEditorManager(viewer);
        this.showDNAction = new ShowDNAction();
        this.showLinksAction = new ShowLinksAction();
        this.showDecoratedValuesAction = new ShowDecoratedValuesAction();
        this.openSearchResultEditorPreferencePage = new OpenSearchResultEditorPreferencePage();
        this.showQuickFilterAction = new ShowQuickFilterAction(searchResultEditor.getMainWidget().getQuickFilterWidget());
        this.openBestValueEditorActionProxy = new SearchResultEditorActionProxy(cursor, new OpenBestEditorAction(viewer, cursor, valueEditorManager, this));
        this.openDefaultValueEditorActionProxy = new SearchResultEditorActionProxy(cursor, new OpenDefaultEditorAction(viewer, cursor, valueEditorManager, this.openBestValueEditorActionProxy, this));
        IValueEditor[] valueEditors = searchResultEditor.getConfiguration().getValueEditorManager(viewer).getAllValueEditors();
        this.openValueEditorActionProxies = new SearchResultEditorActionProxy[valueEditors.length];
        for (int i = 0; i < this.openValueEditorActionProxies.length; ++i) {
            this.openValueEditorActionProxies[i] = new SearchResultEditorActionProxy(cursor, new OpenEditorAction(viewer, cursor, valueEditorManager, valueEditors[i], this));
        }
        this.openEntryValueEditorActionProxy = new SearchResultEditorActionProxy(cursor, new OpenEntryEditorAction(viewer, cursor, valueEditorManager, (IValueEditor)valueEditorManager.getEntryValueEditor(), this));
        this.openValueEditorPreferencesAction = new ValueEditorPreferencesAction();
        this.searchResultEditorActionMap.put(copyTableAction, new SearchResultEditorActionProxy(cursor, new CopyEntryAsCsvAction(5)));
        this.searchResultEditorActionMap.put(refreshSearchAction, new SearchResultEditorActionProxy(cursor, (BrowserAction)new RefreshAction()));
        this.searchResultEditorActionMap.put(newValueAction, new SearchResultEditorActionProxy(cursor, (BrowserAction)new NewValueAction()));
        this.searchResultEditorActionMap.put(newSearchAction, new SearchResultEditorActionProxy(cursor, new NewSearchAction()));
        this.searchResultEditorActionMap.put(newBatchOperationAction, new SearchResultEditorActionProxy(cursor, new NewBatchOperationAction()));
        this.searchResultEditorActionMap.put(locateDnInDitAction, new SearchResultEditorActionProxy(cursor, new LocateDnInDitAction()));
        this.searchResultEditorActionMap.put(openSearchResultAction, new SearchResultEditorActionProxy(cursor, new OpenSearchResultAction()));
        this.searchResultEditorActionMap.put(showOcdAction, new SearchResultEditorActionProxy(cursor, new OpenSchemaBrowserAction(10)));
        this.searchResultEditorActionMap.put(showAtdAction, new SearchResultEditorActionProxy(cursor, new OpenSchemaBrowserAction(20)));
        this.searchResultEditorActionMap.put(showEqualityMrdAction, new SearchResultEditorActionProxy(cursor, new OpenSchemaBrowserAction(30)));
        this.searchResultEditorActionMap.put(showSubstringMrdAction, new SearchResultEditorActionProxy(cursor, new OpenSchemaBrowserAction(31)));
        this.searchResultEditorActionMap.put(showOrderingMrdAction, new SearchResultEditorActionProxy(cursor, new OpenSchemaBrowserAction(32)));
        this.searchResultEditorActionMap.put(showLsdAction, new SearchResultEditorActionProxy(cursor, new OpenSchemaBrowserAction(40)));
        this.searchResultEditorActionMap.put(pasteAction, new SearchResultEditorActionProxy(cursor, (BrowserAction)new SearchResultEditorPasteAction()));
        this.searchResultEditorActionMap.put(copyAction, new SearchResultEditorActionProxy(cursor, (BrowserAction)new CopyAction((BrowserActionProxy)this.searchResultEditorActionMap.get(pasteAction), valueEditorManager)));
        this.searchResultEditorActionMap.put(deleteAction, new SearchResultEditorActionProxy(cursor, (BrowserAction)new SearchResultDeleteAction()));
        this.searchResultEditorActionMap.put(copyDnAction, new SearchResultEditorActionProxy(cursor, new CopyDnAction()));
        this.searchResultEditorActionMap.put(copyUrlAction, new SearchResultEditorActionProxy(cursor, new CopyUrlAction()));
        this.searchResultEditorActionMap.put(copyAttriuteDescriptionAction, new SearchResultEditorActionProxy(cursor, new CopyAttributeDescriptionAction()));
        this.searchResultEditorActionMap.put(copyDisplayValueAction, new SearchResultEditorActionProxy(cursor, new CopyValueAction(CopyValueAction.Mode.DISPLAY, valueEditorManager)));
        this.searchResultEditorActionMap.put(copyValueUtf8Action, new SearchResultEditorActionProxy(cursor, new CopyValueAction(CopyValueAction.Mode.UTF8, valueEditorManager)));
        this.searchResultEditorActionMap.put(copyValueBase64Action, new SearchResultEditorActionProxy(cursor, new CopyValueAction(CopyValueAction.Mode.BASE64, valueEditorManager)));
        this.searchResultEditorActionMap.put(copyValueHexAction, new SearchResultEditorActionProxy(cursor, new CopyValueAction(CopyValueAction.Mode.HEX, valueEditorManager)));
        this.searchResultEditorActionMap.put(copyValueAsLdifAction, new SearchResultEditorActionProxy(cursor, new CopyValueAction(CopyValueAction.Mode.LDIF, valueEditorManager)));
        this.searchResultEditorActionMap.put(copySearchFilterAction, new SearchResultEditorActionProxy(cursor, new CopySearchFilterAction(0)));
        this.searchResultEditorActionMap.put(copyNotSearchFilterAction, new SearchResultEditorActionProxy(cursor, new CopySearchFilterAction(1)));
        this.searchResultEditorActionMap.put(copyAndSearchFilterAction, new SearchResultEditorActionProxy(cursor, new CopySearchFilterAction(2)));
        this.searchResultEditorActionMap.put(copyOrSearchFilterAction, new SearchResultEditorActionProxy(cursor, new CopySearchFilterAction(3)));
        this.searchResultEditorActionMap.put(propertyDialogAction, new SearchResultEditorActionProxy(cursor, (BrowserAction)new PropertiesAction()));
    }

    public void dispose() {
        if (this.searchResultEditor != null) {
            this.showDecoratedValuesAction = null;
            this.showDNAction.dispose();
            this.showDNAction = null;
            this.showLinksAction.dispose();
            this.showLinksAction = null;
            this.openSearchResultEditorPreferencePage = null;
            this.showQuickFilterAction.dispose();
            this.showQuickFilterAction = null;
            this.openDefaultValueEditorActionProxy.dispose();
            this.openDefaultValueEditorActionProxy = null;
            this.openBestValueEditorActionProxy.dispose();
            this.openBestValueEditorActionProxy = null;
            for (int i = 0; i < this.openValueEditorActionProxies.length; ++i) {
                this.openValueEditorActionProxies[i].dispose();
                this.openValueEditorActionProxies[i] = null;
            }
            this.openEntryValueEditorActionProxy.dispose();
            this.openEntryValueEditorActionProxy = null;
            this.openValueEditorPreferencesAction = null;
            Iterator<String> it = this.searchResultEditorActionMap.keySet().iterator();
            while (it.hasNext()) {
                String key = it.next();
                SearchResultEditorActionProxy action = this.searchResultEditorActionMap.get(key);
                action.dispose();
                action = null;
                it.remove();
            }
            this.searchResultEditorActionMap.clear();
            this.searchResultEditorActionMap = null;
            this.actionBars = null;
            this.searchResultEditor = null;
        }
    }

    public void fillToolBar(IToolBarManager toolBarManager) {
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)this.searchResultEditorActionMap.get(newValueAction));
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)this.searchResultEditorActionMap.get(deleteAction));
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)this.searchResultEditorActionMap.get(refreshSearchAction));
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)this.searchResultEditorActionMap.get(copyTableAction));
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)this.showQuickFilterAction);
        toolBarManager.update(true);
    }

    public void fillMenu(IMenuManager menuManager) {
        menuManager.add((IAction)this.showDNAction);
        menuManager.add((IAction)this.showLinksAction);
        menuManager.add((IAction)this.showDecoratedValuesAction);
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.openSearchResultEditorPreferencePage);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                SearchResultEditorActionGroup.this.showDecoratedValuesAction.setChecked(!BrowserCommonActivator.getDefault().getPreferenceStore().getBoolean("showRawValues"));
            }
        });
        menuManager.update(true);
    }

    public void enableGlobalActionHandlers(IActionBars actionBars) {
        this.actionBars = actionBars;
    }

    public void fillContextMenu(IMenuManager menuManager) {
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener((IMenuListener)this);
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        menuManager.add((IAction)this.searchResultEditorActionMap.get(newValueAction));
        menuManager.add((IAction)this.searchResultEditorActionMap.get(newSearchAction));
        menuManager.add((IAction)this.searchResultEditorActionMap.get(newBatchOperationAction));
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.searchResultEditorActionMap.get(locateDnInDitAction));
        menuManager.add((IAction)this.searchResultEditorActionMap.get(openSearchResultAction));
        MenuManager schemaMenuManager = new MenuManager(Messages.getString("SearchResultEditorActionGroup.OpenSchemaBrowser"));
        schemaMenuManager.add((IAction)this.searchResultEditorActionMap.get(showOcdAction));
        schemaMenuManager.add((IAction)this.searchResultEditorActionMap.get(showAtdAction));
        schemaMenuManager.add((IAction)this.searchResultEditorActionMap.get(showEqualityMrdAction));
        schemaMenuManager.add((IAction)this.searchResultEditorActionMap.get(showSubstringMrdAction));
        schemaMenuManager.add((IAction)this.searchResultEditorActionMap.get(showOrderingMrdAction));
        schemaMenuManager.add((IAction)this.searchResultEditorActionMap.get(showLsdAction));
        menuManager.add((IContributionItem)schemaMenuManager);
        MenuManager showInSubMenu = new MenuManager(Messages.getString("SearchResultEditorActionGroup.ShowIn"));
        showInSubMenu.add(ContributionItemFactory.VIEWS_SHOW_IN.create(PlatformUI.getWorkbench().getActiveWorkbenchWindow()));
        menuManager.add((IContributionItem)showInSubMenu);
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.searchResultEditorActionMap.get(copyAction));
        menuManager.add((IAction)this.searchResultEditorActionMap.get(pasteAction));
        menuManager.add((IAction)this.searchResultEditorActionMap.get(deleteAction));
        MenuManager advancedMenuManager = new MenuManager(Messages.getString("SearchResultEditorActionGroup.Advanced"));
        advancedMenuManager.add((IAction)this.searchResultEditorActionMap.get(copyDnAction));
        advancedMenuManager.add((IAction)this.searchResultEditorActionMap.get(copyUrlAction));
        advancedMenuManager.add((IContributionItem)new Separator());
        advancedMenuManager.add((IAction)this.searchResultEditorActionMap.get(copyAttriuteDescriptionAction));
        advancedMenuManager.add((IContributionItem)new Separator());
        advancedMenuManager.add((IAction)this.searchResultEditorActionMap.get(copyDisplayValueAction));
        advancedMenuManager.add((IAction)this.searchResultEditorActionMap.get(copyValueUtf8Action));
        advancedMenuManager.add((IAction)this.searchResultEditorActionMap.get(copyValueBase64Action));
        advancedMenuManager.add((IAction)this.searchResultEditorActionMap.get(copyValueHexAction));
        advancedMenuManager.add((IContributionItem)new Separator());
        advancedMenuManager.add((IAction)this.searchResultEditorActionMap.get(copyValueAsLdifAction));
        advancedMenuManager.add((IContributionItem)new Separator());
        advancedMenuManager.add((IAction)this.searchResultEditorActionMap.get(copySearchFilterAction));
        advancedMenuManager.add((IAction)this.searchResultEditorActionMap.get(copyNotSearchFilterAction));
        advancedMenuManager.add((IAction)this.searchResultEditorActionMap.get(copyAndSearchFilterAction));
        advancedMenuManager.add((IAction)this.searchResultEditorActionMap.get(copyOrSearchFilterAction));
        menuManager.add((IContributionItem)advancedMenuManager);
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.openDefaultValueEditorActionProxy);
        MenuManager editorMenuManager = new MenuManager(Messages.getString("SearchResultEditorActionGroup.EditValue"));
        if (this.openBestValueEditorActionProxy.isEnabled()) {
            editorMenuManager.add((IAction)this.openBestValueEditorActionProxy);
            editorMenuManager.add((IContributionItem)new Separator());
        }
        for (int i = 0; i < this.openValueEditorActionProxies.length; ++i) {
            if (!this.openValueEditorActionProxies[i].isEnabled() || ((OpenEditorAction)this.openValueEditorActionProxies[i].getAction()).getValueEditor().getClass() == ((OpenBestEditorAction)this.openBestValueEditorActionProxy.getAction()).getBestValueEditor().getClass()) continue;
            editorMenuManager.add((IAction)this.openValueEditorActionProxies[i]);
        }
        editorMenuManager.add((IContributionItem)new Separator());
        editorMenuManager.add((IAction)this.openValueEditorPreferencesAction);
        menuManager.add((IContributionItem)editorMenuManager);
        menuManager.add((IAction)this.openEntryValueEditorActionProxy);
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.searchResultEditorActionMap.get(refreshSearchAction));
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IContributionItem)new Separator("additions"));
        menuManager.add((IAction)this.searchResultEditorActionMap.get(propertyDialogAction));
    }

    public void activateGlobalActionHandlers() {
        if (this.actionBars != null) {
            this.actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.searchResultEditorActionMap.get(copyAction));
            this.actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.searchResultEditorActionMap.get(pasteAction));
            this.actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.searchResultEditorActionMap.get(deleteAction));
            this.actionBars.setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)this.searchResultEditorActionMap.get(refreshSearchAction));
            this.actionBars.setGlobalActionHandler(ActionFactory.PROPERTIES.getId(), (IAction)this.searchResultEditorActionMap.get(propertyDialogAction));
            this.actionBars.setGlobalActionHandler(ActionFactory.FIND.getId(), (IAction)this.showQuickFilterAction);
            this.actionBars.updateActionBars();
        }
        IAction nva = (IAction)this.searchResultEditorActionMap.get(newValueAction);
        ActionUtils.activateActionHandler((IAction)nva);
        IAction lid = (IAction)this.searchResultEditorActionMap.get(locateDnInDitAction);
        ActionUtils.activateActionHandler((IAction)lid);
        IAction osr = (IAction)this.searchResultEditorActionMap.get(openSearchResultAction);
        ActionUtils.activateActionHandler((IAction)osr);
        ActionUtils.activateActionHandler((IAction)this.openDefaultValueEditorActionProxy);
        ActionUtils.activateActionHandler((IAction)this.openEntryValueEditorActionProxy);
    }

    public void deactivateGlobalActionHandlers() {
        if (this.actionBars != null) {
            this.actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), null);
            this.actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), null);
            this.actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), null);
            this.actionBars.setGlobalActionHandler(ActionFactory.REFRESH.getId(), null);
            this.actionBars.setGlobalActionHandler(ActionFactory.FIND.getId(), null);
            this.actionBars.setGlobalActionHandler(ActionFactory.PROPERTIES.getId(), null);
            this.actionBars.updateActionBars();
        }
        IAction nva = (IAction)this.searchResultEditorActionMap.get(newValueAction);
        ActionUtils.deactivateActionHandler((IAction)nva);
        IAction lid = (IAction)this.searchResultEditorActionMap.get(locateDnInDitAction);
        ActionUtils.deactivateActionHandler((IAction)lid);
        IAction osr = (IAction)this.searchResultEditorActionMap.get(openSearchResultAction);
        ActionUtils.deactivateActionHandler((IAction)osr);
        ActionUtils.deactivateActionHandler((IAction)this.openDefaultValueEditorActionProxy);
        ActionUtils.deactivateActionHandler((IAction)this.openEntryValueEditorActionProxy);
    }

    public OpenBestEditorAction getOpenBestEditorAction() {
        return (OpenBestEditorAction)this.openBestValueEditorActionProxy.getAction();
    }

    public void setInput(ISearch search) {
        for (SearchResultEditorActionProxy action : this.searchResultEditorActionMap.values()) {
            action.inputChanged(search);
        }
    }

    public boolean isEditorActive() {
        if (((AbstractOpenEditorAction)this.openDefaultValueEditorActionProxy.getAction()).isActive()) {
            return true;
        }
        if (((AbstractOpenEditorAction)this.openBestValueEditorActionProxy.getAction()).isActive()) {
            return true;
        }
        if (((AbstractOpenEditorAction)this.openEntryValueEditorActionProxy.getAction()).isActive()) {
            return true;
        }
        for (int i = 0; i < this.openValueEditorActionProxies.length; ++i) {
            if (!((AbstractOpenEditorAction)this.openValueEditorActionProxies[i].getAction()).isActive()) continue;
            return true;
        }
        return false;
    }
}

