/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser;

import org.apache.directory.api.ldap.model.schema.AbstractSchemaObject;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.LdapSyntax;
import org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.directory.api.ldap.model.schema.MatchingRuleUse;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.ui.BrowserUIConstants;
import org.apache.directory.studio.ldapbrowser.ui.BrowserUIPlugin;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.AttributeTypeDescriptionPage;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.LdapSyntaxDescriptionPage;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.MatchingRuleDescriptionPage;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.MatchingRuleUseDescriptionPage;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.Messages;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.ObjectClassDescriptionPage;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.SchemaBrowserInput;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.SchemaBrowserNavigationLocation;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.INavigationLocation;
import org.eclipse.ui.INavigationLocationProvider;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorPart;

public class SchemaBrowser
extends EditorPart
implements INavigationLocationProvider,
IReusableEditor {
    private CTabFolder tabFolder;
    private CTabItem ocdTab;
    private ObjectClassDescriptionPage ocdPage;
    private CTabItem atdTab;
    private AttributeTypeDescriptionPage atdPage;
    private CTabItem mrdTab;
    private MatchingRuleDescriptionPage mrdPage;
    private CTabItem mrudTab;
    private MatchingRuleUseDescriptionPage mrudPage;
    private CTabItem lsdTab;
    private LdapSyntaxDescriptionPage lsdPage;

    public static String getId() {
        return BrowserUIConstants.EDITOR_SCHEMA_BROWSER;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(new SchemaBrowserInput(null, null));
        this.getSite().getPage().getNavigationHistory().markLocation((IEditorPart)this);
        this.setInput(input);
    }

    public void dispose() {
        this.ocdPage.dispose();
        this.atdPage.dispose();
        this.mrdPage.dispose();
        this.mrudPage.dispose();
        this.lsdPage.dispose();
        this.tabFolder.dispose();
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        this.tabFolder = new CTabFolder(parent, 1024);
        this.ocdTab = new CTabItem(this.tabFolder, 0);
        this.ocdTab.setText(Messages.getString("SchemaBrowser.ObjectClasses"));
        this.ocdTab.setImage(BrowserUIPlugin.getDefault().getImage("resources/icons/ocd.png"));
        this.ocdPage = new ObjectClassDescriptionPage(this);
        Control ocdPageControl = this.ocdPage.createControl((Composite)this.tabFolder);
        this.ocdTab.setControl(ocdPageControl);
        this.atdTab = new CTabItem(this.tabFolder, 0);
        this.atdTab.setText(Messages.getString("SchemaBrowser.AttributeTypes"));
        this.atdTab.setImage(BrowserUIPlugin.getDefault().getImage("resources/icons/atd.png"));
        this.atdPage = new AttributeTypeDescriptionPage(this);
        Control atdPageControl = this.atdPage.createControl((Composite)this.tabFolder);
        this.atdTab.setControl(atdPageControl);
        this.mrdTab = new CTabItem(this.tabFolder, 0);
        this.mrdTab.setText(Messages.getString("SchemaBrowser.MatchingRules"));
        this.mrdTab.setImage(BrowserUIPlugin.getDefault().getImage("resources/icons/mrd.png"));
        this.mrdPage = new MatchingRuleDescriptionPage(this);
        Control mrdPageControl = this.mrdPage.createControl((Composite)this.tabFolder);
        this.mrdTab.setControl(mrdPageControl);
        this.mrudTab = new CTabItem(this.tabFolder, 0);
        this.mrudTab.setImage(BrowserUIPlugin.getDefault().getImage("resources/icons/mrud.png"));
        this.mrudTab.setText(Messages.getString("SchemaBrowser.MatchingRulesUse"));
        this.mrudPage = new MatchingRuleUseDescriptionPage(this);
        Control mrudPageControl = this.mrudPage.createControl((Composite)this.tabFolder);
        this.mrudTab.setControl(mrudPageControl);
        this.lsdTab = new CTabItem(this.tabFolder, 0);
        this.lsdTab.setImage(BrowserUIPlugin.getDefault().getImage("resources/icons/lsd.png"));
        this.lsdTab.setText(Messages.getString("SchemaBrowser.Syntaxes"));
        this.lsdPage = new LdapSyntaxDescriptionPage(this);
        Control lsdPageControl = this.lsdPage.createControl((Composite)this.tabFolder);
        this.lsdTab.setControl(lsdPageControl);
        this.tabFolder.setSelection(this.ocdTab);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, BrowserUIConstants.PLUGIN_ID + "." + "tools_schema_browser");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.tabFolder, BrowserUIConstants.PLUGIN_ID + "." + "tools_schema_browser");
        PlatformUI.getWorkbench().getHelpSystem().setHelp(ocdPageControl, BrowserUIConstants.PLUGIN_ID + "." + "tools_schema_browser");
    }

    public void setInput(IEditorInput input) {
        super.setInput(input);
        if (input instanceof SchemaBrowserInput && this.tabFolder != null) {
            SchemaBrowserInput sbi = (SchemaBrowserInput)input;
            IBrowserConnection connection = sbi.getConnection();
            this.setConnection(connection);
            AbstractSchemaObject schemaElement = sbi.getSchemaElement();
            if (schemaElement instanceof ObjectClass) {
                this.ocdPage.select(schemaElement);
                this.tabFolder.setSelection(this.ocdTab);
            } else if (schemaElement instanceof AttributeType) {
                this.atdPage.select(schemaElement);
                this.tabFolder.setSelection(this.atdTab);
            } else if (schemaElement instanceof MatchingRule) {
                this.mrdPage.select(schemaElement);
                this.tabFolder.setSelection(this.mrdTab);
            } else if (schemaElement instanceof MatchingRuleUse) {
                this.mrudPage.select(schemaElement);
                this.tabFolder.setSelection(this.mrudTab);
            } else if (schemaElement instanceof LdapSyntax) {
                this.lsdPage.select(schemaElement);
                this.tabFolder.setSelection(this.lsdTab);
            }
            if (connection != null && schemaElement != null) {
                SchemaBrowserInput.enableOneInstanceHack(false);
                this.firePropertyChange(258);
                SchemaBrowserInput.enableOneInstanceHack(true);
                this.getSite().getPage().getNavigationHistory().markLocation((IEditorPart)this);
            }
            SchemaBrowserInput.enableOneInstanceHack(true);
        }
    }

    public void refresh() {
        this.ocdPage.refresh();
        this.atdPage.refresh();
        this.mrdPage.refresh();
        this.mrudPage.refresh();
        this.lsdPage.refresh();
    }

    public void setShowDefaultSchema(boolean b) {
        this.ocdPage.setShowDefaultSchema(b);
        this.atdPage.setShowDefaultSchema(b);
        this.mrdPage.setShowDefaultSchema(b);
        this.mrudPage.setShowDefaultSchema(b);
        this.lsdPage.setShowDefaultSchema(b);
    }

    public void setConnection(IBrowserConnection connection) {
        this.ocdPage.setConnection(connection);
        this.atdPage.setConnection(connection);
        this.mrdPage.setConnection(connection);
        this.mrudPage.setConnection(connection);
        this.lsdPage.setConnection(connection);
    }

    public void setFocus() {
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public INavigationLocation createEmptyNavigationLocation() {
        return null;
    }

    public INavigationLocation createNavigationLocation() {
        return new SchemaBrowserNavigationLocation(this);
    }
}

