/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.model.filter.parser;

import org.apache.directory.studio.ldapbrowser.core.model.filter.parser.LdapFilterToken;

public class LdapFilterScanner {
    private String filter = "";
    private int pos;
    private int lastTokenType;

    public void reset(String filter) {
        this.filter = filter;
        this.pos = -1;
        this.lastTokenType = Integer.MIN_VALUE;
    }

    private char currentChar() {
        return 0 <= this.pos && this.pos < this.filter.length() ? this.filter.charAt(this.pos) : (char)'\u0000';
    }

    private char nextChar() {
        ++this.pos;
        return this.currentChar();
    }

    private char prevChar() {
        --this.pos;
        return this.currentChar();
    }

    private char nextNonLinebreakChar() {
        while (this.nextChar() == '\n') {
        }
        return this.currentChar();
    }

    private char prevNonLinebreakChar() {
        while (this.prevChar() == '\n') {
        }
        return this.currentChar();
    }

    public LdapFilterToken nextToken() {
        int count;
        char t3;
        char c = this.nextChar();
        if (c == '\u0000') {
            return new LdapFilterToken(-1, "", this.pos);
        }
        this.prevChar();
        c = this.nextChar();
        if (Character.isWhitespace(c) && (this.lastTokenType == 12 || this.lastTokenType == 21 || this.lastTokenType == 22 || this.lastTokenType == 23)) {
            StringBuffer sb = new StringBuffer();
            while (Character.isWhitespace(c)) {
                sb.append(c);
                c = this.nextChar();
            }
            this.prevChar();
            return new LdapFilterToken(1, sb.toString(), this.pos - sb.length() + 1);
        }
        this.prevChar();
        c = this.nextChar();
        switch (c) {
            case '(': {
                this.lastTokenType = 11;
                return new LdapFilterToken(this.lastTokenType, "(", this.pos);
            }
            case ')': {
                if (this.lastTokenType != 41 && this.lastTokenType != 43 && this.lastTokenType != 44 && this.lastTokenType != 42 && this.lastTokenType != 46) {
                    this.lastTokenType = 12;
                    return new LdapFilterToken(this.lastTokenType, ")", this.pos);
                }
            }
            case '&': {
                if (this.lastTokenType != 11) break;
                this.lastTokenType = 21;
                return new LdapFilterToken(this.lastTokenType, "&", this.pos);
            }
            case '|': {
                if (this.lastTokenType != 11) break;
                this.lastTokenType = 22;
                return new LdapFilterToken(this.lastTokenType, "|", this.pos);
            }
            case '!': {
                if (this.lastTokenType != 11) break;
                this.lastTokenType = 23;
                return new LdapFilterToken(this.lastTokenType, "!", this.pos);
            }
            case '=': {
                if (this.lastTokenType == 31) {
                    if (this.nextChar() == '*') {
                        char t = this.nextChar();
                        if (t == ')' || t == '\u0000') {
                            this.prevChar();
                            this.lastTokenType = 45;
                            return new LdapFilterToken(this.lastTokenType, "=*", this.pos - 1);
                        }
                        this.prevChar();
                        this.prevChar();
                    } else {
                        this.prevChar();
                    }
                    boolean asteriskFound = false;
                    c = this.nextNonLinebreakChar();
                    int count2 = 1;
                    while (c != ')' && c != '\u0000') {
                        if (c == '*') {
                            asteriskFound = true;
                            break;
                        }
                        c = this.nextNonLinebreakChar();
                        ++count2;
                    }
                    while (count2 > 0) {
                        this.prevNonLinebreakChar();
                        --count2;
                    }
                    if (asteriskFound) {
                        this.lastTokenType = 46;
                        return new LdapFilterToken(this.lastTokenType, "=", this.pos);
                    }
                    this.lastTokenType = 41;
                    return new LdapFilterToken(this.lastTokenType, "=", this.pos);
                }
                if (this.lastTokenType != 66) break;
                this.lastTokenType = 41;
                return new LdapFilterToken(this.lastTokenType, "=", this.pos);
            }
            case '>': {
                if (this.lastTokenType != 31) break;
                if (this.nextChar() == '=') {
                    this.lastTokenType = 43;
                    return new LdapFilterToken(this.lastTokenType, ">=", this.pos - 1);
                }
                this.prevChar();
                break;
            }
            case '<': {
                if (this.lastTokenType != 31) break;
                if (this.nextChar() == '=') {
                    this.lastTokenType = 44;
                    return new LdapFilterToken(this.lastTokenType, "<=", this.pos - 1);
                }
                this.prevChar();
                break;
            }
            case '~': {
                if (this.lastTokenType != 31) break;
                if (this.nextChar() == '=') {
                    this.lastTokenType = 42;
                    return new LdapFilterToken(this.lastTokenType, "~=", this.pos - 1);
                }
                this.prevChar();
                break;
            }
            case ':': {
                char t1 = this.nextChar();
                char t2 = this.nextChar();
                t3 = this.nextChar();
                this.prevChar();
                this.prevChar();
                this.prevChar();
                if (!(this.lastTokenType != 11 && this.lastTokenType != 61 || t1 != 'd' && t1 != 'D' || t2 != 'n' && t2 != 'N' || t3 != ':')) {
                    this.lastTokenType = 62;
                    return new LdapFilterToken(this.lastTokenType, ":", this.pos);
                }
                if ((this.lastTokenType == 61 || this.lastTokenType == 63 || this.lastTokenType == 65 || this.lastTokenType == 64) && t1 == '=') {
                    this.lastTokenType = 66;
                    return new LdapFilterToken(this.lastTokenType, ":", this.pos);
                }
                if (this.lastTokenType != 11 && this.lastTokenType != 61 && this.lastTokenType != 63 && this.lastTokenType != 62) break;
                this.lastTokenType = 64;
                return new LdapFilterToken(this.lastTokenType, ":", this.pos);
            }
        }
        this.prevChar();
        if (this.lastTokenType == 11) {
            StringBuffer sb = new StringBuffer();
            c = this.nextChar();
            while (c != ':' && c != '=' && c != '<' && c != '>' && c != '~' && c != '(' && c != ')' && c != '\u0000' && !Character.isWhitespace(c)) {
                sb.append(c);
                c = this.nextChar();
            }
            this.prevChar();
            if (sb.length() > 0) {
                boolean isExtensible;
                boolean bl = isExtensible = c == ':';
                if (isExtensible) {
                    this.lastTokenType = 61;
                    return new LdapFilterToken(this.lastTokenType, sb.toString(), this.pos - sb.length() + 1);
                }
                this.lastTokenType = 31;
                return new LdapFilterToken(this.lastTokenType, sb.toString(), this.pos - sb.length() + 1);
            }
        }
        if (this.lastTokenType == 41 || this.lastTokenType == 43 || this.lastTokenType == 44 || this.lastTokenType == 42) {
            boolean forbiddenCharFound = false;
            StringBuffer sb = new StringBuffer();
            c = this.nextNonLinebreakChar();
            count = 0;
            while (c != ')' && c != '\u0000') {
                if (c == '*' || c == '(') {
                    forbiddenCharFound = true;
                    break;
                }
                sb.append(c);
                c = this.nextNonLinebreakChar();
                ++count;
            }
            this.prevNonLinebreakChar();
            if (forbiddenCharFound) {
                while (count > 0) {
                    this.prevNonLinebreakChar();
                    --count;
                }
            } else {
                this.lastTokenType = 51;
                return new LdapFilterToken(this.lastTokenType, sb.toString(), this.pos - sb.length() + 1);
            }
        }
        if (this.lastTokenType == 46) {
            boolean forbiddenCharFound = false;
            StringBuffer sb = new StringBuffer();
            c = this.nextNonLinebreakChar();
            count = 0;
            while (c != ')' && c != '\u0000') {
                if (c == '(') {
                    forbiddenCharFound = true;
                    break;
                }
                sb.append(c);
                c = this.nextNonLinebreakChar();
                ++count;
            }
            this.prevNonLinebreakChar();
            if (forbiddenCharFound) {
                while (count > 0) {
                    this.prevNonLinebreakChar();
                    --count;
                }
            } else if (sb.length() > 0) {
                this.lastTokenType = 51;
                return new LdapFilterToken(this.lastTokenType, sb.toString(), this.pos - sb.length() + 1);
            }
        }
        if (this.lastTokenType == 62) {
            char t1 = this.nextChar();
            char t2 = this.nextChar();
            t3 = this.nextChar();
            this.prevChar();
            if (!(t1 != 'd' && t1 != 'D' || t2 != 'n' && t2 != 'N' || t3 != ':' && t3 != '\u0000')) {
                this.lastTokenType = 63;
                return new LdapFilterToken(this.lastTokenType, "" + t1 + t2, this.pos - 1);
            }
            this.prevChar();
            this.prevChar();
        }
        if (this.lastTokenType == 64) {
            StringBuffer sb = new StringBuffer();
            c = this.nextChar();
            while (c != ':' && c != '=' && c != '<' && c != '>' && c != '~' && c != '(' && c != ')' && c != '\u0000' && !Character.isWhitespace(c)) {
                sb.append(c);
                c = this.nextChar();
            }
            this.prevChar();
            if (sb.length() > 0) {
                this.lastTokenType = 65;
                return new LdapFilterToken(this.lastTokenType, sb.toString(), this.pos - sb.length() + 1);
            }
        }
        StringBuffer sb = new StringBuffer();
        c = this.nextChar();
        while (c != '(' && c != ')' && c != '\u0000') {
            sb.append(c);
            c = this.nextChar();
        }
        this.prevChar();
        return new LdapFilterToken(0, sb.toString(), this.pos - sb.length() + 1);
    }
}

