/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.GtkAdjustment;
import org.eclipse.swt.internal.gtk.GtkBorder;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Spinner
extends Composite {
    static final int MIN_ARROW_WIDTH = 6;
    int lastEventTime = 0;
    int gdkEventKey = 0;
    int fixStart = -1;
    int fixEnd = -1;
    double climbRate = 1.0;
    public static final int LIMIT = Integer.MAX_VALUE;

    public Spinner(Composite parent, int style) {
        super(parent, Spinner.checkStyle(style));
    }

    public void addModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(24, typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    void addVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(25, typedListener);
    }

    static int checkStyle(int style) {
        return style & 0xFFFFFCFF;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        if (wHint != -1 && wHint < 0) {
            wHint = 0;
        }
        if (hHint != -1 && hHint < 0) {
            hHint = 0;
        }
        int[] w = new int[1];
        int[] h = new int[1];
        OS.gtk_widget_realize(this.handle);
        int layout = OS.gtk_entry_get_layout(this.handle);
        int hAdjustment = OS.gtk_spin_button_get_adjustment(this.handle);
        GtkAdjustment adjustment = new GtkAdjustment();
        OS.memmove(adjustment, hAdjustment);
        int digits = OS.gtk_spin_button_get_digits(this.handle);
        int i = 0;
        while (i < digits) {
            adjustment.upper *= 10.0;
            ++i;
        }
        String string = String.valueOf((int)adjustment.upper);
        if (digits > 0) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(string);
            buffer.append(this.getDecimalSeparator());
            int count = digits - string.length();
            while (count >= 0) {
                buffer.append("0");
                --count;
            }
            string = buffer.toString();
        }
        byte[] buffer1 = Converter.wcsToMbcs(null, string, false);
        int ptr = OS.pango_layout_get_text(layout);
        int length = OS.strlen(ptr);
        byte[] buffer2 = new byte[length];
        OS.memmove(buffer2, ptr, length);
        OS.pango_layout_set_text(layout, buffer1, buffer1.length);
        OS.pango_layout_get_size(layout, w, h);
        OS.pango_layout_set_text(layout, buffer2, buffer2.length);
        int width = OS.PANGO_PIXELS(w[0]);
        int height = OS.PANGO_PIXELS(h[0]);
        width = wHint == -1 ? width : wHint;
        height = hHint == -1 ? height : hHint;
        Rectangle trim = this.computeTrim(0, 0, width, height);
        return new Point(trim.width, trim.height);
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        int xborder = 0;
        int yborder = 0;
        int style = OS.gtk_widget_get_style(this.handle);
        if ((this.style & 0x800) != 0) {
            xborder += OS.gtk_style_get_xthickness(style);
            yborder += OS.gtk_style_get_ythickness(style);
        }
        int[] property = new int[1];
        OS.gtk_widget_style_get(this.handle, OS.interior_focus, property, 0);
        if (property[0] == 0) {
            OS.gtk_widget_style_get(this.handle, OS.focus_line_width, property, 0);
            xborder += property[0];
            yborder += property[0];
        }
        int fontDesc = OS.gtk_style_get_font_desc(style);
        int fontSize = OS.pango_font_description_get_size(fontDesc);
        int arrowSize = Math.max(OS.PANGO_PIXELS(fontSize), 6);
        arrowSize -= arrowSize % 2;
        Rectangle trim = super.computeTrim(x, y, width, height);
        trim.x -= xborder;
        trim.y -= yborder;
        trim.width += 2 * xborder;
        trim.height += 2 * yborder;
        trim.width += arrowSize + 2 * OS.gtk_style_get_xthickness(style);
        GtkBorder innerBorder = Display.getEntryInnerBorder(this.handle);
        trim.x -= innerBorder.left;
        trim.y -= innerBorder.top;
        trim.width += innerBorder.left + innerBorder.right;
        trim.height += innerBorder.top + innerBorder.bottom;
        return new Rectangle(trim.x, trim.y, trim.width, trim.height);
    }

    public void copy() {
        this.checkWidget();
        OS.gtk_editable_copy_clipboard(this.handle);
    }

    void createHandle(int index) {
        this.state |= 0x28;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0);
        if (this.fixedHandle == 0) {
            this.error(2);
        }
        OS.gtk_fixed_set_has_window(this.fixedHandle, true);
        int adjustment = OS.gtk_adjustment_new(0.0, 0.0, 100.0, 1.0, 10.0, 0.0);
        if (adjustment == 0) {
            this.error(2);
        }
        this.handle = OS.gtk_spin_button_new(adjustment, this.climbRate, 0);
        if (this.handle == 0) {
            this.error(2);
        }
        OS.gtk_container_add(this.fixedHandle, this.handle);
        OS.gtk_editable_set_editable(this.handle, (this.style & 8) == 0);
        OS.gtk_entry_set_has_frame(this.handle, (this.style & 0x800) != 0);
        OS.gtk_spin_button_set_wrap(this.handle, (this.style & 0x40) != 0);
    }

    public void cut() {
        this.checkWidget();
        OS.gtk_editable_cut_clipboard(this.handle);
    }

    void deregister() {
        super.deregister();
        int imContext = this.imContext();
        if (imContext != 0) {
            this.display.removeWidget(imContext);
        }
    }

    int eventWindow() {
        return this.paintWindow();
    }

    int enterExitHandle() {
        return this.fixedHandle;
    }

    boolean filterKey(int keyval, int event) {
        int time = OS.gdk_event_get_time(event);
        if (time != this.lastEventTime) {
            this.lastEventTime = time;
            int imContext = this.imContext();
            if (imContext != 0) {
                return OS.gtk_im_context_filter_keypress(imContext, event);
            }
        }
        this.gdkEventKey = event;
        return false;
    }

    void fixIM() {
        int imContext;
        if (this.gdkEventKey != 0 && this.gdkEventKey != -1 && (imContext = this.imContext()) != 0) {
            OS.gtk_im_context_filter_keypress(imContext, this.gdkEventKey);
            this.gdkEventKey = -1;
            return;
        }
        this.gdkEventKey = 0;
    }

    GdkColor getBackgroundColor() {
        return this.getBaseColor();
    }

    public int getBorderWidth() {
        this.checkWidget();
        int style = OS.gtk_widget_get_style(this.handle);
        if ((this.style & 0x800) != 0) {
            return OS.gtk_style_get_xthickness(style);
        }
        return 0;
    }

    GdkColor getForegroundColor() {
        return this.getTextColor();
    }

    public int getIncrement() {
        this.checkWidget();
        int hAdjustment = OS.gtk_spin_button_get_adjustment(this.handle);
        GtkAdjustment adjustment = new GtkAdjustment();
        OS.memmove(adjustment, hAdjustment);
        int digits = OS.gtk_spin_button_get_digits(this.handle);
        double value = adjustment.step_increment;
        int i = 0;
        while (i < digits) {
            value *= 10.0;
            ++i;
        }
        return (int)(value > 0.0 ? value + 0.5 : value - 0.5);
    }

    public int getMaximum() {
        this.checkWidget();
        int hAdjustment = OS.gtk_spin_button_get_adjustment(this.handle);
        GtkAdjustment adjustment = new GtkAdjustment();
        OS.memmove(adjustment, hAdjustment);
        int digits = OS.gtk_spin_button_get_digits(this.handle);
        double value = adjustment.upper;
        int i = 0;
        while (i < digits) {
            value *= 10.0;
            ++i;
        }
        return (int)(value > 0.0 ? value + 0.5 : value - 0.5);
    }

    public int getMinimum() {
        this.checkWidget();
        int hAdjustment = OS.gtk_spin_button_get_adjustment(this.handle);
        GtkAdjustment adjustment = new GtkAdjustment();
        OS.memmove(adjustment, hAdjustment);
        int digits = OS.gtk_spin_button_get_digits(this.handle);
        double value = adjustment.lower;
        int i = 0;
        while (i < digits) {
            value *= 10.0;
            ++i;
        }
        return (int)(value > 0.0 ? value + 0.5 : value - 0.5);
    }

    public int getPageIncrement() {
        this.checkWidget();
        int hAdjustment = OS.gtk_spin_button_get_adjustment(this.handle);
        GtkAdjustment adjustment = new GtkAdjustment();
        OS.memmove(adjustment, hAdjustment);
        int digits = OS.gtk_spin_button_get_digits(this.handle);
        double value = adjustment.page_increment;
        int i = 0;
        while (i < digits) {
            value *= 10.0;
            ++i;
        }
        return (int)(value > 0.0 ? value + 0.5 : value - 0.5);
    }

    public int getSelection() {
        this.checkWidget();
        int hAdjustment = OS.gtk_spin_button_get_adjustment(this.handle);
        GtkAdjustment adjustment = new GtkAdjustment();
        OS.memmove(adjustment, hAdjustment);
        int digits = OS.gtk_spin_button_get_digits(this.handle);
        double value = adjustment.value;
        int i = 0;
        while (i < digits) {
            value *= 10.0;
            ++i;
        }
        return (int)(value > 0.0 ? value + 0.5 : value - 0.5);
    }

    public String getText() {
        this.checkWidget();
        int str = OS.gtk_entry_get_text(this.handle);
        if (str == 0) {
            return "";
        }
        int length = OS.strlen(str);
        byte[] buffer = new byte[length];
        OS.memmove(buffer, str, length);
        return new String(Converter.mbcsToWcs(null, buffer));
    }

    public int getTextLimit() {
        this.checkWidget();
        int limit = OS.gtk_entry_get_max_length(this.handle);
        return limit == 0 ? 65535 : limit;
    }

    public int getDigits() {
        this.checkWidget();
        return OS.gtk_spin_button_get_digits(this.handle);
    }

    String getDecimalSeparator() {
        int ptr = OS.localeconv_decimal_point();
        int length = OS.strlen(ptr);
        byte[] buffer = new byte[length];
        OS.memmove(buffer, ptr, length);
        return new String(Converter.mbcsToWcs(null, buffer));
    }

    int gtk_activate(int widget) {
        this.sendSelectionEvent(14);
        return 0;
    }

    int gtk_changed(int widget) {
        int str = OS.gtk_entry_get_text(this.handle);
        int length = OS.strlen(str);
        if (length > 0) {
            int[] endptr = new int[1];
            double value = OS.g_strtod(str, endptr);
            if (endptr[0] == str + length) {
                int hAdjustment = OS.gtk_spin_button_get_adjustment(this.handle);
                GtkAdjustment adjustment = new GtkAdjustment();
                OS.memmove(adjustment, hAdjustment);
                if (value != adjustment.value && adjustment.lower <= value && value <= adjustment.upper) {
                    OS.gtk_spin_button_update(this.handle);
                }
            }
        }
        boolean keyPress = false;
        int eventPtr = OS.gtk_get_current_event();
        if (eventPtr != 0) {
            GdkEventKey gdkEvent = new GdkEventKey();
            OS.memmove(gdkEvent, eventPtr, GdkEventKey.sizeof);
            switch (gdkEvent.type) {
                case 8: {
                    keyPress = true;
                }
            }
            OS.gdk_event_free(eventPtr);
        }
        if (keyPress) {
            this.postEvent(24);
        } else {
            this.sendEvent(24);
        }
        return 0;
    }

    int gtk_commit(int imContext, int text) {
        if (text == 0) {
            return 0;
        }
        if (!OS.gtk_editable_get_editable(this.handle)) {
            return 0;
        }
        int length = OS.strlen(text);
        if (length == 0) {
            return 0;
        }
        byte[] buffer = new byte[length];
        OS.memmove(buffer, text, length);
        char[] chars = Converter.mbcsToWcs(null, buffer);
        char[] newChars = this.sendIMKeyEvent(1, null, chars);
        if (newChars == null) {
            return 0;
        }
        this.fixEnd = -1;
        this.fixStart = -1;
        OS.g_signal_handlers_block_matched(imContext, 16, 0, 0, 0, 0, 9);
        int id = OS.g_signal_lookup(OS.commit, OS.gtk_im_context_get_type());
        int mask = 17;
        OS.g_signal_handlers_unblock_matched(imContext, mask, id, 0, 0, 0, this.handle);
        if (newChars == chars) {
            OS.g_signal_emit_by_name(imContext, OS.commit, text);
        } else {
            buffer = Converter.wcsToMbcs(null, newChars, true);
            OS.g_signal_emit_by_name(imContext, OS.commit, buffer);
        }
        OS.g_signal_handlers_unblock_matched(imContext, 16, 0, 0, 0, 0, 9);
        OS.g_signal_handlers_block_matched(imContext, mask, id, 0, 0, 0, this.handle);
        if (this.fixStart != -1 && this.fixEnd != -1) {
            OS.gtk_editable_set_position(this.handle, this.fixStart);
            OS.gtk_editable_select_region(this.handle, this.fixStart, this.fixEnd);
        }
        this.fixEnd = -1;
        this.fixStart = -1;
        return 0;
    }

    int gtk_delete_text(int widget, int start_pos, int end_pos) {
        int end;
        int start;
        String newText;
        if (!this.hooks(25) && !this.filters(25)) {
            return 0;
        }
        int ptr = OS.gtk_entry_get_text(this.handle);
        if (end_pos == -1) {
            end_pos = OS.g_utf8_strlen(ptr, -1);
        }
        if ((newText = this.verifyText("", start = OS.g_utf8_offset_to_utf16_offset(ptr, start_pos), end = OS.g_utf8_offset_to_utf16_offset(ptr, end_pos))) == null) {
            OS.g_signal_stop_emission_by_name(this.handle, OS.delete_text);
        } else if (newText.length() > 0) {
            int[] pos = new int[]{end_pos};
            byte[] buffer = Converter.wcsToMbcs(null, newText, false);
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 6);
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 26);
            OS.gtk_editable_insert_text(this.handle, buffer, buffer.length, pos);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 26);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 6);
            OS.gtk_editable_set_position(this.handle, pos[0]);
        }
        return 0;
    }

    int gtk_event_after(int widget, int gdkEvent) {
        if (this.cursor != null) {
            this.setCursor(this.cursor.handle);
        }
        return super.gtk_event_after(widget, gdkEvent);
    }

    int gtk_focus_out_event(int widget, int event) {
        this.fixIM();
        return super.gtk_focus_out_event(widget, event);
    }

    int gtk_insert_text(int widget, int new_text, int new_text_length, int position) {
        int start;
        String newText;
        if (new_text == 0 || new_text_length == 0) {
            return 0;
        }
        byte[] buffer = new byte[new_text_length];
        OS.memmove(buffer, new_text, buffer.length);
        String oldText = new String(Converter.mbcsToWcs(null, buffer));
        int[] pos = new int[1];
        OS.memmove(pos, position, 4);
        int ptr = OS.gtk_entry_get_text(this.handle);
        if (pos[0] == -1) {
            pos[0] = OS.g_utf8_strlen(ptr, -1);
        }
        if ((newText = this.verifyText(oldText, start = OS.g_utf16_pointer_to_offset(ptr, pos[0]), start)) != oldText) {
            int[] newStart = new int[1];
            int[] newEnd = new int[1];
            OS.gtk_editable_get_selection_bounds(this.handle, newStart, newEnd);
            if (newText != null) {
                if (newStart[0] != newEnd[0]) {
                    OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 13);
                    OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 6);
                    OS.gtk_editable_delete_selection(this.handle);
                    OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 13);
                    OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 6);
                }
                byte[] buffer3 = Converter.wcsToMbcs(null, newText, false);
                OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 26);
                OS.gtk_editable_insert_text(this.handle, buffer3, buffer3.length, pos);
                OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 26);
                newStart[0] = newEnd[0] = pos[0];
            }
            pos[0] = newEnd[0];
            if (newStart[0] != newEnd[0]) {
                this.fixStart = newStart[0];
                this.fixEnd = newEnd[0];
            }
            OS.memmove(position, pos, 4);
            OS.g_signal_stop_emission_by_name(this.handle, OS.insert_text);
        }
        return 0;
    }

    int gtk_key_press_event(int widget, int event) {
        int result = super.gtk_key_press_event(widget, event);
        if (result != 0) {
            this.fixIM();
        }
        if (this.gdkEventKey == -1) {
            result = 1;
        }
        this.gdkEventKey = 0;
        return result;
    }

    int gtk_populate_popup(int widget, int menu) {
        if ((this.style & 0x4000000) != 0) {
            OS.gtk_widget_set_direction(menu, 2);
            OS.gtk_container_forall(menu, this.display.setDirectionProc, 2);
        }
        return 0;
    }

    int gtk_value_changed(int widget) {
        this.sendSelectionEvent(13);
        return 0;
    }

    void hookEvents() {
        super.hookEvents();
        OS.g_signal_connect_closure(this.handle, OS.changed, this.display.closures[6], true);
        OS.g_signal_connect_closure(this.handle, OS.insert_text, this.display.closures[26], false);
        OS.g_signal_connect_closure(this.handle, OS.delete_text, this.display.closures[13], false);
        OS.g_signal_connect_closure(this.handle, OS.value_changed, this.display.closures[57], false);
        OS.g_signal_connect_closure(this.handle, OS.activate, this.display.closures[1], false);
        OS.g_signal_connect_closure(this.handle, OS.populate_popup, this.display.closures[37], false);
        int imContext = this.imContext();
        if (imContext != 0) {
            OS.g_signal_connect_closure(imContext, OS.commit, this.display.closures[9], false);
            int id = OS.g_signal_lookup(OS.commit, OS.gtk_im_context_get_type());
            int mask = 17;
            OS.g_signal_handlers_block_matched(imContext, mask, id, 0, 0, 0, this.handle);
        }
    }

    int imContext() {
        return OS.GTK_ENTRY_IM_CONTEXT(this.handle);
    }

    int paintWindow() {
        int window = super.paintWindow();
        int children = OS.gdk_window_get_children(window);
        if (children != 0) {
            window = OS.g_list_data(children);
        }
        OS.g_list_free(children);
        return window;
    }

    public void paste() {
        this.checkWidget();
        OS.gtk_editable_paste_clipboard(this.handle);
    }

    void register() {
        super.register();
        int imContext = this.imContext();
        if (imContext != 0) {
            this.display.addWidget(imContext, this);
        }
    }

    void releaseWidget() {
        super.releaseWidget();
        this.fixIM();
    }

    public void removeModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    void removeVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, listener);
    }

    void setBackgroundColor(GdkColor color) {
        super.setBackgroundColor(color);
        OS.gtk_widget_modify_base(this.handle, 0, color);
    }

    void setCursor(int cursor) {
        int defaultCursor = 0;
        if (cursor == 0) {
            defaultCursor = OS.gdk_cursor_new(152);
        }
        super.setCursor(cursor != 0 ? cursor : defaultCursor);
        if (cursor == 0) {
            OS.gdk_cursor_unref(defaultCursor);
        }
    }

    void setFontDescription(int font) {
        super.setFontDescription(font);
    }

    public void setIncrement(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
        int hAdjustment = OS.gtk_spin_button_get_adjustment(this.handle);
        GtkAdjustment adjustment = new GtkAdjustment();
        OS.memmove(adjustment, hAdjustment);
        double newValue = value;
        int digits = OS.gtk_spin_button_get_digits(this.handle);
        int i = 0;
        while (i < digits) {
            newValue /= 10.0;
            ++i;
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 57);
        OS.gtk_spin_button_set_increments(this.handle, newValue, adjustment.page_increment);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 57);
    }

    public void setMaximum(int value) {
        this.checkWidget();
        int hAdjustment = OS.gtk_spin_button_get_adjustment(this.handle);
        GtkAdjustment adjustment = new GtkAdjustment();
        OS.memmove(adjustment, hAdjustment);
        double newValue = value;
        int digits = OS.gtk_spin_button_get_digits(this.handle);
        int i = 0;
        while (i < digits) {
            newValue /= 10.0;
            ++i;
        }
        if (newValue < adjustment.lower) {
            return;
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 57);
        OS.gtk_spin_button_set_range(this.handle, adjustment.lower, newValue);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 57);
    }

    public void setMinimum(int value) {
        this.checkWidget();
        int hAdjustment = OS.gtk_spin_button_get_adjustment(this.handle);
        GtkAdjustment adjustment = new GtkAdjustment();
        OS.memmove(adjustment, hAdjustment);
        double newValue = value;
        int digits = OS.gtk_spin_button_get_digits(this.handle);
        int i = 0;
        while (i < digits) {
            newValue /= 10.0;
            ++i;
        }
        if (newValue > adjustment.upper) {
            return;
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 57);
        OS.gtk_spin_button_set_range(this.handle, newValue, adjustment.upper);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 57);
    }

    public void setPageIncrement(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
        int hAdjustment = OS.gtk_spin_button_get_adjustment(this.handle);
        GtkAdjustment adjustment = new GtkAdjustment();
        OS.memmove(adjustment, hAdjustment);
        double newValue = value;
        int digits = OS.gtk_spin_button_get_digits(this.handle);
        int i = 0;
        while (i < digits) {
            newValue /= 10.0;
            ++i;
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 57);
        OS.gtk_spin_button_set_increments(this.handle, adjustment.step_increment, newValue);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 57);
    }

    public void setSelection(int value) {
        this.checkWidget();
        double newValue = value;
        int digits = OS.gtk_spin_button_get_digits(this.handle);
        int i = 0;
        while (i < digits) {
            newValue /= 10.0;
            ++i;
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 57);
        OS.gtk_spin_button_set_value(this.handle, newValue);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 57);
    }

    public void setTextLimit(int limit) {
        this.checkWidget();
        if (limit == 0) {
            this.error(7);
        }
        OS.gtk_entry_set_max_length(this.handle, limit);
    }

    public void setDigits(int value) {
        int digits;
        this.checkWidget();
        if (value < 0) {
            this.error(5);
        }
        if (value == (digits = OS.gtk_spin_button_get_digits(this.handle))) {
            return;
        }
        int hAdjustment = OS.gtk_spin_button_get_adjustment(this.handle);
        GtkAdjustment adjustment = new GtkAdjustment();
        OS.memmove(adjustment, hAdjustment);
        int diff = Math.abs(value - digits);
        int factor = 1;
        int i = 0;
        while (i < diff) {
            factor *= 10;
            ++i;
        }
        if (digits > value) {
            adjustment.value *= (double)factor;
            adjustment.upper *= (double)factor;
            adjustment.lower *= (double)factor;
            adjustment.step_increment *= (double)factor;
            adjustment.page_increment *= (double)factor;
            this.climbRate *= (double)factor;
        } else {
            adjustment.value /= (double)factor;
            adjustment.upper /= (double)factor;
            adjustment.lower /= (double)factor;
            adjustment.step_increment /= (double)factor;
            adjustment.page_increment /= (double)factor;
            this.climbRate /= (double)factor;
        }
        OS.memmove(hAdjustment, adjustment);
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 57);
        OS.gtk_spin_button_configure(this.handle, hAdjustment, this.climbRate, value);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 57);
    }

    public void setValues(int selection, int minimum, int maximum, int digits, int increment, int pageIncrement) {
        this.checkWidget();
        if (maximum < minimum) {
            return;
        }
        if (digits < 0) {
            return;
        }
        if (increment < 1) {
            return;
        }
        if (pageIncrement < 1) {
            return;
        }
        selection = Math.min(Math.max(minimum, selection), maximum);
        double factor = 1.0;
        int i = 0;
        while (i < digits) {
            factor *= 10.0;
            ++i;
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 57);
        OS.gtk_spin_button_set_range(this.handle, (double)minimum / factor, (double)maximum / factor);
        OS.gtk_spin_button_set_increments(this.handle, (double)increment / factor, (double)pageIncrement / factor);
        OS.gtk_spin_button_set_value(this.handle, (double)selection / factor);
        this.climbRate = 1.0 / factor;
        int adjustment = OS.gtk_spin_button_get_adjustment(this.handle);
        OS.gtk_spin_button_configure(this.handle, adjustment, this.climbRate, digits);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 57);
    }

    boolean checkSubwindow() {
        return false;
    }

    boolean translateTraversal(GdkEventKey keyEvent) {
        int key = keyEvent.keyval;
        switch (key) {
            case 65293: 
            case 65421: {
                int imContext = this.imContext();
                if (imContext == 0) break;
                int[] preeditString = new int[1];
                OS.gtk_im_context_get_preedit_string(imContext, preeditString, null, null);
                if (preeditString[0] == 0) break;
                int length = OS.strlen(preeditString[0]);
                OS.g_free(preeditString[0]);
                if (length == 0) break;
                return false;
            }
        }
        return super.translateTraversal(keyEvent);
    }

    String verifyText(String string, int start, int end) {
        if (string.length() == 0 && start == end) {
            return null;
        }
        Event event = new Event();
        event.text = string;
        event.start = start;
        event.end = end;
        int eventPtr = OS.gtk_get_current_event();
        if (eventPtr != 0) {
            GdkEventKey gdkEvent = new GdkEventKey();
            OS.memmove(gdkEvent, eventPtr, GdkEventKey.sizeof);
            switch (gdkEvent.type) {
                case 8: {
                    this.setKeyState(event, gdkEvent);
                }
            }
            OS.gdk_event_free(eventPtr);
        }
        int index = 0;
        if (OS.gtk_spin_button_get_digits(this.handle) > 0) {
            String decimalSeparator = this.getDecimalSeparator();
            index = string.indexOf(decimalSeparator);
            if (index != -1) {
                string = String.valueOf(string.substring(0, index)) + string.substring(index + 1);
            }
            index = 0;
        }
        if (string.length() > 0) {
            int hAdjustment = OS.gtk_spin_button_get_adjustment(this.handle);
            GtkAdjustment adjustment = new GtkAdjustment();
            OS.memmove(adjustment, hAdjustment);
            if (adjustment.lower < 0.0 && string.charAt(0) == '-') {
                ++index;
            }
        }
        while (index < string.length()) {
            if (!Character.isDigit(string.charAt(index))) break;
            ++index;
        }
        event.doit = index == string.length();
        this.sendEvent(25, event);
        if (!event.doit || this.isDisposed()) {
            return null;
        }
        return event.text;
    }
}

