/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.impl.avl;

import java.io.IOException;
import org.apache.directory.api.ldap.model.constants.Loggers;
import org.apache.directory.api.ldap.model.cursor.AbstractCursor;
import org.apache.directory.api.ldap.model.cursor.Cursor;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.cursor.InvalidCursorPositionException;
import org.apache.directory.api.ldap.model.cursor.SingletonCursor;
import org.apache.directory.api.ldap.model.cursor.Tuple;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.server.core.avltree.AvlSingletonOrOrderedSetCursor;
import org.apache.directory.server.core.avltree.AvlTree;
import org.apache.directory.server.core.avltree.AvlTreeCursor;
import org.apache.directory.server.core.avltree.SingletonOrOrderedSet;
import org.apache.directory.server.xdbm.impl.avl.AvlTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvlTableDupsCursor<K, V>
extends AbstractCursor<Tuple<K, V>> {
    private static final Logger LOG = LoggerFactory.getLogger(AvlTableDupsCursor.class);
    private static final Logger LOG_CURSOR = LoggerFactory.getLogger((String)Loggers.CURSOR_LOG.getName());
    private static final boolean IS_DEBUG = LOG_CURSOR.isDebugEnabled();
    private final AvlTable<K, V> table;
    private final AvlSingletonOrOrderedSetCursor<K, V> wrappedCursor;
    private Cursor<V> dupsCursor;
    private final Tuple<K, SingletonOrOrderedSet<V>> wrappedTuple = new Tuple();
    private final Tuple<K, V> returnedTuple = new Tuple();
    private boolean valueAvailable;

    public AvlTableDupsCursor(AvlTable<K, V> table) {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Creating AvlTableDupsCursor {}", (Object)this);
        }
        this.table = table;
        this.wrappedCursor = new AvlSingletonOrOrderedSetCursor(table.getAvlTreeMap());
        LOG.debug("Created on table {}", (Object)table.getName());
    }

    public boolean available() {
        return this.valueAvailable;
    }

    public void beforeKey(K key) throws Exception {
        this.beforeValue(key, null);
    }

    public void beforeValue(K key, V value) throws LdapException, CursorException, IOException {
        this.checkNotClosed("beforeValue()");
        this.wrappedCursor.beforeKey(key);
        if (this.dupsCursor != null) {
            this.dupsCursor.close();
        }
        if (this.wrappedCursor.next()) {
            this.wrappedTuple.setBoth(this.wrappedCursor.get());
            if (((SingletonOrOrderedSet)this.wrappedTuple.getValue()).isOrderedSet()) {
                AvlTree avlTree = ((SingletonOrOrderedSet)this.wrappedTuple.getValue()).getOrderedSet();
                this.dupsCursor = new AvlTreeCursor(avlTree);
            } else {
                this.dupsCursor = new SingletonCursor(((SingletonOrOrderedSet)this.wrappedTuple.getValue()).getSingleton(), this.wrappedCursor.getValuComparator());
            }
            if (value == null) {
                this.clearValue();
                return;
            }
            if (this.table.getKeyComparator().compare(this.wrappedTuple.getKey(), key) == 0) {
                this.dupsCursor.before(value);
            }
            this.clearValue();
            return;
        }
        this.clearValue();
        this.wrappedTuple.setKey(null);
        this.wrappedTuple.setValue(null);
    }

    public void afterKey(K key) throws Exception {
        this.afterValue(key, null);
    }

    public void afterValue(K key, V value) throws LdapException, CursorException, IOException {
        this.checkNotClosed("afterValue()");
        if (this.dupsCursor != null) {
            this.dupsCursor.close();
        }
        if (value == null) {
            this.wrappedCursor.afterKey(key);
        } else {
            this.wrappedCursor.beforeKey(key);
        }
        if (this.wrappedCursor.next()) {
            this.wrappedTuple.setBoth(this.wrappedCursor.get());
            SingletonOrOrderedSet values = (SingletonOrOrderedSet)this.wrappedTuple.getValue();
            if (values.isOrderedSet()) {
                AvlTree set = values.getOrderedSet();
                this.dupsCursor = new AvlTreeCursor(set);
            } else {
                this.dupsCursor = new SingletonCursor(values.getSingleton(), this.wrappedCursor.getValuComparator());
            }
            if (value == null) {
                this.clearValue();
                return;
            }
            if (this.table.getKeyComparator().compare(this.wrappedTuple.getKey(), key) == 0) {
                this.dupsCursor.after(value);
            }
            this.clearValue();
            return;
        }
        this.clearValue();
        this.wrappedTuple.setKey(null);
        this.wrappedTuple.setValue(null);
    }

    public void after(Tuple<K, V> element) throws LdapException, CursorException, IOException {
        this.afterValue(element.getKey(), element.getValue());
    }

    public void afterLast() throws LdapException, CursorException, IOException {
        this.checkNotClosed("afterLast()");
        this.clearValue();
        this.wrappedCursor.afterLast();
        this.wrappedTuple.setKey(null);
        this.wrappedTuple.setValue(null);
        if (this.dupsCursor != null) {
            this.dupsCursor.close();
        }
        this.dupsCursor = null;
    }

    public void before(Tuple<K, V> element) throws LdapException, CursorException, IOException {
        this.beforeValue(element.getKey(), element.getValue());
    }

    public void beforeFirst() throws LdapException, CursorException, IOException {
        this.checkNotClosed("beforeFirst()");
        this.clearValue();
        this.wrappedCursor.beforeFirst();
        this.wrappedTuple.setKey(null);
        this.wrappedTuple.setValue(null);
        if (this.dupsCursor != null) {
            this.dupsCursor.close();
        }
        this.dupsCursor = null;
    }

    public boolean first() throws LdapException, CursorException, IOException {
        this.checkNotClosed("first()");
        this.clearValue();
        if (this.dupsCursor != null) {
            this.dupsCursor.close();
        }
        this.dupsCursor = null;
        if (this.wrappedCursor.first()) {
            this.wrappedTuple.setBoth(this.wrappedCursor.get());
            SingletonOrOrderedSet values = (SingletonOrOrderedSet)this.wrappedTuple.getValue();
            this.dupsCursor = values.isOrderedSet() ? new AvlTreeCursor(values.getOrderedSet()) : new SingletonCursor(values.getSingleton(), this.wrappedCursor.getValuComparator());
            this.dupsCursor.first();
            this.valueAvailable = true;
            this.returnedTuple.setKey(this.wrappedTuple.getKey());
            this.returnedTuple.setValue(this.dupsCursor.get());
            return true;
        }
        return false;
    }

    public Tuple<K, V> get() throws CursorException, IOException {
        this.checkNotClosed("get()");
        if (!this.valueAvailable) {
            throw new InvalidCursorPositionException();
        }
        return this.returnedTuple;
    }

    public boolean last() throws LdapException, CursorException, IOException {
        this.checkNotClosed("last()");
        this.clearValue();
        if (this.dupsCursor != null) {
            this.dupsCursor.close();
        }
        if (this.wrappedCursor.last()) {
            this.wrappedTuple.setBoth(this.wrappedCursor.get());
            SingletonOrOrderedSet values = (SingletonOrOrderedSet)this.wrappedTuple.getValue();
            this.dupsCursor = values.isOrderedSet() ? new AvlTreeCursor(values.getOrderedSet()) : new SingletonCursor(values.getSingleton(), this.wrappedCursor.getValuComparator());
            this.dupsCursor.last();
            this.valueAvailable = true;
            this.returnedTuple.setKey(this.wrappedTuple.getKey());
            this.returnedTuple.setValue(this.dupsCursor.get());
            return true;
        }
        return false;
    }

    public boolean next() throws LdapException, CursorException, IOException {
        this.checkNotClosed("next()");
        if (null == this.dupsCursor || !this.dupsCursor.next()) {
            if (this.dupsCursor != null) {
                this.dupsCursor.close();
            }
            if (this.wrappedCursor.next()) {
                this.wrappedTuple.setBoth(this.wrappedCursor.get());
                SingletonOrOrderedSet values = (SingletonOrOrderedSet)this.wrappedTuple.getValue();
                this.dupsCursor = values.isOrderedSet() ? new AvlTreeCursor(values.getOrderedSet()) : new SingletonCursor(values.getSingleton(), this.wrappedCursor.getValuComparator());
                this.dupsCursor.beforeFirst();
                this.dupsCursor.next();
            } else {
                this.dupsCursor = null;
                return false;
            }
        }
        this.returnedTuple.setKey(this.wrappedTuple.getKey());
        this.returnedTuple.setValue(this.dupsCursor.get());
        this.valueAvailable = true;
        return true;
    }

    public boolean previous() throws LdapException, CursorException, IOException {
        this.checkNotClosed("previous()");
        if (null == this.dupsCursor || !this.dupsCursor.previous()) {
            if (this.dupsCursor != null) {
                this.dupsCursor.close();
            }
            if (this.wrappedCursor.previous()) {
                this.wrappedTuple.setBoth(this.wrappedCursor.get());
                SingletonOrOrderedSet values = (SingletonOrOrderedSet)this.wrappedTuple.getValue();
                this.dupsCursor = values.isOrderedSet() ? new AvlTreeCursor(values.getOrderedSet()) : new SingletonCursor(values.getSingleton(), this.wrappedCursor.getValuComparator());
                this.dupsCursor.afterLast();
                this.dupsCursor.previous();
            } else {
                this.dupsCursor = null;
                return false;
            }
        }
        this.returnedTuple.setKey(this.wrappedTuple.getKey());
        this.returnedTuple.setValue(this.dupsCursor.get());
        this.valueAvailable = true;
        return true;
    }

    public void close() {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing AvlTableDupsCursor {}", (Object)this);
        }
        if (this.dupsCursor != null) {
            this.dupsCursor.close();
        }
        this.wrappedCursor.close();
    }

    public void close(Exception reason) {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing AvlTableDupsCursor {}", (Object)this);
        }
        if (this.dupsCursor != null) {
            this.dupsCursor.close();
        }
        this.wrappedCursor.close();
    }

    private void clearValue() {
        this.returnedTuple.setKey(null);
        this.returnedTuple.setValue(null);
        this.valueAvailable = false;
    }
}

