/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds.configuration.model.v157;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.studio.apacheds.configuration.model.AbstractServerConfiguration;
import org.apache.directory.studio.apacheds.configuration.model.ServerConfiguration;
import org.apache.directory.studio.apacheds.configuration.model.ServerConfigurationVersionEnum;
import org.apache.directory.studio.apacheds.configuration.model.v157.ExtendedOperationEnum;
import org.apache.directory.studio.apacheds.configuration.model.v157.InterceptorEnum;
import org.apache.directory.studio.apacheds.configuration.model.v157.Partition;
import org.apache.directory.studio.apacheds.configuration.model.v157.SupportedMechanismEnum;

public class ServerConfigurationV157
extends AbstractServerConfiguration
implements ServerConfiguration {
    private int ldapPort;
    private boolean enableLdap;
    private int maxTimeLimit;
    private int maxSizeLimit;
    private long synchronizationPeriod;
    private int maxThreads;
    private List<SupportedMechanismEnum> supportedMechanisms = new ArrayList<SupportedMechanismEnum>();
    private String saslHost;
    private String saslPrincipal;
    private List<String> saslRealms = new ArrayList<String>();
    private String searchBaseDn;
    private boolean enableAccessControl;
    private boolean enableKerberos;
    private int kerberosPort;
    private boolean enableNtp;
    private int ntpPort;
    private boolean enableDns;
    private int dnsPort;
    private boolean enableLdaps;
    private int ldapsPort;
    private boolean enableChangePassword;
    private int changePasswordPort;
    private boolean denormalizeOpAttr;
    private boolean allowAnonymousAccess;
    private List<Partition> partitions = new ArrayList<Partition>();
    private List<InterceptorEnum> interceptors = new ArrayList<InterceptorEnum>();
    private List<ExtendedOperationEnum> extendedOperations = new ArrayList<ExtendedOperationEnum>();

    public ServerConfigurationV157() {
        super(ServerConfigurationVersionEnum.VERSION_1_5_7);
    }

    public boolean addExtendedOperation(ExtendedOperationEnum extendedOperation) {
        return this.extendedOperations.add(extendedOperation);
    }

    public boolean addInterceptor(InterceptorEnum interceptor) {
        return this.interceptors.add(interceptor);
    }

    public boolean addPartition(Partition partition) {
        return this.partitions.add(partition);
    }

    public boolean addSaslRealm(String saslRealm) {
        return this.saslRealms.add(saslRealm);
    }

    public boolean addSupportedMechanism(SupportedMechanismEnum supportedMechanism) {
        return this.supportedMechanisms.add(supportedMechanism);
    }

    public void clearExtendedOperations() {
        this.extendedOperations.clear();
    }

    public void clearInterceptors() {
        this.interceptors.clear();
    }

    public void clearPartitions() {
        this.partitions.clear();
    }

    public int getChangePasswordPort() {
        return this.changePasswordPort;
    }

    public int getDnsPort() {
        return this.dnsPort;
    }

    public List<ExtendedOperationEnum> getExtendedOperations() {
        return this.extendedOperations;
    }

    public List<InterceptorEnum> getInterceptors() {
        return this.interceptors;
    }

    public int getKerberosPort() {
        return this.kerberosPort;
    }

    public int getLdapsPort() {
        return this.ldapsPort;
    }

    public int getMaxSizeLimit() {
        return this.maxSizeLimit;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public int getMaxTimeLimit() {
        return this.maxTimeLimit;
    }

    public int getNtpPort() {
        return this.ntpPort;
    }

    public List<Partition> getPartitions() {
        return this.partitions;
    }

    public int getLdapPort() {
        return this.ldapPort;
    }

    public String getSaslHost() {
        return this.saslHost;
    }

    public String getSaslPrincipal() {
        return this.saslPrincipal;
    }

    public List<String> getSaslRealms() {
        return this.saslRealms;
    }

    public String getSearchBaseDn() {
        return this.searchBaseDn;
    }

    public List<SupportedMechanismEnum> getSupportedMechanisms() {
        return this.supportedMechanisms;
    }

    public long getSynchronizationPeriod() {
        return this.synchronizationPeriod;
    }

    public boolean isAllowAnonymousAccess() {
        return this.allowAnonymousAccess;
    }

    public boolean isDenormalizeOpAttr() {
        return this.denormalizeOpAttr;
    }

    public boolean isEnableAccessControl() {
        return this.enableAccessControl;
    }

    public boolean isEnableChangePassword() {
        return this.enableChangePassword;
    }

    public boolean isEnableDns() {
        return this.enableDns;
    }

    public boolean isEnableKerberos() {
        return this.enableKerberos;
    }

    public boolean isEnableLdap() {
        return this.enableLdap;
    }

    public boolean isEnableLdaps() {
        return this.enableLdaps;
    }

    public boolean isEnableNtp() {
        return this.enableNtp;
    }

    public boolean removeExtendedOperation(ExtendedOperationEnum extendedOperation) {
        return this.extendedOperations.remove((Object)extendedOperation);
    }

    public boolean removeExtendedOperation(String supportedMechanism) {
        return this.supportedMechanisms.remove(supportedMechanism);
    }

    public boolean removeInterceptor(InterceptorEnum interceptor) {
        return this.interceptors.remove((Object)interceptor);
    }

    public boolean removePartition(Partition partition) {
        return this.partitions.remove(partition);
    }

    public boolean removeSaslRealm(String saslRealm) {
        return this.saslRealms.remove(saslRealm);
    }

    public void setAllowAnonymousAccess(boolean allowAnonymousAccess) {
        this.allowAnonymousAccess = allowAnonymousAccess;
    }

    public void setChangePasswordPort(int changePasswordPort) {
        this.changePasswordPort = changePasswordPort;
    }

    public void setDenormalizeOpAttr(boolean denormalizeOpAttr) {
        this.denormalizeOpAttr = denormalizeOpAttr;
    }

    public void setDnsPort(int dnsPort) {
        this.dnsPort = dnsPort;
    }

    public void setEnableAccessControl(boolean enableAccessControl) {
        this.enableAccessControl = enableAccessControl;
    }

    public void setEnableChangePassword(boolean enableChangePassword) {
        this.enableChangePassword = enableChangePassword;
    }

    public void setEnableDns(boolean enableDns) {
        this.enableDns = enableDns;
    }

    public void setEnableKerberos(boolean enableKerberos) {
        this.enableKerberos = enableKerberos;
    }

    public void setEnableLdaps(boolean enableLdaps) {
        this.enableLdaps = enableLdaps;
    }

    public void setEnableLdap(boolean enableLdap) {
        this.enableLdap = enableLdap;
    }

    public void setEnableNtp(boolean enableNtp) {
        this.enableNtp = enableNtp;
    }

    public void setExtendedOperations(List<ExtendedOperationEnum> extendedOperations) {
        this.extendedOperations = extendedOperations;
    }

    public void setInterceptors(List<InterceptorEnum> interceptors) {
        this.interceptors = interceptors;
    }

    public void setKerberosPort(int kerberosPort) {
        this.kerberosPort = kerberosPort;
    }

    public void setLdapsPort(int ldapsPort) {
        this.ldapsPort = ldapsPort;
    }

    public void setMaxSizeLimit(int maxSizeLimit) {
        this.maxSizeLimit = maxSizeLimit;
    }

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    public void setMaxTimeLimit(int maxTimeLimit) {
        this.maxTimeLimit = maxTimeLimit;
    }

    public void setNtpPort(int ntpPort) {
        this.ntpPort = ntpPort;
    }

    public void setPartitions(List<Partition> partitions) {
        this.partitions = partitions;
    }

    public void setLdapPort(int ldapPort) {
        this.ldapPort = ldapPort;
    }

    public void setSaslHost(String saslHost) {
        this.saslHost = saslHost;
    }

    public void setSaslPrincipal(String saslPrincipal) {
        this.saslPrincipal = saslPrincipal;
    }

    public void setSaslRealms(List<String> saslRealms) {
        this.saslRealms = saslRealms;
    }

    public void setSearchBaseDn(String searchBaseDn) {
        this.searchBaseDn = searchBaseDn;
    }

    public void setSupportedMechanisms(List<SupportedMechanismEnum> supportedMechanisms) {
        this.supportedMechanisms = supportedMechanisms;
    }

    public void setSynchronizationPeriod(long synchronizationPeriod) {
        this.synchronizationPeriod = synchronizationPeriod;
    }
}

