/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds.configuration.editor;

import org.apache.directory.studio.apacheds.configuration.editor.Messages;
import org.apache.directory.studio.apacheds.configuration.model.ServerConfiguration;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

public class NonExistingServerConfigurationInput
implements IEditorInput {
    private ServerConfiguration serverConfiguration;

    public NonExistingServerConfigurationInput(ServerConfiguration serverConfiguration) {
        this.serverConfiguration = serverConfiguration;
    }

    public ServerConfiguration getServerConfiguration() {
        return this.serverConfiguration;
    }

    public String getToolTipText() {
        return this.getNameOrToolTipText();
    }

    public String getName() {
        return this.getNameOrToolTipText();
    }

    private String getNameOrToolTipText() {
        switch (this.serverConfiguration.getVersion()) {
            case VERSION_1_5_7: {
                return Messages.getString("NonExistingServerConfigurationInput.NewApacheDS157Configuration");
            }
            case VERSION_1_5_6: {
                return Messages.getString("NonExistingServerConfigurationInput.NewApacheDS156Configuration");
            }
            case VERSION_1_5_5: {
                return Messages.getString("NonExistingServerConfigurationInput.NewApacheDS155Configuration");
            }
            case VERSION_1_5_4: {
                return Messages.getString("NonExistingServerConfigurationInput.NewApacheDS154Configuration");
            }
            case VERSION_1_5_3: {
                return Messages.getString("NonExistingServerConfigurationInput.NewApacheDS153Configuration");
            }
            case VERSION_1_5_2: {
                return Messages.getString("NonExistingServerConfigurationInput.NewApacheDS152Configuration");
            }
            case VERSION_1_5_1: {
                return Messages.getString("NonExistingServerConfigurationInput.NewApacheDS151Configuration");
            }
            case VERSION_1_5_0: {
                return Messages.getString("NonExistingServerConfigurationInput.NewApacheDS150Configuration");
            }
        }
        return Messages.getString("NonExistingServerConfigurationInput.NewApacheDSConfiguration");
    }

    public boolean exists() {
        return this.serverConfiguration != null;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public boolean equals(Object obj) {
        ServerConfiguration inputServerConfiguration;
        NonExistingServerConfigurationInput input;
        if (obj == null) {
            return false;
        }
        if (obj instanceof NonExistingServerConfigurationInput && (input = (NonExistingServerConfigurationInput)obj).exists() && this.exists() && (inputServerConfiguration = input.getServerConfiguration()) != null && this.serverConfiguration != null) {
            return inputServerConfiguration.equals(this.serverConfiguration);
        }
        return false;
    }
}

