/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapservers.actions;

import java.util.PropertyResourceBundle;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionCorePlugin;
import org.apache.directory.studio.ldapservers.LdapServersPlugin;
import org.apache.directory.studio.ldapservers.actions.Messages;
import org.apache.directory.studio.ldapservers.model.LdapServer;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class CreateConnectionActionHelper {
    public static void createLdapBrowserConnection(LdapServer server, Connection connection) {
        ConnectionCorePlugin.getDefault().getConnectionManager().addConnection(connection);
        ConnectionCorePlugin.getDefault().getConnectionFolderManager().getRootConnectionFolder().addConnectionId(connection.getId());
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IPerspectiveDescriptor ldapPerspective = CreateConnectionActionHelper.getLdapPerspective();
        IPerspectiveDescriptor currentPerspective = window.getActivePage().getPerspective();
        if (ldapPerspective != null && ldapPerspective.equals(currentPerspective)) {
            MessageDialog dialog = new MessageDialog(window.getShell(), Messages.getString("CreateConnectionActionHelper.ConnectionCreated"), null, NLS.bind((String)Messages.getString("CreateConnectionActionHelper.ConnectionCalledCreated"), (Object[])new String[]{connection.getName()}), 2, new String[]{IDialogConstants.OK_LABEL}, 0);
            dialog.open();
        } else {
            MessageDialog dialog = new MessageDialog(window.getShell(), Messages.getString("CreateConnectionActionHelper.ConnectionCreated"), null, NLS.bind((String)Messages.getString("CreateConnectionActionHelper.ConnectionCalledCreatedSwitch"), (Object[])new String[]{connection.getName()}), 2, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
            if (dialog.open() == 0) {
                window.getActivePage().setPerspective(ldapPerspective);
            }
        }
    }

    private static IPerspectiveDescriptor getLdapPerspective() {
        for (IPerspectiveDescriptor perspective : PlatformUI.getWorkbench().getPerspectiveRegistry().getPerspectives()) {
            if (!LdapServersPlugin.getDefault().getPluginProperties().getString("Perspective_LdapBrowserPerspective_id").equalsIgnoreCase(perspective.getId())) continue;
            return perspective;
        }
        return null;
    }

    public static boolean isLdapBrowserPluginsAvailable() {
        PropertyResourceBundle properties = LdapServersPlugin.getDefault().getPluginProperties();
        Bundle connectionCoreBundle = Platform.getBundle((String)properties.getString("Plugin_ConnectionCore_id"));
        if (connectionCoreBundle != null) {
            if (connectionCoreBundle.getState() == 1) {
                return false;
            }
            Bundle connectionUiBundle = Platform.getBundle((String)properties.getString("Plugin_ConnectionUi_id"));
            if (connectionUiBundle != null) {
                if (connectionUiBundle.getState() == 1) {
                    return false;
                }
                Bundle ldapBrowserCommonBundle = Platform.getBundle((String)properties.getString("Plugin_LdapBrowserCommon_id"));
                if (ldapBrowserCommonBundle != null) {
                    if (ldapBrowserCommonBundle.getState() == 1) {
                        return false;
                    }
                    Bundle ldapBrowserCoreBundle = Platform.getBundle((String)properties.getString("Plugin_LdapBrowserCore_id"));
                    if (ldapBrowserCoreBundle != null) {
                        if (ldapBrowserCoreBundle.getState() == 1) {
                            return false;
                        }
                        Bundle ldapBrowserUiBundle = Platform.getBundle((String)properties.getString("Plugin_LdapBrowserUi_id"));
                        if (ldapBrowserUiBundle != null) {
                            if (ldapBrowserUiBundle.getState() == 1) {
                                return false;
                            }
                            Bundle ldifEditorBundle = Platform.getBundle((String)properties.getString("Plugin_LdifEditor_id"));
                            if (ldifEditorBundle != null) {
                                if (ldifEditorBundle.getState() == 1) {
                                    return false;
                                }
                                Bundle ldifParserBundle = Platform.getBundle((String)properties.getString("Plugin_LdifParser_id"));
                                if (ldifParserBundle != null) {
                                    return ldifParserBundle.getState() != 1;
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }
}

