/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.ui.actions;

import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionFolder;
import org.apache.directory.studio.connection.core.event.ConnectionEventRegistry;
import org.apache.directory.studio.connection.core.event.ConnectionUpdateListener;
import org.apache.directory.studio.connection.core.event.EventRunner;
import org.apache.directory.studio.connection.ui.ConnectionUIPlugin;
import org.apache.directory.studio.connection.ui.actions.ActionHandlerManager;
import org.apache.directory.studio.connection.ui.actions.SelectionUtils;
import org.apache.directory.studio.connection.ui.actions.StudioAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;

public abstract class StudioActionProxy
extends Action
implements ISelectionChangedListener,
ConnectionUpdateListener {
    private ActionHandlerManager actionHandlerManager;
    protected StudioAction action;
    protected ISelectionProvider selectionProvider;

    protected StudioActionProxy(ISelectionProvider selectionProvider, ActionHandlerManager actionHandlerManager, StudioAction action, int style) {
        super(action.getText(), style);
        this.selectionProvider = selectionProvider;
        this.actionHandlerManager = actionHandlerManager;
        this.action = action;
        super.setImageDescriptor(action.getImageDescriptor());
        super.setActionDefinitionId(action.getCommandId());
        selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
        ConnectionEventRegistry.addConnectionUpdateListener((ConnectionUpdateListener)this, (EventRunner)ConnectionUIPlugin.getDefault().getEventRunner());
        this.updateAction();
    }

    protected StudioActionProxy(ISelectionProvider selectionProvider, ActionHandlerManager actionHandlerManager, StudioAction action) {
        this(selectionProvider, actionHandlerManager, action, 1);
    }

    public void dispose() {
        ConnectionEventRegistry.removeConnectionUpdateListener((ConnectionUpdateListener)this);
        this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
        this.action.dispose();
        this.action = null;
    }

    public boolean isDisposed() {
        return this.action == null;
    }

    public final void connectionUpdated(Connection connection) {
        if (!this.isDisposed()) {
            this.updateAction();
        }
    }

    public void connectionAdded(Connection connection) {
        this.connectionUpdated(connection);
    }

    public void connectionRemoved(Connection connection) {
        this.connectionUpdated(connection);
    }

    public void connectionOpened(Connection connection) {
        this.connectionUpdated(connection);
    }

    public void connectionClosed(Connection connection) {
        this.connectionUpdated(connection);
    }

    public void connectionFolderModified(ConnectionFolder connectionFolder) {
        this.connectionUpdated(null);
    }

    public void connectionFolderAdded(ConnectionFolder connectionFolder) {
        this.connectionUpdated(null);
    }

    public void connectionFolderRemoved(ConnectionFolder connectionFolder) {
        this.connectionUpdated(null);
    }

    public void inputChanged(Object input) {
        if (!this.isDisposed()) {
            this.action.setInput(input);
            this.selectionChanged(new SelectionChangedEvent(this.selectionProvider, (ISelection)new StructuredSelection()));
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (!this.isDisposed()) {
            ISelection selection = event.getSelection();
            this.action.setSelectedConnections(SelectionUtils.getConnections(selection));
            this.action.setSelectedConnectionFolders(SelectionUtils.getConnectionFolders(selection));
            this.updateAction();
        }
    }

    public void updateAction() {
        if (!this.isDisposed()) {
            this.setText(this.action.getText());
            this.setToolTipText(this.action.getText());
            this.setEnabled(this.action.isEnabled());
            this.setImageDescriptor(this.action.getImageDescriptor());
            this.setChecked(this.action.isChecked());
        }
    }

    public void run() {
        if (!this.isDisposed()) {
            if (this.actionHandlerManager != null) {
                this.actionHandlerManager.deactivateGlobalActionHandlers();
            }
            this.action.run();
            if (this.actionHandlerManager != null) {
                this.actionHandlerManager.activateGlobalActionHandlers();
            }
        }
    }

    public StudioAction getAction() {
        return this.action;
    }
}

