/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.ui.actions;

import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionFolder;
import org.apache.directory.studio.connection.ui.actions.SelectionUtils;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public abstract class StudioAction
implements IWorkbenchWindowActionDelegate {
    private Connection[] selectedConnections;
    private ConnectionFolder[] selectedConnectionFolders;
    private Object input;

    protected StudioAction() {
        this.init();
    }

    public int getStyle() {
        return 1;
    }

    public void init(IWorkbenchWindow window) {
        this.init();
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.setSelectedConnections(SelectionUtils.getConnections(selection));
        this.setSelectedConnectionFolders(SelectionUtils.getConnectionFolders(selection));
        action.setEnabled(this.isEnabled());
        action.setText(this.getText());
        action.setToolTipText(this.getText());
    }

    public abstract String getText();

    public abstract ImageDescriptor getImageDescriptor();

    public abstract String getCommandId();

    public abstract boolean isEnabled();

    public abstract void run();

    public boolean isChecked() {
        return false;
    }

    private void init() {
        this.selectedConnections = new Connection[0];
        this.selectedConnectionFolders = new ConnectionFolder[0];
        this.input = null;
    }

    public void dispose() {
        this.selectedConnections = new Connection[0];
        this.selectedConnectionFolders = new ConnectionFolder[0];
        this.input = null;
    }

    protected Shell getShell() {
        return PlatformUI.getWorkbench().getDisplay().getActiveShell();
    }

    public Connection[] getSelectedConnections() {
        return this.selectedConnections;
    }

    public void setSelectedConnections(Connection[] selectedConnections) {
        this.selectedConnections = selectedConnections;
    }

    public ConnectionFolder[] getSelectedConnectionFolders() {
        return this.selectedConnectionFolders;
    }

    public void setSelectedConnectionFolders(ConnectionFolder[] selectedConnectionFolders) {
        this.selectedConnectionFolders = selectedConnectionFolders;
    }

    public Object getInput() {
        return this.input;
    }

    public void setInput(Object input) {
        this.input = input;
    }
}

