/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.ui;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import org.apache.directory.studio.connection.ui.ConnectionParameterPage;
import org.apache.directory.studio.connection.ui.ConnectionUIConstants;
import org.apache.directory.studio.connection.ui.ConnectionUIPlugin;
import org.apache.directory.studio.connection.ui.Messages;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public class ConnectionParameterPageManager {
    public static ConnectionParameterPage[] getConnectionParameterPages() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(ConnectionUIPlugin.getDefault().getPluginProperties().getString("ExtensionPoint_ConnectionParameterPages_id"));
        IConfigurationElement[] members = extensionPoint.getConfigurationElements();
        final HashMap<String, ConnectionParameterPage> pageMap = new HashMap<String, ConnectionParameterPage>();
        for (int m = 0; m < members.length; ++m) {
            IConfigurationElement member = members[m];
            try {
                ConnectionParameterPage page = (ConnectionParameterPage)member.createExecutableExtension("class");
                page.setPageId(member.getAttribute("id"));
                page.setPageName(member.getAttribute("name"));
                page.setPageDescription(member.getAttribute("description"));
                page.setPageDependsOnId(member.getAttribute("dependsOnId"));
                pageMap.put(page.getPageId(), page);
                continue;
            }
            catch (Exception e) {
                ConnectionUIPlugin.getDefault().getLog().log((IStatus)new Status(4, ConnectionUIConstants.PLUGIN_ID, 1, Messages.getString("ConnectionParameterPageManager.UnableCreateConnectionParamPage") + member.getAttribute("class"), (Throwable)e));
            }
        }
        ConnectionParameterPage[] pages = pageMap.values().toArray(new ConnectionParameterPage[0]);
        Comparator<ConnectionParameterPage> pageComparator = new Comparator<ConnectionParameterPage>(){

            @Override
            public int compare(ConnectionParameterPage p1, ConnectionParameterPage p2) {
                ConnectionParameterPage page;
                String dependsOnId1 = p1.getPageDependsOnId();
                String dependsOnId2 = p2.getPageDependsOnId();
                do {
                    if (dependsOnId1 == null && dependsOnId2 != null) {
                        return -1;
                    }
                    if (dependsOnId2 == null && dependsOnId1 != null) {
                        return 1;
                    }
                    if (dependsOnId1 != null && dependsOnId1.equals(p2.getPageId())) {
                        return 1;
                    }
                    if (dependsOnId2 == null || !dependsOnId2.equals(p1.getPageId())) continue;
                    return -1;
                } while ((dependsOnId1 = (page = (ConnectionParameterPage)pageMap.get(dependsOnId1)) != null && !page.getPageDependsOnId().equals(dependsOnId1) ? page.getPageDependsOnId() : null) != null && !dependsOnId1.equals(p1.getPageId()));
                dependsOnId1 = p1.getPageDependsOnId();
                dependsOnId2 = p2.getPageDependsOnId();
                do {
                    if (dependsOnId1 == null && dependsOnId2 != null) {
                        return -1;
                    }
                    if (dependsOnId2 == null && dependsOnId1 != null) {
                        return 1;
                    }
                    if (dependsOnId1 != null && dependsOnId1.equals(p2.getPageId())) {
                        return 1;
                    }
                    if (dependsOnId2 == null || !dependsOnId2.equals(p1.getPageId())) continue;
                    return -1;
                } while ((dependsOnId2 = (page = (ConnectionParameterPage)pageMap.get(dependsOnId2)) != null ? page.getPageDependsOnId() : null) != null && !dependsOnId2.equals(p2.getPageId()));
                return 0;
            }
        };
        Arrays.sort(pages, pageComparator);
        return pages;
    }
}

