/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.wizards;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.PluginConstants;
import org.apache.directory.studio.schemaeditor.controller.SchemaHandler;
import org.apache.directory.studio.schemaeditor.model.Schema;
import org.apache.directory.studio.schemaeditor.view.wizards.AbstractWizardPage;
import org.apache.directory.studio.schemaeditor.view.wizards.Messages;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ExportSchemasForADSWizardPage
extends AbstractWizardPage {
    private Schema[] selectedSchemas = new Schema[0];
    private SchemaHandler schemaHandler;
    public static final int EXPORT_MULTIPLE_FILES = 0;
    public static final int EXPORT_SINGLE_FILE = 1;
    private CheckboxTableViewer schemasTableViewer;
    private Button schemasTableSelectAllButton;
    private Button schemasTableDeselectAllButton;
    private Button exportMultipleFilesRadio;
    private Label exportMultipleFilesLabel;
    private Text exportMultipleFilesText;
    private Button exportMultipleFilesButton;
    private Button exportSingleFileRadio;
    private Label exportSingleFileLabel;
    private Text exportSingleFileText;
    private Button exportSingleFileButton;

    protected ExportSchemasForADSWizardPage() {
        super("ExportSchemasForADSWizardPage");
        this.setTitle(Messages.getString("ExportSchemasForADSWizardPage.ExportSchemas"));
        this.setDescription(Messages.getString("ExportSchemasForADSWizardPage.PleaseSelectSchemasToExport"));
        this.setImageDescriptor(Activator.getDefault().getImageDescriptor("resources/icons/schemas_export_for_ads_wizard.png"));
        this.schemaHandler = Activator.getDefault().getSchemaHandler();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        Group schemasGroup = new Group(composite, 0);
        schemasGroup.setText(Messages.getString("ExportSchemasForADSWizardPage.Schemas"));
        schemasGroup.setLayout((Layout)new GridLayout(2, false));
        schemasGroup.setLayoutData((Object)new GridData(4, 0, true, false));
        Label schemasLabel = new Label((Composite)schemasGroup, 0);
        schemasLabel.setText(Messages.getString("ExportSchemasForADSWizardPage.SelectSchemaToExport"));
        schemasLabel.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        this.schemasTableViewer = new CheckboxTableViewer(new Table((Composite)schemasGroup, 67616));
        GridData schemasTableViewerGridData = new GridData(4, 0, true, false, 1, 2);
        schemasTableViewerGridData.heightHint = 125;
        this.schemasTableViewer.getTable().setLayoutData((Object)schemasTableViewerGridData);
        this.schemasTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.schemasTableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Schema) {
                    return ((Schema)((Object)element)).getSchemaName();
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                if (element instanceof Schema) {
                    return Activator.getDefault().getImage("resources/icons/schema.gif");
                }
                return super.getImage(element);
            }
        });
        this.schemasTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ExportSchemasForADSWizardPage.this.dialogChanged();
            }
        });
        this.schemasTableSelectAllButton = new Button((Composite)schemasGroup, 8);
        this.schemasTableSelectAllButton.setText(Messages.getString("ExportSchemasForADSWizardPage.SelectAll"));
        this.schemasTableSelectAllButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this.schemasTableSelectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportSchemasForADSWizardPage.this.schemasTableViewer.setAllChecked(true);
                ExportSchemasForADSWizardPage.this.dialogChanged();
            }
        });
        this.schemasTableDeselectAllButton = new Button((Composite)schemasGroup, 8);
        this.schemasTableDeselectAllButton.setText(Messages.getString("ExportSchemasForADSWizardPage.DeselectAll"));
        this.schemasTableDeselectAllButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this.schemasTableDeselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportSchemasForADSWizardPage.this.schemasTableViewer.setAllChecked(false);
                ExportSchemasForADSWizardPage.this.dialogChanged();
            }
        });
        Group exportDestinationGroup = new Group(composite, 0);
        exportDestinationGroup.setText(Messages.getString("ExportSchemasForADSWizardPage.ExportDestination"));
        exportDestinationGroup.setLayout((Layout)new GridLayout(4, false));
        exportDestinationGroup.setLayoutData((Object)new GridData(4, 0, true, false));
        this.exportMultipleFilesRadio = new Button((Composite)exportDestinationGroup, 16);
        this.exportMultipleFilesRadio.setText(Messages.getString("ExportSchemasForADSWizardPage.ExportSchemaAsSeparateFiles"));
        this.exportMultipleFilesRadio.setLayoutData((Object)new GridData(4, 0, true, false, 4, 1));
        this.exportMultipleFilesRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportSchemasForADSWizardPage.this.exportMultipleFilesSelected();
                ExportSchemasForADSWizardPage.this.dialogChanged();
            }
        });
        Label exportMultipleFilesFiller = new Label((Composite)exportDestinationGroup, 0);
        exportMultipleFilesFiller.setText("    ");
        this.exportMultipleFilesLabel = new Label((Composite)exportDestinationGroup, 0);
        this.exportMultipleFilesLabel.setText(Messages.getString("ExportSchemasForADSWizardPage.Directory"));
        this.exportMultipleFilesText = new Text((Composite)exportDestinationGroup, 2048);
        this.exportMultipleFilesText.setLayoutData((Object)new GridData(4, 0, true, false));
        this.exportMultipleFilesText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportSchemasForADSWizardPage.this.dialogChanged();
            }
        });
        this.exportMultipleFilesButton = new Button((Composite)exportDestinationGroup, 8);
        this.exportMultipleFilesButton.setText(Messages.getString("ExportSchemasForADSWizardPage.Browse"));
        this.exportMultipleFilesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportSchemasForADSWizardPage.this.chooseExportDirectory();
                ExportSchemasForADSWizardPage.this.dialogChanged();
            }
        });
        this.exportSingleFileRadio = new Button((Composite)exportDestinationGroup, 16);
        this.exportSingleFileRadio.setText(Messages.getString("ExportSchemasForADSWizardPage.ExportSchemaAsSingleFile"));
        this.exportSingleFileRadio.setLayoutData((Object)new GridData(4, 0, true, false, 4, 1));
        this.exportSingleFileRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportSchemasForADSWizardPage.this.exportSingleFileSelected();
                ExportSchemasForADSWizardPage.this.dialogChanged();
            }
        });
        Label exportSingleFileFiller = new Label((Composite)exportDestinationGroup, 0);
        exportSingleFileFiller.setText("    ");
        this.exportSingleFileLabel = new Label((Composite)exportDestinationGroup, 0);
        this.exportSingleFileLabel.setText(Messages.getString("ExportSchemasForADSWizardPage.ExportFile"));
        this.exportSingleFileText = new Text((Composite)exportDestinationGroup, 2048);
        this.exportSingleFileText.setLayoutData((Object)new GridData(4, 0, true, false));
        this.exportSingleFileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportSchemasForADSWizardPage.this.dialogChanged();
            }
        });
        this.exportSingleFileButton = new Button((Composite)exportDestinationGroup, 8);
        this.exportSingleFileButton.setText(Messages.getString("ExportSchemasForADSWizardPage.Browse"));
        this.exportSingleFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportSchemasForADSWizardPage.this.chooseExportFile();
                ExportSchemasForADSWizardPage.this.dialogChanged();
            }
        });
        this.initFields();
        this.dialogChanged();
        this.setControl((Control)composite);
    }

    private void initFields() {
        if (this.schemaHandler != null) {
            ArrayList<Schema> schemas = new ArrayList<Schema>();
            schemas.addAll(this.schemaHandler.getSchemas());
            Collections.sort(schemas, new Comparator<Schema>(){

                @Override
                public int compare(Schema o1, Schema o2) {
                    return o1.getSchemaName().compareToIgnoreCase(o2.getSchemaName());
                }
            });
            this.schemasTableViewer.setInput(schemas);
            this.schemasTableViewer.setCheckedElements((Object[])this.selectedSchemas);
        }
        this.exportMultipleFilesSelected();
        this.displayErrorMessage(null);
        this.setPageComplete(false);
    }

    private void exportMultipleFilesSelected() {
        this.exportMultipleFilesRadio.setSelection(true);
        this.exportMultipleFilesLabel.setEnabled(true);
        this.exportMultipleFilesText.setEnabled(true);
        this.exportMultipleFilesButton.setEnabled(true);
        this.exportSingleFileRadio.setSelection(false);
        this.exportSingleFileLabel.setEnabled(false);
        this.exportSingleFileText.setEnabled(false);
        this.exportSingleFileButton.setEnabled(false);
    }

    private void exportSingleFileSelected() {
        this.exportMultipleFilesRadio.setSelection(false);
        this.exportMultipleFilesLabel.setEnabled(false);
        this.exportMultipleFilesText.setEnabled(false);
        this.exportMultipleFilesButton.setEnabled(false);
        this.exportSingleFileRadio.setSelection(true);
        this.exportSingleFileLabel.setEnabled(true);
        this.exportSingleFileText.setEnabled(true);
        this.exportSingleFileButton.setEnabled(true);
    }

    private void chooseExportDirectory() {
        DirectoryDialog dialog = new DirectoryDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        dialog.setText(Messages.getString("ExportSchemasForADSWizardPage.ChooseFolder"));
        dialog.setMessage(Messages.getString("ExportSchemasForADSWizardPage.SelectFolderToExportTo"));
        if ("".equals(this.exportMultipleFilesText.getText())) {
            dialog.setFilterPath(Activator.getDefault().getPreferenceStore().getString(PluginConstants.FILE_DIALOG_EXPORT_SCHEMAS_APACHE_DS));
        } else {
            dialog.setFilterPath(this.exportMultipleFilesText.getText());
        }
        String selectedDirectory = dialog.open();
        if (selectedDirectory != null) {
            this.exportMultipleFilesText.setText(selectedDirectory);
        }
    }

    private void chooseExportFile() {
        FileDialog dialog = new FileDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 8192);
        dialog.setText(Messages.getString("ExportSchemasForADSWizardPage.SelectFile"));
        dialog.setFilterExtensions(new String[]{"*.ldif", "*"});
        dialog.setFilterNames(new String[]{Messages.getString("ExportSchemasForADSWizardPage.LDIFFiles"), Messages.getString("ExportSchemasForADSWizardPage.AllFiles")});
        if ("".equals(this.exportSingleFileText.getText())) {
            dialog.setFilterPath(Activator.getDefault().getPreferenceStore().getString(PluginConstants.FILE_DIALOG_EXPORT_SCHEMAS_APACHE_DS));
        } else {
            dialog.setFilterPath(this.exportSingleFileText.getText());
        }
        String selectedFile = dialog.open();
        if (selectedFile != null) {
            this.exportSingleFileText.setText(selectedFile);
        }
    }

    private void dialogChanged() {
        if (this.schemaHandler == null) {
            this.displayErrorMessage(Messages.getString("ExportSchemasForADSWizardPage.ErrorNoSchemaProjectOpen"));
            return;
        }
        if (this.schemasTableViewer.getCheckedElements().length == 0) {
            this.displayErrorMessage(Messages.getString("ExportSchemasForADSWizardPage.ErrorNoSchemaSelected"));
            return;
        }
        if (this.exportMultipleFilesRadio.getSelection()) {
            String directory = this.exportMultipleFilesText.getText();
            if (directory == null || directory.equals("")) {
                this.displayErrorMessage(Messages.getString("ExportSchemasForADSWizardPage.ErrorNoDirectorySelected"));
                return;
            }
            File directoryFile = new File(directory);
            if (!directoryFile.exists()) {
                this.displayErrorMessage(Messages.getString("ExportSchemasForADSWizardPage.ErrorSelectedDirectoryNotExists"));
                return;
            }
            if (!directoryFile.isDirectory()) {
                this.displayErrorMessage(Messages.getString("ExportSchemasForADSWizardPage.ErrorSelectedDirectoryNotDirectory"));
                return;
            }
            if (!directoryFile.canWrite()) {
                this.displayErrorMessage(Messages.getString("ExportSchemasForADSWizardPage.ErrorSelectedDirectoryNotWritable"));
                return;
            }
        } else if (this.exportSingleFileRadio.getSelection()) {
            String exportFile = this.exportSingleFileText.getText();
            if (exportFile == null || exportFile.equals("")) {
                this.displayErrorMessage(Messages.getString("ExportSchemasForADSWizardPage.ErrorNoFileSelected"));
                return;
            }
            File file = new File(exportFile);
            if (!file.getParentFile().canWrite()) {
                this.displayErrorMessage(Messages.getString("ExportSchemasForADSWizardPage.ErrorSelectedFileNotWritable"));
                return;
            }
        }
        this.displayErrorMessage(null);
    }

    public Schema[] getSelectedSchemas() {
        Object[] selectedSchemas = this.schemasTableViewer.getCheckedElements();
        ArrayList<Schema> schemas = new ArrayList<Schema>();
        for (Object schema : selectedSchemas) {
            schemas.add((Schema)((Object)schema));
        }
        return schemas.toArray(new Schema[0]);
    }

    public void setSelectedSchemas(Schema[] schemas) {
        this.selectedSchemas = schemas;
    }

    public int getExportType() {
        if (this.exportMultipleFilesRadio.getSelection()) {
            return 0;
        }
        if (this.exportSingleFileRadio.getSelection()) {
            return 1;
        }
        return 0;
    }

    public String getExportDirectory() {
        return this.exportMultipleFilesText.getText();
    }

    public String getExportFile() {
        return this.exportSingleFileText.getText();
    }

    public void saveDialogSettings() {
        if (this.exportMultipleFilesRadio.getSelection()) {
            Activator.getDefault().getPreferenceStore().putValue(PluginConstants.FILE_DIALOG_EXPORT_SCHEMAS_APACHE_DS, this.exportMultipleFilesText.getText());
        } else {
            Activator.getDefault().getPreferenceStore().putValue(PluginConstants.FILE_DIALOG_EXPORT_SCHEMAS_APACHE_DS, new File(this.exportSingleFileText.getText()).getParent());
        }
    }
}

