/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.model.io;

import java.util.List;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.api.ldap.model.schema.ObjectClassTypeEnum;
import org.apache.directory.api.ldap.model.schema.UsageEnum;
import org.apache.directory.studio.schemaeditor.model.Schema;

public class OpenLdapSchemaFileExporter {
    public static String toSourceCode(Schema schema) {
        StringBuffer sb = new StringBuffer();
        for (AttributeType attributeType : schema.getAttributeTypes()) {
            sb.append(OpenLdapSchemaFileExporter.toSourceCode(attributeType));
            sb.append("\n");
        }
        for (ObjectClass objectClass : schema.getObjectClasses()) {
            sb.append(OpenLdapSchemaFileExporter.toSourceCode(objectClass));
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String toSourceCode(AttributeType at) {
        UsageEnum usage;
        StringBuffer sb = new StringBuffer();
        sb.append("attributetype ( " + at.getOid() + " \n");
        List names = at.getNames();
        if (names != null && names.size() > 0) {
            sb.append("\tNAME ");
            if (names.size() > 1) {
                sb.append("( ");
                for (String name : names) {
                    sb.append("'" + name + "' ");
                }
                sb.append(") \n");
            } else {
                sb.append("'" + (String)names.get(0) + "' \n");
            }
        }
        if (at.getDescription() != null && !at.getDescription().equals("")) {
            sb.append("\tDESC '" + at.getDescription() + "' \n");
        }
        if (at.isObsolete()) {
            sb.append("\tOBSOLETE \n");
        }
        if (at.getSuperiorOid() != null && !at.getSuperiorOid().equals("")) {
            sb.append("\tSUP " + at.getSuperiorOid() + " \n");
        }
        if (at.getEqualityOid() != null && !at.getEqualityOid().equals("")) {
            sb.append("\tEQUALITY " + at.getEqualityOid() + " \n");
        }
        if (at.getOrderingOid() != null && !at.getOrderingOid().equals("")) {
            sb.append("\tORDERING " + at.getOrderingOid() + " \n");
        }
        if (at.getSubstringOid() != null && !at.getSubstringOid().equals("")) {
            sb.append("\tSUBSTR " + at.getSubstringOid() + " \n");
        }
        if (at.getSyntaxOid() != null && !at.getSyntaxOid().equals("")) {
            sb.append("\tSYNTAX " + at.getSyntaxOid());
            if (at.getSyntaxLength() > 0L) {
                sb.append("{" + at.getSyntaxLength() + "}");
            }
            sb.append(" \n");
        }
        if (at.isSingleValued()) {
            sb.append("\tSINGLE-VALUE \n");
        }
        if (at.isCollective()) {
            sb.append("\tCOLLECTIVE \n");
        }
        if (!at.isUserModifiable()) {
            sb.append("\tNO-USER-MODIFICATION \n");
        }
        if ((usage = at.getUsage()) != null) {
            if (usage == UsageEnum.DIRECTORY_OPERATION) {
                sb.append("\tUSAGE directoryOperation \n");
            } else if (usage == UsageEnum.DISTRIBUTED_OPERATION) {
                sb.append("\tUSAGE distributedOperation \n");
            } else if (usage == UsageEnum.DSA_OPERATION) {
                sb.append("\tUSAGE dSAOperation \n");
            } else if (usage == UsageEnum.USER_APPLICATIONS) {
                // empty if block
            }
        }
        sb.append(" )\n");
        return sb.toString();
    }

    public static String toSourceCode(ObjectClass oc) {
        List may;
        ObjectClassTypeEnum classtype;
        List superiors;
        StringBuffer sb = new StringBuffer();
        sb.append("objectclass ( " + oc.getOid() + " \n");
        List names = oc.getNames();
        if (names != null && names.size() > 0) {
            sb.append("\tNAME ");
            if (names.size() > 1) {
                sb.append("( ");
                for (String name : names) {
                    sb.append("'" + name + "' ");
                }
                sb.append(") \n");
            } else {
                sb.append("'" + (String)names.get(0) + "' \n");
            }
        }
        if (oc.getDescription() != null && !oc.getDescription().equals("")) {
            sb.append("\tDESC '" + oc.getDescription() + "' \n");
        }
        if (oc.isObsolete()) {
            sb.append("\tOBSOLETE \n");
        }
        if ((superiors = oc.getSuperiorOids()) != null && superiors.size() != 0) {
            if (superiors.size() > 1) {
                sb.append("\tSUP (" + (String)superiors.get(0));
                for (int i = 1; i < superiors.size(); ++i) {
                    sb.append(" $ " + (String)superiors.get(i));
                }
                sb.append(") \n");
            } else {
                sb.append("\tSUP " + (String)superiors.get(0) + " \n");
            }
        }
        if ((classtype = oc.getType()) == ObjectClassTypeEnum.ABSTRACT) {
            sb.append("\tABSTRACT \n");
        } else if (classtype == ObjectClassTypeEnum.AUXILIARY) {
            sb.append("\tAUXILIARY \n");
        } else if (classtype == ObjectClassTypeEnum.STRUCTURAL) {
            sb.append("\tSTRUCTURAL \n");
        }
        List must = oc.getMustAttributeTypeOids();
        if (must != null && must.size() != 0) {
            sb.append("\tMUST ");
            if (must.size() > 1) {
                sb.append("( " + (String)must.get(0) + " ");
                for (int i = 1; i < must.size(); ++i) {
                    sb.append("$ " + (String)must.get(i) + " ");
                }
                sb.append(") \n");
            } else if (must.size() == 1) {
                sb.append((String)must.get(0) + " \n");
            }
        }
        if ((may = oc.getMayAttributeTypeOids()) != null && may.size() != 0) {
            sb.append("\tMAY ");
            if (may.size() > 1) {
                sb.append("( " + (String)may.get(0) + " ");
                for (int i = 1; i < may.size(); ++i) {
                    sb.append("$ " + (String)may.get(i) + " ");
                }
                sb.append(") \n");
            } else if (may.size() == 1) {
                sb.append((String)may.get(0) + " \n");
            }
        }
        sb.append(" )\n");
        return sb.toString();
    }
}

