/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.model.io;

import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.LdapSyntax;
import org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.directory.api.ldap.model.schema.MutableAttributeType;
import org.apache.directory.api.ldap.model.schema.MutableMatchingRule;
import org.apache.directory.api.ldap.model.schema.MutableObjectClass;
import org.apache.directory.api.ldap.model.schema.ObjectClassTypeEnum;
import org.apache.directory.api.ldap.model.schema.UsageEnum;
import org.apache.directory.studio.common.core.jobs.StudioProgressMonitor;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.io.ConnectionWrapper;
import org.apache.directory.studio.connection.core.io.StudioNamingEnumeration;
import org.apache.directory.studio.schemaeditor.model.Project;
import org.apache.directory.studio.schemaeditor.model.Schema;
import org.apache.directory.studio.schemaeditor.model.io.AbstractSchemaConnector;
import org.apache.directory.studio.schemaeditor.model.io.Messages;
import org.apache.directory.studio.schemaeditor.model.io.SchemaConnector;
import org.apache.directory.studio.schemaeditor.model.io.SchemaConnectorException;

public class ApacheDsSchemaConnector
extends AbstractSchemaConnector
implements SchemaConnector {
    public static final String SCHEMA_DN = "ou=schema";
    private static final String META_ATTRIBUTE_TYPE = "metaAttributeType";
    private static final String META_OBJECT_CLASS = "metaObjectClass";
    private static final String META_MATCHING_RULE = "metaMatchingRule";
    private static final String META_SYNTAX = "metaSyntax";
    private static final Connection.AliasDereferencingMethod DEREF_ALIAS_METHOD = Connection.AliasDereferencingMethod.ALWAYS;
    private static final Connection.ReferralHandlingMethod HANDLE_REFERALS_METHOD = Connection.ReferralHandlingMethod.FOLLOW;

    @Override
    public void importSchema(Project project, StudioProgressMonitor monitor) throws SchemaConnectorException {
        monitor.beginTask(Messages.getString("ApacheDsSchemaConnector.FetchingSchema"), 1);
        ArrayList<Schema> schemas = new ArrayList<Schema>();
        project.setInitialSchema(schemas);
        ConnectionWrapper wrapper = project.getConnection().getConnectionWrapper();
        SearchControls constraintSearch = new SearchControls();
        constraintSearch.setSearchScope(1);
        StudioNamingEnumeration answer = wrapper.search(SCHEMA_DN, "(objectclass=metaSchema)", constraintSearch, DEREF_ALIAS_METHOD, HANDLE_REFERALS_METHOD, null, monitor, null);
        if (answer != null) {
            try {
                while (answer.hasMore()) {
                    SearchResult searchResult = (SearchResult)answer.next();
                    Attribute cnAttribute = searchResult.getAttributes().get("cn");
                    NamingEnumeration<?> ne = null;
                    ne = cnAttribute.getAll();
                    if (ne == null) continue;
                    while (ne.hasMore()) {
                        Schema schema = ApacheDsSchemaConnector.getSchema(wrapper, (String)ne.next(), monitor);
                        schema.setProject(project);
                        schemas.add(schema);
                    }
                }
            }
            catch (Exception e) {
                throw new SchemaConnectorException(e);
            }
        }
        monitor.worked(1);
    }

    @Override
    public boolean isSuitableConnector(Connection connection, StudioProgressMonitor monitor) {
        block7: {
            ConnectionWrapper wrapper = connection.getConnectionWrapper();
            SearchControls constraintSearch = new SearchControls();
            constraintSearch.setSearchScope(0);
            constraintSearch.setReturningAttributes(new String[]{"+"});
            StudioNamingEnumeration answer = wrapper.search("", "(objectclass=*)", constraintSearch, DEREF_ALIAS_METHOD, HANDLE_REFERALS_METHOD, null, monitor, null);
            if (answer != null) {
                try {
                    if (!answer.hasMore()) break block7;
                    SearchResult searchResult = (SearchResult)answer.next();
                    Attribute vendorNameAttribute = searchResult.getAttributes().get("vendorName");
                    if (vendorNameAttribute == null) {
                        return false;
                    }
                    if (vendorNameAttribute.size() != 1) {
                        return false;
                    }
                    String vendorName = null;
                    try {
                        vendorName = (String)vendorNameAttribute.get();
                    }
                    catch (NamingException e) {
                        return false;
                    }
                    return vendorName != null && vendorName.equalsIgnoreCase("Apache Software Foundation");
                }
                catch (NamingException e) {
                    monitor.reportError((Exception)e);
                }
            }
        }
        return false;
    }

    private static Schema getSchema(ConnectionWrapper wrapper, String name, StudioProgressMonitor monitor) throws NamingException {
        monitor.subTask(name);
        Schema schema = new Schema(name);
        SearchControls constraintSearch = new SearchControls();
        constraintSearch.setSearchScope(2);
        StudioNamingEnumeration answer = wrapper.search("cn=" + name + ", ou=schema", "(objectclass=*)", constraintSearch, DEREF_ALIAS_METHOD, HANDLE_REFERALS_METHOD, null, monitor, null);
        if (answer != null) {
            try {
                while (answer.hasMore()) {
                    SearchResult searchResult = (SearchResult)answer.next();
                    switch (ApacheDsSchemaConnector.getNodeType(searchResult)) {
                        case ATTRIBUTE_TYPE: {
                            AttributeType at = ApacheDsSchemaConnector.createAttributeType(searchResult);
                            at.setSchemaName(name);
                            schema.addAttributeType(at);
                            break;
                        }
                        case OBJECT_CLASS: {
                            MutableObjectClass oc = ApacheDsSchemaConnector.createObjectClass(searchResult);
                            oc.setSchemaName(name);
                            schema.addObjectClass(oc);
                            break;
                        }
                        case MATCHING_RULE: {
                            MatchingRule mr = ApacheDsSchemaConnector.createMatchingRule(searchResult);
                            mr.setSchemaName(name);
                            schema.addMatchingRule(mr);
                            break;
                        }
                        case SYNTAX: {
                            LdapSyntax syntax = ApacheDsSchemaConnector.createSyntax(searchResult);
                            syntax.setSchemaName(name);
                            schema.addSyntax(syntax);
                            break;
                        }
                    }
                }
            }
            catch (NamingException e) {
                monitor.reportError((Exception)e);
            }
        }
        return schema;
    }

    private static SchemaNodeTypes getNodeType(SearchResult sr) throws NamingException {
        Attribute objectClassAttribute = sr.getAttributes().get("objectClass");
        NamingEnumeration<?> ne = objectClassAttribute.getAll();
        while (ne.hasMore()) {
            String value = (String)ne.next();
            if (META_ATTRIBUTE_TYPE.equals(value)) {
                return SchemaNodeTypes.ATTRIBUTE_TYPE;
            }
            if (META_OBJECT_CLASS.equals(value)) {
                return SchemaNodeTypes.OBJECT_CLASS;
            }
            if (META_MATCHING_RULE.equals(value)) {
                return SchemaNodeTypes.MATCHING_RULE;
            }
            if (!META_SYNTAX.equals(value)) continue;
            return SchemaNodeTypes.SYNTAX;
        }
        return SchemaNodeTypes.UNKNOWN;
    }

    private static AttributeType createAttributeType(SearchResult sr) throws NamingException {
        MutableAttributeType at = new MutableAttributeType(ApacheDsSchemaConnector.getOid(sr));
        at.setNames(ApacheDsSchemaConnector.getNames(sr));
        at.setDescription(ApacheDsSchemaConnector.getDescription(sr));
        at.setObsolete(ApacheDsSchemaConnector.isObsolete(sr));
        at.setSuperiorOid(ApacheDsSchemaConnector.getSuperior(sr));
        at.setUsage(ApacheDsSchemaConnector.getUsage(sr));
        at.setSyntaxOid(ApacheDsSchemaConnector.getSyntax(sr));
        at.setSyntaxLength((long)ApacheDsSchemaConnector.getSyntaxLength(sr));
        at.setCollective(ApacheDsSchemaConnector.isCollective(sr));
        at.setSingleValued(ApacheDsSchemaConnector.isSingleValued(sr));
        at.setUserModifiable(ApacheDsSchemaConnector.isUserModifiable(sr));
        at.setEqualityOid(ApacheDsSchemaConnector.getEquality(sr));
        at.setOrderingOid(ApacheDsSchemaConnector.getOrdering(sr));
        at.setSubstringOid(ApacheDsSchemaConnector.getSubstring(sr));
        return at;
    }

    private static MutableObjectClass createObjectClass(SearchResult sr) throws NamingException {
        MutableObjectClass oc = new MutableObjectClass(ApacheDsSchemaConnector.getOid(sr));
        oc.setNames(ApacheDsSchemaConnector.getNames(sr));
        oc.setDescription(ApacheDsSchemaConnector.getDescription(sr));
        oc.setObsolete(ApacheDsSchemaConnector.isObsolete(sr));
        oc.setSuperiorOids(ApacheDsSchemaConnector.getSuperiors(sr));
        oc.setType(ApacheDsSchemaConnector.getType(sr));
        oc.setMayAttributeTypeOids(ApacheDsSchemaConnector.getMay(sr));
        oc.setMustAttributeTypeOids(ApacheDsSchemaConnector.getMust(sr));
        return oc;
    }

    private static MatchingRule createMatchingRule(SearchResult sr) throws NamingException {
        MutableMatchingRule mr = new MutableMatchingRule(ApacheDsSchemaConnector.getOid(sr));
        mr.setNames(ApacheDsSchemaConnector.getNames(sr));
        mr.setDescription(ApacheDsSchemaConnector.getDescription(sr));
        mr.setObsolete(ApacheDsSchemaConnector.isObsolete(sr));
        mr.setSyntaxOid(ApacheDsSchemaConnector.getSyntax(sr));
        return mr;
    }

    private static LdapSyntax createSyntax(SearchResult sr) throws NamingException {
        LdapSyntax syntax = new LdapSyntax(ApacheDsSchemaConnector.getOid(sr));
        syntax.setNames(ApacheDsSchemaConnector.getNames(sr));
        syntax.setDescription(ApacheDsSchemaConnector.getDescription(sr));
        syntax.setObsolete(ApacheDsSchemaConnector.isObsolete(sr));
        syntax.setHumanReadable(ApacheDsSchemaConnector.isHumanReadable(sr));
        return syntax;
    }

    private static String getOid(SearchResult sr) throws NamingException {
        Attribute at = sr.getAttributes().get("m-oid");
        if (at == null) {
            return null;
        }
        return (String)at.get();
    }

    private static String[] getNames(SearchResult sr) throws NamingException {
        ArrayList<String> names = new ArrayList<String>();
        Attribute at = sr.getAttributes().get("m-name");
        if (at != null) {
            NamingEnumeration<?> ne = at.getAll();
            while (ne.hasMore()) {
                names.add((String)ne.next());
            }
        }
        return names.toArray(new String[0]);
    }

    private static String getDescription(SearchResult sr) throws NamingException {
        Attribute at = sr.getAttributes().get("m-description");
        if (at == null) {
            return null;
        }
        return (String)at.get();
    }

    private static String getSuperior(SearchResult sr) throws NamingException {
        Attribute at = sr.getAttributes().get("m-supAttributeType");
        if (at == null) {
            return null;
        }
        return (String)at.get();
    }

    private static UsageEnum getUsage(SearchResult sr) throws NamingException {
        Attribute at = sr.getAttributes().get("m-usage");
        if (at == null) {
            return UsageEnum.USER_APPLICATIONS;
        }
        try {
            return Enum.valueOf(UsageEnum.class, (String)at.get());
        }
        catch (IllegalArgumentException e) {
            return UsageEnum.USER_APPLICATIONS;
        }
        catch (NullPointerException e) {
            return UsageEnum.USER_APPLICATIONS;
        }
    }

    private static String getSyntax(SearchResult sr) throws NamingException {
        Attribute at = sr.getAttributes().get("m-syntax");
        if (at == null) {
            return null;
        }
        return (String)at.get();
    }

    private static int getSyntaxLength(SearchResult sr) throws NamingException {
        Attribute at = sr.getAttributes().get("m-length");
        if (at == null) {
            return -1;
        }
        try {
            return Integer.parseInt((String)at.get());
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private static boolean isObsolete(SearchResult sr) throws NamingException {
        Attribute at = sr.getAttributes().get("m-obsolete");
        if (at == null) {
            return false;
        }
        return Boolean.parseBoolean((String)at.get());
    }

    private static boolean isCollective(SearchResult sr) throws NamingException {
        Attribute at = sr.getAttributes().get("m-collective");
        if (at == null) {
            return false;
        }
        return Boolean.parseBoolean((String)at.get());
    }

    private static boolean isSingleValued(SearchResult sr) throws NamingException {
        Attribute at = sr.getAttributes().get("m-singleValue");
        if (at == null) {
            return false;
        }
        return Boolean.parseBoolean((String)at.get());
    }

    private static boolean isUserModifiable(SearchResult sr) throws NamingException {
        Attribute at = sr.getAttributes().get("m-noUserModification");
        if (at == null) {
            return true;
        }
        return !Boolean.parseBoolean((String)at.get());
    }

    private static String getEquality(SearchResult sr) throws NamingException {
        Attribute at = sr.getAttributes().get("m-equality");
        if (at == null) {
            return null;
        }
        return (String)at.get();
    }

    private static String getOrdering(SearchResult sr) throws NamingException {
        Attribute at = sr.getAttributes().get("m-ordering");
        if (at == null) {
            return null;
        }
        return (String)at.get();
    }

    private static String getSubstring(SearchResult sr) throws NamingException {
        Attribute at = sr.getAttributes().get("m-substr");
        if (at == null) {
            return null;
        }
        return (String)at.get();
    }

    private static List<String> getSuperiors(SearchResult sr) throws NamingException {
        ArrayList<String> names = new ArrayList<String>();
        Attribute at = sr.getAttributes().get("m-supObjectClass");
        if (at != null) {
            NamingEnumeration<?> ne = at.getAll();
            while (ne.hasMore()) {
                names.add((String)ne.next());
            }
        }
        return names;
    }

    private static ObjectClassTypeEnum getType(SearchResult sr) throws NamingException {
        Attribute at = sr.getAttributes().get("m-typeObjectClass");
        if (at == null) {
            return ObjectClassTypeEnum.STRUCTURAL;
        }
        try {
            return Enum.valueOf(ObjectClassTypeEnum.class, (String)at.get());
        }
        catch (IllegalArgumentException e) {
            return ObjectClassTypeEnum.STRUCTURAL;
        }
        catch (NullPointerException e) {
            return ObjectClassTypeEnum.STRUCTURAL;
        }
    }

    private static List<String> getMay(SearchResult sr) throws NamingException {
        ArrayList<String> names = new ArrayList<String>();
        Attribute at = sr.getAttributes().get("m-may");
        if (at != null) {
            NamingEnumeration<?> ne = at.getAll();
            while (ne.hasMore()) {
                names.add((String)ne.next());
            }
        }
        return names;
    }

    private static List<String> getMust(SearchResult sr) throws NamingException {
        ArrayList<String> names = new ArrayList<String>();
        Attribute at = sr.getAttributes().get("m-must");
        if (at != null) {
            NamingEnumeration<?> ne = at.getAll();
            while (ne.hasMore()) {
                names.add((String)ne.next());
            }
        }
        return names;
    }

    private static boolean isHumanReadable(SearchResult sr) throws NamingException {
        Attribute at = sr.getAttributes().get("x-not-human-readable");
        if (at == null) {
            return false;
        }
        return !Boolean.parseBoolean((String)at.get());
    }

    @Override
    public void exportSchema(Project project, StudioProgressMonitor monitor) throws SchemaConnectorException {
    }

    private static enum SchemaNodeTypes {
        ATTRIBUTE_TYPE,
        OBJECT_CLASS,
        MATCHING_RULE,
        SYNTAX,
        UNKNOWN;

    }
}

