/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.model.difference;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.api.ldap.model.schema.ObjectClassTypeEnum;
import org.apache.directory.api.ldap.model.schema.SchemaObject;
import org.apache.directory.api.ldap.model.schema.UsageEnum;
import org.apache.directory.api.util.Strings;
import org.apache.directory.studio.schemaeditor.model.Schema;
import org.apache.directory.studio.schemaeditor.model.difference.AliasDifference;
import org.apache.directory.studio.schemaeditor.model.difference.AttributeTypeDifference;
import org.apache.directory.studio.schemaeditor.model.difference.ClassTypeDifference;
import org.apache.directory.studio.schemaeditor.model.difference.CollectiveDifference;
import org.apache.directory.studio.schemaeditor.model.difference.DescriptionDifference;
import org.apache.directory.studio.schemaeditor.model.difference.DifferenceType;
import org.apache.directory.studio.schemaeditor.model.difference.EqualityDifference;
import org.apache.directory.studio.schemaeditor.model.difference.MandatoryATDifference;
import org.apache.directory.studio.schemaeditor.model.difference.NoUserModificationDifference;
import org.apache.directory.studio.schemaeditor.model.difference.ObjectClassDifference;
import org.apache.directory.studio.schemaeditor.model.difference.ObsoleteDifference;
import org.apache.directory.studio.schemaeditor.model.difference.OptionalATDifference;
import org.apache.directory.studio.schemaeditor.model.difference.OrderingDifference;
import org.apache.directory.studio.schemaeditor.model.difference.PropertyDifference;
import org.apache.directory.studio.schemaeditor.model.difference.SchemaDifference;
import org.apache.directory.studio.schemaeditor.model.difference.SingleValueDifference;
import org.apache.directory.studio.schemaeditor.model.difference.SubstringDifference;
import org.apache.directory.studio.schemaeditor.model.difference.SuperiorATDifference;
import org.apache.directory.studio.schemaeditor.model.difference.SuperiorOCDifference;
import org.apache.directory.studio.schemaeditor.model.difference.SyntaxDifference;
import org.apache.directory.studio.schemaeditor.model.difference.SyntaxLengthDifference;
import org.apache.directory.studio.schemaeditor.model.difference.UsageDifference;

public class DifferenceEngine {
    public static List<SchemaDifference> getDifferences(List<Schema> l1, List<Schema> l2) {
        SchemaDifference schemaDifference;
        ArrayList<SchemaDifference> differences = new ArrayList<SchemaDifference>();
        HashMap<String, Schema> mapL1 = new HashMap<String, Schema>();
        for (Schema schema : l1) {
            mapL1.put(Strings.toLowerCase((String)schema.getSchemaName()), schema);
        }
        HashMap<String, Schema> mapL2 = new HashMap<String, Schema>();
        for (Schema schema : l2) {
            mapL2.put(Strings.toLowerCase((String)schema.getSchemaName()), schema);
        }
        for (Schema schemaFromL1 : l1) {
            ObjectClassDifference objectClassDifference;
            Schema schemaFromL2 = (Schema)((Object)mapL2.get(Strings.toLowerCase((String)schemaFromL1.getSchemaName())));
            if (schemaFromL2 == null) {
                schemaDifference = new SchemaDifference((Object)schemaFromL1, null, DifferenceType.REMOVED);
                differences.add(schemaDifference);
                for (AttributeType attributeType : schemaFromL1.getAttributeTypes()) {
                    schemaDifference.addAttributeTypeDifference(new AttributeTypeDifference(null, attributeType, DifferenceType.REMOVED));
                }
                for (ObjectClass objectClass : schemaFromL1.getObjectClasses()) {
                    schemaDifference.addObjectClassDifference(new ObjectClassDifference(null, objectClass, DifferenceType.REMOVED));
                }
                continue;
            }
            schemaDifference = new SchemaDifference((Object)schemaFromL1, (Object)schemaFromL2, DifferenceType.IDENTICAL);
            differences.add(schemaDifference);
            HashMap<String, AttributeType> atMapL1 = new HashMap<String, AttributeType>();
            for (AttributeType at : schemaFromL1.getAttributeTypes()) {
                atMapL1.put(at.getOid(), at);
            }
            HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>();
            for (AttributeType at : schemaFromL2.getAttributeTypes()) {
                hashMap.put(at.getOid(), at);
            }
            for (AttributeType atFromL1 : schemaFromL1.getAttributeTypes()) {
                AttributeType attributeType = (AttributeType)hashMap.get(atFromL1.getOid());
                if (attributeType == null) {
                    AttributeTypeDifference attributeTypeDifference = new AttributeTypeDifference(atFromL1, null, DifferenceType.REMOVED);
                    schemaDifference.addAttributeTypeDifference(attributeTypeDifference);
                    schemaDifference.setType(DifferenceType.MODIFIED);
                    continue;
                }
                AttributeTypeDifference attributeTypeDifference = new AttributeTypeDifference(atFromL1, attributeType, DifferenceType.IDENTICAL);
                schemaDifference.addAttributeTypeDifference(attributeTypeDifference);
                List<PropertyDifference> atDifferences = DifferenceEngine.getDifferences(atFromL1, attributeType);
                if (atDifferences.size() <= 0) continue;
                attributeTypeDifference.setType(DifferenceType.MODIFIED);
                attributeTypeDifference.addDifferences(atDifferences);
                schemaDifference.setType(DifferenceType.MODIFIED);
            }
            for (AttributeType atFromL2 : schemaFromL2.getAttributeTypes()) {
                AttributeType attributeType = (AttributeType)atMapL1.get(atFromL2.getOid());
                if (attributeType != null) continue;
                AttributeTypeDifference attributeTypeDifference = new AttributeTypeDifference(null, atFromL2, DifferenceType.ADDED);
                schemaDifference.addAttributeTypeDifference(attributeTypeDifference);
                schemaDifference.setType(DifferenceType.MODIFIED);
            }
            HashMap<String, ObjectClass> ocMapL1 = new HashMap<String, ObjectClass>();
            for (ObjectClass objectClass : schemaFromL1.getObjectClasses()) {
                ocMapL1.put(objectClass.getOid(), objectClass);
            }
            HashMap<String, ObjectClass> ocMapL2 = new HashMap<String, ObjectClass>();
            for (ObjectClass objectClass : schemaFromL2.getObjectClasses()) {
                ocMapL2.put(objectClass.getOid(), objectClass);
            }
            for (ObjectClass objectClass : schemaFromL1.getObjectClasses()) {
                ObjectClass ocFromL2 = (ObjectClass)ocMapL2.get(objectClass.getOid());
                if (ocFromL2 == null) {
                    objectClassDifference = new ObjectClassDifference(objectClass, null, DifferenceType.REMOVED);
                    schemaDifference.addObjectClassDifference(objectClassDifference);
                    schemaDifference.setType(DifferenceType.MODIFIED);
                    continue;
                }
                objectClassDifference = new ObjectClassDifference(objectClass, ocFromL2, DifferenceType.IDENTICAL);
                schemaDifference.addObjectClassDifference(objectClassDifference);
                List<PropertyDifference> ocDifferences = DifferenceEngine.getDifferences(objectClass, ocFromL2);
                if (ocDifferences.size() <= 0) continue;
                objectClassDifference.setType(DifferenceType.MODIFIED);
                objectClassDifference.addDifferences(ocDifferences);
                schemaDifference.setType(DifferenceType.MODIFIED);
            }
            for (ObjectClass objectClass : schemaFromL2.getObjectClasses()) {
                ObjectClass ocFromL1 = (ObjectClass)ocMapL1.get(objectClass.getOid());
                if (ocFromL1 != null) continue;
                objectClassDifference = new ObjectClassDifference(null, objectClass, DifferenceType.ADDED);
                schemaDifference.addObjectClassDifference(objectClassDifference);
                schemaDifference.setType(DifferenceType.MODIFIED);
            }
        }
        for (Schema schemaFromL2 : l2) {
            Schema schemaFromL1 = (Schema)((Object)mapL1.get(Strings.toLowerCase((String)schemaFromL2.getSchemaName())));
            if (schemaFromL1 != null) continue;
            schemaDifference = new SchemaDifference(null, (Object)schemaFromL2, DifferenceType.ADDED);
            differences.add(schemaDifference);
            for (AttributeType attributeType : schemaFromL2.getAttributeTypes()) {
                schemaDifference.addAttributeTypeDifference(new AttributeTypeDifference(null, attributeType, DifferenceType.ADDED));
            }
            for (ObjectClass objectClass : schemaFromL2.getObjectClasses()) {
                schemaDifference.addObjectClassDifference(new ObjectClassDifference(null, objectClass, DifferenceType.ADDED));
            }
        }
        return differences;
    }

    public static List<PropertyDifference> getDifferences(ObjectClass oc1, ObjectClass oc2) {
        PropertyDifference classTypeDifference;
        PropertyDifference obsoleteDifference;
        ArrayList<PropertyDifference> differences = new ArrayList<PropertyDifference>();
        differences.addAll(DifferenceEngine.getAliasesDifferences((SchemaObject)oc1, (SchemaObject)oc2));
        PropertyDifference descriptionDifference = DifferenceEngine.getDescriptionDifference((SchemaObject)oc1, (SchemaObject)oc2);
        if (descriptionDifference != null) {
            differences.add(descriptionDifference);
        }
        if ((obsoleteDifference = DifferenceEngine.getObsoleteDifference((SchemaObject)oc1, (SchemaObject)oc2)) != null) {
            differences.add(obsoleteDifference);
        }
        if ((classTypeDifference = DifferenceEngine.getClassTypeDifference(oc1, oc2)) != null) {
            differences.add(classTypeDifference);
        }
        differences.addAll(DifferenceEngine.getSuperiorClassesDifferences(oc1, oc2));
        differences.addAll(DifferenceEngine.getMandatoryAttributeTypesDifferences(oc1, oc2));
        differences.addAll(DifferenceEngine.getOptionalAttributeTypesDifferences(oc1, oc2));
        return differences;
    }

    public static List<PropertyDifference> getDifferences(AttributeType at1, AttributeType at2) {
        PropertyDifference substringDifference;
        PropertyDifference orderingDifference;
        PropertyDifference equalityDifference;
        PropertyDifference noUserModificationDifference;
        PropertyDifference collectiveDifference;
        PropertyDifference singleValueDifference;
        PropertyDifference syntaxLengthDifference;
        PropertyDifference syntaxDifference;
        PropertyDifference superiorDifference;
        PropertyDifference usageDifference;
        PropertyDifference obsoleteDifference;
        ArrayList<PropertyDifference> differences = new ArrayList<PropertyDifference>();
        differences.addAll(DifferenceEngine.getAliasesDifferences((SchemaObject)at1, (SchemaObject)at2));
        PropertyDifference descriptionDifference = DifferenceEngine.getDescriptionDifference((SchemaObject)at1, (SchemaObject)at2);
        if (descriptionDifference != null) {
            differences.add(descriptionDifference);
        }
        if ((obsoleteDifference = DifferenceEngine.getObsoleteDifference((SchemaObject)at1, (SchemaObject)at2)) != null) {
            differences.add(obsoleteDifference);
        }
        if ((usageDifference = DifferenceEngine.getUsageDifference(at1, at2)) != null) {
            differences.add(usageDifference);
        }
        if ((superiorDifference = DifferenceEngine.getSuperiorDifference(at1, at2)) != null) {
            differences.add(superiorDifference);
        }
        if ((syntaxDifference = DifferenceEngine.getSyntaxDifference(at1, at2)) != null) {
            differences.add(syntaxDifference);
        }
        if ((syntaxLengthDifference = DifferenceEngine.getSyntaxLengthDifference(at1, at2)) != null) {
            differences.add(syntaxLengthDifference);
        }
        if ((singleValueDifference = DifferenceEngine.getSingleValueDifference(at1, at2)) != null) {
            differences.add(singleValueDifference);
        }
        if ((collectiveDifference = DifferenceEngine.getCollectiveDifference(at1, at2)) != null) {
            differences.add(collectiveDifference);
        }
        if ((noUserModificationDifference = DifferenceEngine.getNoUserModificationDifference(at1, at2)) != null) {
            differences.add(noUserModificationDifference);
        }
        if ((equalityDifference = DifferenceEngine.getEqualityDifference(at1, at2)) != null) {
            differences.add(equalityDifference);
        }
        if ((orderingDifference = DifferenceEngine.getOrderingDifference(at1, at2)) != null) {
            differences.add(orderingDifference);
        }
        if ((substringDifference = DifferenceEngine.getSubstringDifference(at1, at2)) != null) {
            differences.add(substringDifference);
        }
        return differences;
    }

    private static List<PropertyDifference> getAliasesDifferences(SchemaObject so1, SchemaObject so2) {
        AliasDifference diff;
        ArrayList<PropertyDifference> differences = new ArrayList<PropertyDifference>();
        List so1Names = so1.getNames();
        List so2Names = so2.getNames();
        for (String name : so1Names) {
            if (so2Names.contains(name)) continue;
            diff = new AliasDifference(so1, so2, DifferenceType.REMOVED);
            diff.setOldValue(name);
            differences.add(diff);
        }
        for (String name : so2Names) {
            if (so1Names.contains(name)) continue;
            diff = new AliasDifference(so1, so2, DifferenceType.ADDED);
            diff.setNewValue(name);
            differences.add(diff);
        }
        return differences;
    }

    private static PropertyDifference getDescriptionDifference(SchemaObject so1, SchemaObject so2) {
        String so1Description = so1.getDescription();
        String so2Description = so2.getDescription();
        if (so1Description == null && so2Description != null) {
            DescriptionDifference diff = new DescriptionDifference(so1, so2, DifferenceType.ADDED);
            diff.setNewValue(so2Description);
            return diff;
        }
        if (so1Description != null && so2Description == null) {
            DescriptionDifference diff = new DescriptionDifference(so1, so2, DifferenceType.REMOVED);
            diff.setOldValue(so1Description);
            return diff;
        }
        if (so1Description != null && so2Description != null && !so1Description.equals(so2Description)) {
            DescriptionDifference diff = new DescriptionDifference(so1, so2, DifferenceType.MODIFIED);
            diff.setOldValue(so1Description);
            diff.setNewValue(so2Description);
            return diff;
        }
        return null;
    }

    private static PropertyDifference getObsoleteDifference(SchemaObject so1, SchemaObject so2) {
        boolean so2Obsolete;
        boolean so1Obsolete = so1.isObsolete();
        if (so1Obsolete != (so2Obsolete = so2.isObsolete())) {
            ObsoleteDifference diff = new ObsoleteDifference(so1, so2);
            diff.setOldValue(so1Obsolete);
            diff.setNewValue(so2Obsolete);
            return diff;
        }
        return null;
    }

    private static PropertyDifference getClassTypeDifference(ObjectClass oc1, ObjectClass oc2) {
        ObjectClassTypeEnum oc2ClassType;
        ObjectClassTypeEnum oc1ClassType = oc1.getType();
        if (oc1ClassType != (oc2ClassType = oc2.getType())) {
            ClassTypeDifference diff = new ClassTypeDifference(oc1, oc2);
            diff.setOldValue(oc1ClassType);
            diff.setNewValue(oc2ClassType);
            return diff;
        }
        return null;
    }

    private static List<PropertyDifference> getSuperiorClassesDifferences(ObjectClass oc1, ObjectClass oc2) {
        SuperiorOCDifference diff;
        ArrayList<PropertyDifference> differences = new ArrayList<PropertyDifference>();
        List oc1Sups = oc1.getSuperiorOids();
        List oc2Sups = oc2.getSuperiorOids();
        for (String name : oc1Sups) {
            if (oc2Sups.contains(name)) continue;
            diff = new SuperiorOCDifference(oc1, oc2, DifferenceType.REMOVED);
            diff.setOldValue(name);
            differences.add(diff);
        }
        for (String name : oc2Sups) {
            if (oc1Sups.contains(name)) continue;
            diff = new SuperiorOCDifference(oc1, oc2, DifferenceType.ADDED);
            diff.setNewValue(name);
            differences.add(diff);
        }
        return differences;
    }

    private static List<PropertyDifference> getMandatoryAttributeTypesDifferences(ObjectClass oc1, ObjectClass oc2) {
        MandatoryATDifference diff;
        ArrayList<PropertyDifference> differences = new ArrayList<PropertyDifference>();
        List oc1Musts = oc1.getMustAttributeTypeOids();
        List oc2Musts = oc2.getMustAttributeTypeOids();
        for (String name : oc1Musts) {
            if (oc2Musts.contains(name)) continue;
            diff = new MandatoryATDifference(oc1, oc2, DifferenceType.REMOVED);
            diff.setOldValue(name);
            differences.add(diff);
        }
        for (String name : oc2Musts) {
            if (oc1Musts.contains(name)) continue;
            diff = new MandatoryATDifference(oc1, oc2, DifferenceType.ADDED);
            diff.setNewValue(name);
            differences.add(diff);
        }
        return differences;
    }

    private static List<PropertyDifference> getOptionalAttributeTypesDifferences(ObjectClass oc1, ObjectClass oc2) {
        OptionalATDifference diff;
        ArrayList<PropertyDifference> differences = new ArrayList<PropertyDifference>();
        List oc1Mays = oc1.getMayAttributeTypeOids();
        List oc2Mays = oc2.getMayAttributeTypeOids();
        for (String name : oc1Mays) {
            if (oc2Mays.contains(name)) continue;
            diff = new OptionalATDifference(oc1, oc2, DifferenceType.REMOVED);
            diff.setOldValue(name);
            differences.add(diff);
        }
        for (String name : oc2Mays) {
            if (oc1Mays.contains(name)) continue;
            diff = new OptionalATDifference(oc1, oc2, DifferenceType.ADDED);
            diff.setNewValue(name);
            differences.add(diff);
        }
        return differences;
    }

    private static PropertyDifference getUsageDifference(AttributeType at1, AttributeType at2) {
        UsageEnum at2Usage;
        UsageEnum at1Usage = at1.getUsage();
        if (at1Usage != (at2Usage = at2.getUsage())) {
            UsageDifference diff = new UsageDifference(at1, at2);
            diff.setOldValue(at1Usage);
            diff.setNewValue(at2Usage);
            return diff;
        }
        return null;
    }

    private static PropertyDifference getSuperiorDifference(AttributeType at1, AttributeType at2) {
        String at1Superior = at1.getSuperiorOid();
        String at2Superior = at2.getSuperiorOid();
        if (at1Superior == null && at2Superior != null) {
            SuperiorATDifference diff = new SuperiorATDifference(at1, at2, DifferenceType.ADDED);
            diff.setNewValue(at2Superior);
            return diff;
        }
        if (at1Superior != null && at2Superior == null) {
            SuperiorATDifference diff = new SuperiorATDifference(at1, at2, DifferenceType.REMOVED);
            diff.setOldValue(at1Superior);
            return diff;
        }
        if (at1Superior != null && at2Superior != null && !at1Superior.equals(at2Superior)) {
            SuperiorATDifference diff = new SuperiorATDifference(at1, at2, DifferenceType.MODIFIED);
            diff.setOldValue(at1Superior);
            diff.setNewValue(at2Superior);
            return diff;
        }
        return null;
    }

    private static PropertyDifference getSyntaxDifference(AttributeType at1, AttributeType at2) {
        String at1Syntax = at1.getSyntaxOid();
        String at2Syntax = at2.getSyntaxOid();
        if (at1Syntax == null && at2Syntax != null) {
            SyntaxDifference diff = new SyntaxDifference(at1, at2, DifferenceType.ADDED);
            diff.setNewValue(at2Syntax);
            return diff;
        }
        if (at1Syntax != null && at2Syntax == null) {
            SyntaxDifference diff = new SyntaxDifference(at1, at2, DifferenceType.REMOVED);
            diff.setOldValue(at1Syntax);
            return diff;
        }
        if (at1Syntax != null && at2Syntax != null && !at1Syntax.equals(at2Syntax)) {
            SyntaxDifference diff = new SyntaxDifference(at1, at2, DifferenceType.MODIFIED);
            diff.setOldValue(at1Syntax);
            diff.setNewValue(at2Syntax);
            return diff;
        }
        return null;
    }

    private static PropertyDifference getSyntaxLengthDifference(AttributeType at1, AttributeType at2) {
        long at1SyntaxLength = at1.getSyntaxLength();
        long at2SyntaxLength = at2.getSyntaxLength();
        if (at1SyntaxLength == 0L && at2SyntaxLength != 0L) {
            SyntaxLengthDifference diff = new SyntaxLengthDifference(at1, at2, DifferenceType.ADDED);
            diff.setNewValue(at2SyntaxLength);
            return diff;
        }
        if (at1SyntaxLength != 0L && at2SyntaxLength == 0L) {
            SyntaxLengthDifference diff = new SyntaxLengthDifference(at1, at2, DifferenceType.REMOVED);
            diff.setOldValue(at1SyntaxLength);
            return diff;
        }
        if (at1SyntaxLength != 0L && at2SyntaxLength != 0L && at1SyntaxLength != at2SyntaxLength) {
            SyntaxLengthDifference diff = new SyntaxLengthDifference(at1, at2, DifferenceType.MODIFIED);
            diff.setOldValue(at1SyntaxLength);
            diff.setNewValue(at2SyntaxLength);
            return diff;
        }
        return null;
    }

    private static PropertyDifference getSingleValueDifference(AttributeType at1, AttributeType at2) {
        boolean at2SingleValued;
        boolean at1SingleValued = at1.isSingleValued();
        if (at1SingleValued != (at2SingleValued = at2.isSingleValued())) {
            SingleValueDifference diff = new SingleValueDifference(at1, at2);
            diff.setOldValue(at1SingleValued);
            diff.setNewValue(at2SingleValued);
            return diff;
        }
        return null;
    }

    private static PropertyDifference getCollectiveDifference(AttributeType at1, AttributeType at2) {
        boolean at2Collective;
        boolean at1Collective = at1.isCollective();
        if (at1Collective != (at2Collective = at2.isCollective())) {
            CollectiveDifference diff = new CollectiveDifference(at1, at2);
            diff.setOldValue(at1Collective);
            diff.setNewValue(at2Collective);
            return diff;
        }
        return null;
    }

    private static PropertyDifference getNoUserModificationDifference(AttributeType at1, AttributeType at2) {
        boolean at2IsUserModifiable;
        boolean at1IsUserModifiable = at1.isUserModifiable();
        if (at1IsUserModifiable != (at2IsUserModifiable = at2.isUserModifiable())) {
            NoUserModificationDifference diff = new NoUserModificationDifference(at1, at2);
            diff.setOldValue(at1IsUserModifiable);
            diff.setNewValue(at2IsUserModifiable);
            return diff;
        }
        return null;
    }

    private static PropertyDifference getEqualityDifference(AttributeType at1, AttributeType at2) {
        String at1Equality = at1.getEqualityOid();
        String at2Equality = at2.getEqualityOid();
        if (at1Equality == null && at2Equality != null) {
            EqualityDifference diff = new EqualityDifference(at1, at2, DifferenceType.ADDED);
            diff.setNewValue(at2Equality);
            return diff;
        }
        if (at1Equality != null && at2Equality == null) {
            EqualityDifference diff = new EqualityDifference(at1, at2, DifferenceType.REMOVED);
            diff.setOldValue(at1Equality);
            return diff;
        }
        if (at1Equality != null && at2Equality != null && !at1Equality.equals(at2Equality)) {
            EqualityDifference diff = new EqualityDifference(at1, at2, DifferenceType.MODIFIED);
            diff.setOldValue(at1Equality);
            diff.setNewValue(at2Equality);
            return diff;
        }
        return null;
    }

    private static PropertyDifference getOrderingDifference(AttributeType at1, AttributeType at2) {
        String at1Ordering = at1.getOrderingOid();
        String at2Ordering = at2.getOrderingOid();
        if (at1Ordering == null && at2Ordering != null) {
            OrderingDifference diff = new OrderingDifference(at1, at2, DifferenceType.ADDED);
            diff.setNewValue(at2Ordering);
            return diff;
        }
        if (at1Ordering != null && at2Ordering == null) {
            OrderingDifference diff = new OrderingDifference(at1, at2, DifferenceType.REMOVED);
            diff.setOldValue(at1Ordering);
            return diff;
        }
        if (at1Ordering != null && at2Ordering != null && !at1Ordering.equals(at2Ordering)) {
            OrderingDifference diff = new OrderingDifference(at1, at2, DifferenceType.MODIFIED);
            diff.setOldValue(at1Ordering);
            diff.setNewValue(at2Ordering);
            return diff;
        }
        return null;
    }

    private static PropertyDifference getSubstringDifference(AttributeType at1, AttributeType at2) {
        String at1Substring = at1.getSubstringOid();
        String at2Substring = at2.getSubstringOid();
        if (at1Substring == null && at2Substring != null) {
            SubstringDifference diff = new SubstringDifference(at1, at2, DifferenceType.ADDED);
            diff.setNewValue(at2Substring);
            return diff;
        }
        if (at1Substring != null && at2Substring == null) {
            SubstringDifference diff = new SubstringDifference(at1, at2, DifferenceType.REMOVED);
            diff.setOldValue(at1Substring);
            return diff;
        }
        if (at1Substring != null && at2Substring != null && !at1Substring.equals(at2Substring)) {
            SubstringDifference diff = new SubstringDifference(at1, at2, DifferenceType.MODIFIED);
            diff.setOldValue(at1Substring);
            diff.setNewValue(at2Substring);
            return diff;
        }
        return null;
    }
}

