/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds.configuration.v2.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.message.AliasDerefMode;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.server.config.beans.ReplConsumerBean;
import org.apache.directory.studio.apacheds.configuration.v2.dialogs.AttributeDialog;
import org.apache.directory.studio.apacheds.configuration.v2.editor.ReplicationMasterDetailsBlock;
import org.apache.directory.studio.apacheds.configuration.v2.editor.ServerConfigurationEditorUtils;
import org.apache.directory.studio.ldapbrowser.common.widgets.WidgetModifyEvent;
import org.apache.directory.studio.ldapbrowser.common.widgets.WidgetModifyListener;
import org.apache.directory.studio.ldapbrowser.common.widgets.search.EntryWidget;
import org.apache.directory.studio.ldapbrowser.common.widgets.search.FilterWidget;
import org.apache.directory.studio.ldapbrowser.core.BrowserCorePlugin;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.schema.Schema;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class ReplicationDetailsPage
implements IDetailsPage {
    private ReplicationMasterDetailsBlock masterDetailsBlock;
    private IManagedForm mform;
    private ReplConsumerBean input;
    private IBrowserConnection browserConnection;
    private String[] attributeNamesAndOids;
    private List<String> attributesList = new ArrayList<String>();
    private Button enabledCheckbox;
    private Text idText;
    private Text descriptionText;
    private Button refreshAndPersistModeButton;
    private Button refreshOnlyModeButton;
    private Text refreshIntervalText;
    private Text remoteHostText;
    private Text remotePortText;
    private Text bindDnText;
    private Text bindPasswordText;
    private Button showPasswordCheckbox;
    private Button useStartTlsCheckbox;
    private Text sizeLimitText;
    private Text timeLimitText;
    private EntryWidget entryWidget;
    private FilterWidget filterWidget;
    private Button subtreeScopeButton;
    private Button oneLevelScopeButton;
    private Button objectScopeButton;
    private Button allAttributesCheckbox;
    private TableViewer attributesTableViewer;
    private Button addAttributeButton;
    private Button editAttributeButton;
    private Button deleteAttributeButton;
    private Button findingBaseDnAliasesDereferencingButton;
    private Button searchAliasesDereferencingButton;
    private ModifyListener textModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            ReplicationDetailsPage.this.commit(true);
            ReplicationDetailsPage.this.masterDetailsBlock.setEditorDirty();
        }
    };
    private SelectionListener buttonSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            ReplicationDetailsPage.this.commit(true);
            ReplicationDetailsPage.this.masterDetailsBlock.setEditorDirty();
        }
    };
    private WidgetModifyListener widgetModifyListener = new WidgetModifyListener(){

        public void widgetModified(WidgetModifyEvent event) {
            ReplicationDetailsPage.this.commit(true);
            ReplicationDetailsPage.this.masterDetailsBlock.setEditorDirty();
        }
    };
    private VerifyListener integerVerifyListener = new VerifyListener(){

        public void verifyText(VerifyEvent e) {
            if (!e.text.matches("[0-9]*")) {
                e.doit = false;
            }
        }
    };
    private SelectionListener showPasswordCheckboxSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            if (ReplicationDetailsPage.this.showPasswordCheckbox.getSelection()) {
                ReplicationDetailsPage.this.bindPasswordText.setEchoChar('\u0000');
            } else {
                ReplicationDetailsPage.this.bindPasswordText.setEchoChar('\u2022');
            }
        }
    };
    private ISelectionChangedListener attributesTableViewerSelectionListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            ReplicationDetailsPage.this.updateAttributesButtonsEnableState();
        }
    };
    private IDoubleClickListener attributesTableViewerDoubleClickListener = new IDoubleClickListener(){

        public void doubleClick(DoubleClickEvent event) {
            ReplicationDetailsPage.this.editSelectedAttribute();
        }
    };
    private SelectionListener addAttributeButtonSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            ReplicationDetailsPage.this.addNewAttribute();
        }
    };
    private SelectionListener editAttributeButtonSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            ReplicationDetailsPage.this.editSelectedAttribute();
        }
    };
    private SelectionListener deleteAttributeButtonSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            ReplicationDetailsPage.this.deleteSelectedAttribute();
        }
    };

    public ReplicationDetailsPage(ReplicationMasterDetailsBlock pmdb) {
        this.masterDetailsBlock = pmdb;
        this.browserConnection = BrowserCorePlugin.getDefault().getConnectionManager().getBrowserConnection(this.masterDetailsBlock.getPage().getConnection());
    }

    public void createContents(Composite parent) {
        FormToolkit toolkit = this.mform.getToolkit();
        TableWrapLayout layout = new TableWrapLayout();
        layout.topMargin = 5;
        layout.leftMargin = 5;
        layout.rightMargin = 2;
        layout.bottomMargin = 2;
        parent.setLayout((Layout)layout);
        this.createDetailsSection(parent, toolkit);
        this.createConnectionSection(parent, toolkit);
        this.createConfigurationSection(parent, toolkit);
    }

    private void createDetailsSection(Composite parent, FormToolkit toolkit) {
        Section section = toolkit.createSection(parent, 384);
        section.marginWidth = 10;
        section.setText("Replication Consumer Details");
        section.setDescription("Set the properties of the replication consumer.");
        TableWrapData td = new TableWrapData(128, 16);
        td.grabHorizontal = true;
        section.setLayoutData((Object)td);
        Composite client = toolkit.createComposite((Composite)section);
        toolkit.paintBordersFor(client);
        GridLayout glayout = new GridLayout(2, false);
        client.setLayout((Layout)glayout);
        section.setClient((Control)client);
        this.enabledCheckbox = toolkit.createButton(client, "Enabled", 32);
        this.enabledCheckbox.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        toolkit.createLabel(client, "ID:");
        this.idText = toolkit.createText(client, "");
        this.idText.setLayoutData((Object)new GridData(4, 0, true, false));
        toolkit.createLabel(client, "Description:");
        this.descriptionText = toolkit.createText(client, "");
        this.descriptionText.setLayoutData((Object)new GridData(4, 0, true, false));
    }

    private void createConnectionSection(Composite parent, FormToolkit toolkit) {
        Section section = toolkit.createSection(parent, 384);
        section.marginWidth = 10;
        section.setText("Connection");
        section.setDescription("Set the properties of the connection.");
        TableWrapData td = new TableWrapData(128, 16);
        td.grabHorizontal = true;
        section.setLayoutData((Object)td);
        Composite composite = toolkit.createComposite((Composite)section);
        toolkit.paintBordersFor(composite);
        composite.setLayout((Layout)new GridLayout(2, false));
        section.setClient((Control)composite);
        toolkit.createLabel(composite, "Replication Mode:");
        this.refreshAndPersistModeButton = toolkit.createButton(composite, "Refresh And Persist", 16);
        this.refreshAndPersistModeButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        toolkit.createLabel(composite, "");
        this.refreshOnlyModeButton = toolkit.createButton(composite, "Refresh Only", 16);
        this.refreshOnlyModeButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        toolkit.createLabel(composite, "");
        Composite refreshIntervalComposite = toolkit.createComposite(composite);
        refreshIntervalComposite.setLayoutData((Object)new GridData(4, 0, true, false));
        refreshIntervalComposite.setLayout((Layout)new GridLayout(3, false));
        toolkit.createLabel(refreshIntervalComposite, "  ");
        toolkit.createLabel(refreshIntervalComposite, "Refresh Interval (ms):");
        this.refreshIntervalText = toolkit.createText(refreshIntervalComposite, "");
        this.refreshIntervalText.setLayoutData((Object)new GridData(4, 0, true, false));
        toolkit.createLabel(composite, "Remote Host:");
        this.remoteHostText = toolkit.createText(composite, "");
        this.remoteHostText.setLayoutData((Object)new GridData(4, 0, true, false));
        toolkit.createLabel(composite, "Remote Port:");
        this.remotePortText = toolkit.createText(composite, "");
        this.remotePortText.addVerifyListener(this.integerVerifyListener);
        this.remotePortText.setLayoutData((Object)new GridData(4, 0, true, false));
        toolkit.createLabel(composite, "Bind DN:");
        this.bindDnText = toolkit.createText(composite, "");
        this.bindDnText.setLayoutData((Object)new GridData(4, 0, true, false));
        toolkit.createLabel(composite, "Bind Password:");
        this.bindPasswordText = toolkit.createText(composite, "");
        this.bindPasswordText.setEchoChar('\u2022');
        this.bindPasswordText.setLayoutData((Object)new GridData(4, 0, true, false));
        toolkit.createLabel(composite, "");
        this.showPasswordCheckbox = toolkit.createButton(composite, "Show password", 32);
        this.showPasswordCheckbox.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.showPasswordCheckbox.setSelection(false);
        toolkit.createLabel(composite, "Size Limit:");
        this.sizeLimitText = toolkit.createText(composite, "");
        this.sizeLimitText.addVerifyListener(this.integerVerifyListener);
        this.sizeLimitText.setLayoutData((Object)new GridData(4, 0, true, false));
        toolkit.createLabel(composite, "Time Limit:");
        this.timeLimitText = toolkit.createText(composite, "");
        this.timeLimitText.addVerifyListener(this.integerVerifyListener);
        this.timeLimitText.setLayoutData((Object)new GridData(4, 0, true, false));
        toolkit.createLabel(composite, "");
        this.useStartTlsCheckbox = toolkit.createButton(composite, "Use Start TLS", 32);
        this.useStartTlsCheckbox.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.useStartTlsCheckbox.setSelection(false);
    }

    private void createConfigurationSection(Composite parent, FormToolkit toolkit) {
        Section section = toolkit.createSection(parent, 384);
        section.marginWidth = 10;
        section.setText("Replication Consumer Details");
        section.setDescription("Set the properties of the configuration.");
        TableWrapData td = new TableWrapData(128, 16);
        td.grabHorizontal = true;
        section.setLayoutData((Object)td);
        Composite composite = toolkit.createComposite((Composite)section);
        toolkit.paintBordersFor(composite);
        GridLayout glayout = new GridLayout(3, false);
        composite.setLayout((Layout)glayout);
        section.setClient((Control)composite);
        toolkit.createLabel(composite, "Base DN:");
        this.entryWidget = new EntryWidget(this.browserConnection, Dn.EMPTY_DN);
        this.entryWidget.createWidget(composite);
        toolkit.createLabel(composite, "Filter:");
        this.filterWidget = new FilterWidget();
        this.filterWidget.setBrowserConnection(this.browserConnection);
        this.filterWidget.createWidget(composite);
        Label scopeLabel = toolkit.createLabel(composite, "Scope:");
        scopeLabel.setLayoutData((Object)new GridData(1, 128, false, false, 1, 3));
        this.subtreeScopeButton = toolkit.createButton(composite, "Subtree", 16);
        this.subtreeScopeButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.oneLevelScopeButton = toolkit.createButton(composite, "One Level", 16);
        this.oneLevelScopeButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.objectScopeButton = toolkit.createButton(composite, "Object", 16);
        this.objectScopeButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        Label attributesLabel = toolkit.createLabel(composite, "Attributes:");
        attributesLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.allAttributesCheckbox = toolkit.createButton(composite, "All Attributes", 32);
        this.allAttributesCheckbox.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        toolkit.createLabel(composite, "");
        Composite attributesTableComposite = toolkit.createComposite(composite);
        GridLayout gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        attributesTableComposite.setLayout((Layout)gl);
        attributesTableComposite.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        Table attributesTable = toolkit.createTable(attributesTableComposite, 2048);
        attributesTable.setLayoutData((Object)new GridData(4, 4, true, true, 1, 3));
        this.attributesTableViewer = new TableViewer(attributesTable);
        this.attributesTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.attributesTableViewer.setInput(this.attributesList);
        this.addAttributeButton = toolkit.createButton(attributesTableComposite, "Add...", 8);
        this.addAttributeButton.setLayoutData((Object)this.createNewButtonGridData());
        this.editAttributeButton = toolkit.createButton(attributesTableComposite, "Edit...", 8);
        this.editAttributeButton.setEnabled(false);
        this.editAttributeButton.setLayoutData((Object)this.createNewButtonGridData());
        this.deleteAttributeButton = toolkit.createButton(attributesTableComposite, "Delete", 8);
        this.deleteAttributeButton.setEnabled(false);
        this.deleteAttributeButton.setLayoutData((Object)this.createNewButtonGridData());
        Label aliasesDereferencingLable = toolkit.createLabel(composite, "Aliases\nDereferencing:");
        aliasesDereferencingLable.setLayoutData((Object)new GridData(1, 128, false, false, 1, 2));
        this.findingBaseDnAliasesDereferencingButton = toolkit.createButton(composite, "Finding Base DN", 32);
        this.findingBaseDnAliasesDereferencingButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.searchAliasesDereferencingButton = toolkit.createButton(composite, "Search", 32);
        this.searchAliasesDereferencingButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
    }

    private void updateAttributesButtonsEnableState() {
        ISelection selection = this.attributesTableViewer.getSelection();
        this.editAttributeButton.setEnabled(!selection.isEmpty());
        this.deleteAttributeButton.setEnabled(!selection.isEmpty());
    }

    private void addNewAttribute() {
        AttributeDialog dialog = new AttributeDialog(this.addAttributeButton.getShell(), null, this.getAttributeNamesAndOids());
        if (0 == dialog.open()) {
            String newAttribute = dialog.getAttribute();
            if (!this.attributesList.contains(newAttribute)) {
                this.attributesList.add(newAttribute);
            }
            this.attributesTableViewer.refresh();
            this.attributesTableViewer.setSelection((ISelection)new StructuredSelection((Object)newAttribute));
            this.masterDetailsBlock.setEditorDirty();
        }
    }

    private void editSelectedAttribute() {
        StructuredSelection selection = (StructuredSelection)this.attributesTableViewer.getSelection();
        if (!selection.isEmpty()) {
            String attribute = (String)selection.getFirstElement();
            AttributeDialog dialog = new AttributeDialog(this.addAttributeButton.getShell(), attribute, this.getAttributeNamesAndOids());
            if (0 == dialog.open()) {
                this.attributesList.remove(attribute);
                String newAttribute = dialog.getAttribute();
                if (!this.attributesList.contains(newAttribute)) {
                    this.attributesList.add(newAttribute);
                }
                this.attributesTableViewer.refresh();
                this.attributesTableViewer.setSelection((ISelection)new StructuredSelection((Object)newAttribute));
                this.masterDetailsBlock.setEditorDirty();
            }
        }
    }

    private void deleteSelectedAttribute() {
        StructuredSelection selection = (StructuredSelection)this.attributesTableViewer.getSelection();
        if (!selection.isEmpty()) {
            String attribute = (String)selection.getFirstElement();
            this.attributesList.remove(attribute);
            this.attributesTableViewer.refresh();
            this.masterDetailsBlock.setEditorDirty();
        }
    }

    private String[] getAttributeNamesAndOids() {
        if (this.attributeNamesAndOids == null || this.attributeNamesAndOids.length == 0) {
            ArrayList<String> attributeNamesList = new ArrayList<String>();
            ArrayList<String> oidsList = new ArrayList<String>();
            if (this.browserConnection == null) {
                IBrowserConnection[] connections;
                for (IBrowserConnection connection : connections = BrowserCorePlugin.getDefault().getConnectionManager().getBrowserConnections()) {
                    this.addAttributeNamesAndOids(connection.getSchema(), attributeNamesList, oidsList);
                }
            } else {
                this.addAttributeNamesAndOids(this.browserConnection.getSchema(), attributeNamesList, oidsList);
            }
            this.addAttributeNamesAndOids(Schema.DEFAULT_SCHEMA, attributeNamesList, oidsList);
            Collections.sort(attributeNamesList);
            Collections.sort(oidsList);
            this.attributeNamesAndOids = new String[attributeNamesList.size() + oidsList.size()];
            System.arraycopy(attributeNamesList.toArray(), 0, this.attributeNamesAndOids, 0, attributeNamesList.size());
            System.arraycopy(oidsList.toArray(), 0, this.attributeNamesAndOids, attributeNamesList.size(), oidsList.size());
        }
        return this.attributeNamesAndOids;
    }

    private void addAttributeNamesAndOids(Schema schema, List<String> attributeNamesList, List<String> oidsList) {
        if (schema != null) {
            Collection atds = schema.getAttributeTypeDescriptions();
            for (AttributeType atd : atds) {
                if (!oidsList.contains(atd.getOid())) {
                    oidsList.add(atd.getOid());
                }
                for (String name : atd.getNames()) {
                    if (attributeNamesList.contains(name)) continue;
                    attributeNamesList.add(name);
                }
            }
        }
    }

    private GridData createNewButtonGridData() {
        GridData gd = new GridData(4, 1, false, false);
        gd.widthHint = 61;
        return gd;
    }

    private void addListeners() {
        this.enabledCheckbox.addSelectionListener(this.buttonSelectionListener);
        this.idText.addModifyListener(this.textModifyListener);
        this.descriptionText.addModifyListener(this.textModifyListener);
        this.refreshAndPersistModeButton.addSelectionListener(this.buttonSelectionListener);
        this.refreshOnlyModeButton.addSelectionListener(this.buttonSelectionListener);
        this.refreshIntervalText.addModifyListener(this.textModifyListener);
        this.remoteHostText.addModifyListener(this.textModifyListener);
        this.remotePortText.addModifyListener(this.textModifyListener);
        this.bindDnText.addModifyListener(this.textModifyListener);
        this.bindPasswordText.addModifyListener(this.textModifyListener);
        this.showPasswordCheckbox.addSelectionListener(this.showPasswordCheckboxSelectionListener);
        this.sizeLimitText.addModifyListener(this.textModifyListener);
        this.timeLimitText.addModifyListener(this.textModifyListener);
        this.useStartTlsCheckbox.addSelectionListener(this.buttonSelectionListener);
        this.entryWidget.addWidgetModifyListener(this.widgetModifyListener);
        this.filterWidget.addWidgetModifyListener(this.widgetModifyListener);
        this.subtreeScopeButton.addSelectionListener(this.buttonSelectionListener);
        this.oneLevelScopeButton.addSelectionListener(this.buttonSelectionListener);
        this.objectScopeButton.addSelectionListener(this.buttonSelectionListener);
        this.allAttributesCheckbox.addSelectionListener(this.buttonSelectionListener);
        this.attributesTableViewer.addDoubleClickListener(this.attributesTableViewerDoubleClickListener);
        this.attributesTableViewer.addSelectionChangedListener(this.attributesTableViewerSelectionListener);
        this.addAttributeButton.addSelectionListener(this.addAttributeButtonSelectionListener);
        this.editAttributeButton.addSelectionListener(this.editAttributeButtonSelectionListener);
        this.deleteAttributeButton.addSelectionListener(this.deleteAttributeButtonSelectionListener);
        this.findingBaseDnAliasesDereferencingButton.addSelectionListener(this.buttonSelectionListener);
        this.searchAliasesDereferencingButton.addSelectionListener(this.buttonSelectionListener);
    }

    private void removeListeners() {
        this.enabledCheckbox.removeSelectionListener(this.buttonSelectionListener);
        this.idText.removeModifyListener(this.textModifyListener);
        this.descriptionText.removeModifyListener(this.textModifyListener);
        this.refreshAndPersistModeButton.removeSelectionListener(this.buttonSelectionListener);
        this.refreshOnlyModeButton.removeSelectionListener(this.buttonSelectionListener);
        this.refreshIntervalText.removeModifyListener(this.textModifyListener);
        this.remoteHostText.removeModifyListener(this.textModifyListener);
        this.remotePortText.removeModifyListener(this.textModifyListener);
        this.bindDnText.removeModifyListener(this.textModifyListener);
        this.bindPasswordText.removeModifyListener(this.textModifyListener);
        this.showPasswordCheckbox.removeSelectionListener(this.showPasswordCheckboxSelectionListener);
        this.sizeLimitText.removeModifyListener(this.textModifyListener);
        this.timeLimitText.removeModifyListener(this.textModifyListener);
        this.useStartTlsCheckbox.removeSelectionListener(this.buttonSelectionListener);
        this.entryWidget.removeWidgetModifyListener(this.widgetModifyListener);
        this.filterWidget.removeWidgetModifyListener(this.widgetModifyListener);
        this.subtreeScopeButton.removeSelectionListener(this.buttonSelectionListener);
        this.oneLevelScopeButton.removeSelectionListener(this.buttonSelectionListener);
        this.objectScopeButton.removeSelectionListener(this.buttonSelectionListener);
        this.allAttributesCheckbox.removeSelectionListener(this.buttonSelectionListener);
        this.attributesTableViewer.removeDoubleClickListener(this.attributesTableViewerDoubleClickListener);
        this.attributesTableViewer.removeSelectionChangedListener(this.attributesTableViewerSelectionListener);
        this.addAttributeButton.removeSelectionListener(this.addAttributeButtonSelectionListener);
        this.editAttributeButton.removeSelectionListener(this.editAttributeButtonSelectionListener);
        this.deleteAttributeButton.removeSelectionListener(this.deleteAttributeButtonSelectionListener);
        this.findingBaseDnAliasesDereferencingButton.removeSelectionListener(this.buttonSelectionListener);
        this.searchAliasesDereferencingButton.removeSelectionListener(this.buttonSelectionListener);
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        IStructuredSelection ssel = (IStructuredSelection)selection;
        this.input = ssel.size() == 1 ? (ReplConsumerBean)ssel.getFirstElement() : null;
        this.refresh();
    }

    public void commit(boolean onSave) {
        if (this.input != null) {
            this.input.setEnabled(this.enabledCheckbox.getSelection());
            this.input.setReplConsumerId(ServerConfigurationEditorUtils.checkEmptyString(this.idText.getText()));
            this.input.setDescription(ServerConfigurationEditorUtils.checkEmptyString(this.descriptionText.getText()));
            this.input.setReplRefreshNPersist(this.refreshAndPersistModeButton.getSelection());
            try {
                this.input.setReplRefreshInterval(Long.parseLong(this.refreshIntervalText.getText()));
            }
            catch (NumberFormatException e) {
                this.input.setReplRefreshInterval(60000L);
            }
            this.input.setReplProvHostName(ServerConfigurationEditorUtils.checkEmptyString(this.remoteHostText.getText()));
            try {
                this.input.setReplProvPort(Integer.parseInt(this.remotePortText.getText()));
            }
            catch (NumberFormatException e) {
                this.input.setReplProvPort(0);
            }
            this.input.setReplUserDn(ServerConfigurationEditorUtils.checkEmptyString(this.bindDnText.getText()));
            String password = ServerConfigurationEditorUtils.checkEmptyString(this.bindPasswordText.getText());
            if (password != null) {
                this.input.setReplUserPassword(password.getBytes());
            } else {
                this.input.setReplUserPassword(null);
            }
            try {
                this.input.setReplSearchSizeLimit(Integer.parseInt(this.sizeLimitText.getText()));
            }
            catch (NumberFormatException e) {
                this.input.setReplSearchSizeLimit(0);
            }
            try {
                this.input.setReplSearchTimeout(Integer.parseInt(this.timeLimitText.getText()));
            }
            catch (NumberFormatException e) {
                this.input.setReplSearchTimeout(0);
            }
            this.input.setReplUseTls(this.useStartTlsCheckbox.getSelection());
            Dn baseDn = this.entryWidget.getDn();
            if (baseDn != null) {
                this.input.setSearchBaseDn(ServerConfigurationEditorUtils.checkEmptyString(baseDn.toString()));
            } else {
                this.input.setSearchBaseDn(null);
            }
            this.input.setReplSearchFilter(ServerConfigurationEditorUtils.checkEmptyString(this.filterWidget.getFilter()));
            SearchScope scope = this.getSearchScope();
            if (scope != null) {
                this.input.setReplSearchScope(scope.getLdapUrlValue());
            } else {
                this.input.setReplSearchScope(null);
            }
            this.input.setReplAliasDerefMode(this.getAliasDerefMode().getJndiValue());
            ArrayList<String> replAttributes = new ArrayList<String>();
            replAttributes.addAll(this.attributesList);
            if (this.allAttributesCheckbox.getSelection()) {
                replAttributes.add("*");
            }
            this.input.setReplAttributes(replAttributes);
        }
    }

    private SearchScope getSearchScope() {
        if (this.subtreeScopeButton.getSelection()) {
            return SearchScope.SUBTREE;
        }
        if (this.oneLevelScopeButton.getSelection()) {
            return SearchScope.ONELEVEL;
        }
        if (this.objectScopeButton.getSelection()) {
            return SearchScope.OBJECT;
        }
        return null;
    }

    private AliasDerefMode getAliasDerefMode() {
        if (this.findingBaseDnAliasesDereferencingButton.getSelection() && this.searchAliasesDereferencingButton.getSelection()) {
            return AliasDerefMode.DEREF_ALWAYS;
        }
        if (!this.findingBaseDnAliasesDereferencingButton.getSelection() && this.searchAliasesDereferencingButton.getSelection()) {
            return AliasDerefMode.DEREF_IN_SEARCHING;
        }
        if (this.findingBaseDnAliasesDereferencingButton.getSelection() && !this.searchAliasesDereferencingButton.getSelection()) {
            return AliasDerefMode.DEREF_FINDING_BASE_OBJ;
        }
        if (!this.findingBaseDnAliasesDereferencingButton.getSelection() && !this.searchAliasesDereferencingButton.getSelection()) {
            return AliasDerefMode.NEVER_DEREF_ALIASES;
        }
        return AliasDerefMode.NEVER_DEREF_ALIASES;
    }

    public void dispose() {
    }

    public void initialize(IManagedForm form) {
        this.mform = form;
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isStale() {
        return false;
    }

    public void refresh() {
        this.removeListeners();
        if (this.input != null) {
            this.enabledCheckbox.setSelection(this.input.isEnabled());
            this.idText.setText(ServerConfigurationEditorUtils.checkNull(this.input.getReplConsumerId()));
            this.descriptionText.setText(ServerConfigurationEditorUtils.checkNull(this.input.getDescription()));
            this.refreshAndPersistModeButton.setSelection(this.input.isReplRefreshNPersist());
            this.refreshOnlyModeButton.setSelection(!this.input.isReplRefreshNPersist());
            this.refreshIntervalText.setText(ServerConfigurationEditorUtils.checkNull(String.valueOf(this.input.getReplRefreshInterval())));
            this.remoteHostText.setText(ServerConfigurationEditorUtils.checkNull(this.input.getReplProvHostName()));
            this.remotePortText.setText(ServerConfigurationEditorUtils.checkNull(String.valueOf(this.input.getReplProvPort())));
            this.bindDnText.setText(ServerConfigurationEditorUtils.checkNull(this.input.getReplUserDn()));
            byte[] bindPassword = this.input.getReplUserPassword();
            if (bindPassword != null && bindPassword.length > 0) {
                this.bindPasswordText.setText(ServerConfigurationEditorUtils.checkNull(new String(this.input.getReplUserPassword())));
            } else {
                this.bindPasswordText.setText("");
            }
            this.sizeLimitText.setText(ServerConfigurationEditorUtils.checkNull(String.valueOf(this.input.getReplSearchSizeLimit())));
            this.timeLimitText.setText(ServerConfigurationEditorUtils.checkNull(String.valueOf(this.input.getReplSearchTimeout())));
            this.useStartTlsCheckbox.setSelection(this.input.isReplUseTls());
            try {
                this.entryWidget.setInput(this.browserConnection, new Dn(new String[]{this.input.getSearchBaseDn()}));
            }
            catch (LdapInvalidDnException e) {
                this.entryWidget.setInput(this.browserConnection, Dn.EMPTY_DN);
            }
            this.filterWidget.setFilter(ServerConfigurationEditorUtils.checkNull(this.input.getReplSearchFilter()));
            SearchScope scope = null;
            try {
                scope = SearchScope.getSearchScope((int)SearchScope.getSearchScope((String)this.input.getReplSearchScope()));
            }
            catch (IllegalArgumentException e) {
                scope = null;
            }
            if (scope != null) {
                switch (scope) {
                    case SUBTREE: {
                        this.subtreeScopeButton.setSelection(true);
                        this.oneLevelScopeButton.setSelection(false);
                        this.objectScopeButton.setSelection(false);
                        break;
                    }
                    case ONELEVEL: {
                        this.subtreeScopeButton.setSelection(false);
                        this.oneLevelScopeButton.setSelection(true);
                        this.objectScopeButton.setSelection(false);
                        break;
                    }
                    case OBJECT: {
                        this.subtreeScopeButton.setSelection(false);
                        this.oneLevelScopeButton.setSelection(false);
                        this.objectScopeButton.setSelection(true);
                    }
                }
            } else {
                this.subtreeScopeButton.setSelection(true);
            }
            AliasDerefMode aliasDerefMode = null;
            try {
                aliasDerefMode = AliasDerefMode.getDerefMode((String)this.input.getReplAliasDerefMode());
            }
            catch (IllegalArgumentException e) {
                aliasDerefMode = null;
            }
            if (aliasDerefMode != null) {
                switch (aliasDerefMode) {
                    case DEREF_ALWAYS: {
                        this.findingBaseDnAliasesDereferencingButton.setSelection(true);
                        this.searchAliasesDereferencingButton.setSelection(true);
                        break;
                    }
                    case DEREF_FINDING_BASE_OBJ: {
                        this.findingBaseDnAliasesDereferencingButton.setSelection(true);
                        this.searchAliasesDereferencingButton.setSelection(false);
                        break;
                    }
                    case DEREF_IN_SEARCHING: {
                        this.findingBaseDnAliasesDereferencingButton.setSelection(false);
                        this.searchAliasesDereferencingButton.setSelection(true);
                        break;
                    }
                    case NEVER_DEREF_ALIASES: {
                        this.findingBaseDnAliasesDereferencingButton.setSelection(false);
                        this.searchAliasesDereferencingButton.setSelection(false);
                    }
                }
            } else {
                this.findingBaseDnAliasesDereferencingButton.setSelection(true);
                this.searchAliasesDereferencingButton.setSelection(true);
            }
            this.attributesList.clear();
            this.attributesList.addAll(this.input.getReplAttributes());
            if (this.attributesList.contains("*")) {
                this.attributesList.remove("*");
                this.allAttributesCheckbox.setSelection(true);
            } else {
                this.allAttributesCheckbox.setSelection(false);
            }
            if (this.attributesList.contains("+")) {
                this.attributesList.remove("+");
            }
            this.attributesTableViewer.refresh();
        }
        this.addListeners();
    }

    public void setFocus() {
        this.idText.setFocus();
    }

    public boolean setFormInput(Object input) {
        return false;
    }
}

