/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds.configuration.v2.editor;

import org.apache.directory.server.config.beans.PartitionBean;
import org.apache.directory.studio.apacheds.configuration.v2.ApacheDS2ConfigurationPlugin;
import org.apache.directory.studio.apacheds.configuration.v2.editor.Messages;
import org.apache.directory.studio.apacheds.configuration.v2.editor.PartitionsMasterDetailsBlock;
import org.apache.directory.studio.apacheds.configuration.v2.editor.ServerConfigurationEditor;
import org.apache.directory.studio.apacheds.configuration.v2.editor.ServerConfigurationEditorPage;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class PartitionsPage
extends ServerConfigurationEditorPage {
    public static final String ID = PartitionsPage.class.getName();
    private static final String TITLE = Messages.getString("PartitionsPage.Partitions");
    public static LabelProvider PARTITIONS_LABEL_PROVIDER = new LabelProvider(){

        public String getText(Object element) {
            if (element instanceof PartitionBean) {
                PartitionBean partition = (PartitionBean)element;
                return NLS.bind((String)"{0} ({1})", (Object)partition.getPartitionId(), (Object)partition.getPartitionSuffix());
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            if (element instanceof PartitionBean) {
                PartitionBean partition = (PartitionBean)element;
                if (PartitionsPage.isSystemPartition(partition)) {
                    return ApacheDS2ConfigurationPlugin.getDefault().getImage("resources/icons/partition_system.gif");
                }
                return ApacheDS2ConfigurationPlugin.getDefault().getImage("resources/icons/partition.gif");
            }
            return super.getImage(element);
        }
    };
    public static ViewerComparator PARTITIONS_COMPARATOR = new ViewerComparator(){

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof PartitionBean && e2 instanceof PartitionBean) {
                PartitionBean partition1 = (PartitionBean)e1;
                PartitionBean partition2 = (PartitionBean)e2;
                String partition1Id = partition1.getPartitionId();
                String partition2Id = partition2.getPartitionId();
                if (partition1Id != null && partition2Id != null) {
                    return partition1Id.compareTo(partition2Id);
                }
            }
            return super.compare(viewer, e1, e2);
        }
    };

    public PartitionsPage(ServerConfigurationEditor editor) {
        super(editor, ID, TITLE);
    }

    @Override
    protected void createFormContent(Composite parent, FormToolkit toolkit) {
        PartitionsMasterDetailsBlock masterDetailsBlock = new PartitionsMasterDetailsBlock(this);
        masterDetailsBlock.createContent(this.getManagedForm());
    }

    @Override
    protected void refreshUI() {
    }

    public static boolean isSystemPartition(PartitionBean partition) {
        return "system".equalsIgnoreCase(partition.getPartitionId());
    }
}

