/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.aciitemeditor.widgets;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.directory.api.ldap.aci.ProtectedItem;
import org.apache.directory.api.ldap.aci.UserClass;
import org.apache.directory.studio.aciitemeditor.ACIItemValueWithContext;
import org.apache.directory.studio.aciitemeditor.Activator;
import org.apache.directory.studio.aciitemeditor.dialogs.MultiValuedDialog;
import org.apache.directory.studio.aciitemeditor.model.UserClassWrapper;
import org.apache.directory.studio.aciitemeditor.model.UserClassWrapperFactory;
import org.apache.directory.studio.aciitemeditor.widgets.Messages;
import org.apache.directory.studio.valueeditors.AbstractDialogStringValueEditor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class ACIItemUserClassesComposite
extends Composite {
    private ACIItemValueWithContext context;
    private Composite composite = null;
    private Label label = null;
    private Table table = null;
    private CheckboxTableViewer tableViewer = null;
    private Composite buttonComposite = null;
    private Button editButton = null;
    private Button selectAllButton = null;
    private Button deselectAllButton = null;
    private Button reverseSelectionButton = null;
    private UserClassWrapper[] userClassWrappers = UserClassWrapperFactory.createUserClassWrappers();

    public ACIItemUserClassesComposite(Composite parent, int style) {
        super(parent, style);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        GridData layoutData = new GridData();
        layoutData.horizontalAlignment = 4;
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.verticalAlignment = 2;
        this.setLayoutData(layoutData);
        this.createComposite();
    }

    private void createComposite() {
        GridData labelGridData = new GridData();
        labelGridData.horizontalSpan = 2;
        labelGridData.verticalAlignment = 2;
        labelGridData.grabExcessHorizontalSpace = true;
        labelGridData.horizontalAlignment = 4;
        GridLayout gridLayout = new GridLayout();
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.numColumns = 2;
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalSpan = 1;
        gridData.verticalAlignment = 1;
        this.composite = new Composite((Composite)this, 0);
        this.composite.setLayoutData((Object)gridData);
        this.composite.setLayout((Layout)gridLayout);
        this.label = new Label(this.composite, 0);
        this.label.setText(Messages.getString("ACIItemUserClassesComposite.description"));
        this.label.setLayoutData((Object)labelGridData);
        this.createTable();
        this.createButtonComposite();
    }

    private void createTable() {
        GridData tableGridData = new GridData();
        tableGridData.grabExcessHorizontalSpace = true;
        tableGridData.verticalAlignment = 4;
        tableGridData.horizontalAlignment = 4;
        this.table = new Table(this.composite, 2080);
        this.table.setHeaderVisible(false);
        this.table.setLayoutData((Object)tableGridData);
        this.table.setLinesVisible(false);
        this.tableViewer = new CheckboxTableViewer(this.table);
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new UserClassesLabelProvider());
        this.tableViewer.setInput((Object)this.userClassWrappers);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ACIItemUserClassesComposite.this.userClassSelected();
            }
        });
        this.tableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ACIItemUserClassesComposite.this.userClassChecked();
            }
        });
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (ACIItemUserClassesComposite.this.editButton.isEnabled()) {
                    ACIItemUserClassesComposite.this.editUserClass();
                }
            }
        });
    }

    private void createButtonComposite() {
        GridData reverseSelectionButtonGridData = new GridData();
        reverseSelectionButtonGridData.horizontalAlignment = 4;
        reverseSelectionButtonGridData.grabExcessHorizontalSpace = false;
        reverseSelectionButtonGridData.verticalAlignment = 1;
        reverseSelectionButtonGridData.widthHint = Activator.getButtonWidth((Control)this);
        GridData deselectAllButtonGridData = new GridData();
        deselectAllButtonGridData.horizontalAlignment = 4;
        deselectAllButtonGridData.grabExcessHorizontalSpace = false;
        deselectAllButtonGridData.verticalAlignment = 1;
        deselectAllButtonGridData.widthHint = Activator.getButtonWidth((Control)this);
        GridData selectAllButtonGridData = new GridData();
        selectAllButtonGridData.horizontalAlignment = 4;
        selectAllButtonGridData.grabExcessHorizontalSpace = false;
        selectAllButtonGridData.verticalAlignment = 1;
        selectAllButtonGridData.widthHint = Activator.getButtonWidth((Control)this);
        GridData editButtonGridData = new GridData();
        editButtonGridData.horizontalAlignment = 4;
        editButtonGridData.grabExcessHorizontalSpace = false;
        editButtonGridData.verticalAlignment = 1;
        editButtonGridData.widthHint = Activator.getButtonWidth((Control)this);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 2;
        gridData.grabExcessHorizontalSpace = false;
        gridData.grabExcessVerticalSpace = false;
        gridData.verticalAlignment = 4;
        this.buttonComposite = new Composite(this.composite, 0);
        this.buttonComposite.setLayoutData((Object)gridData);
        this.buttonComposite.setLayout((Layout)gridLayout);
        this.editButton = new Button(this.buttonComposite, 0);
        this.editButton.setText(Messages.getString("ACIItemUserClassesComposite.edit.button"));
        this.editButton.setLayoutData((Object)editButtonGridData);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ACIItemUserClassesComposite.this.editUserClass();
            }
        });
        this.editButton.setEnabled(false);
        this.selectAllButton = new Button(this.buttonComposite, 0);
        this.selectAllButton.setText(Messages.getString("ACIItemUserClassesComposite.selectAll.button"));
        this.selectAllButton.setLayoutData((Object)selectAllButtonGridData);
        this.selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ACIItemUserClassesComposite.this.tableViewer.setCheckedElements((Object[])ACIItemUserClassesComposite.this.userClassWrappers);
                ACIItemUserClassesComposite.this.refreshTable();
            }
        });
        this.deselectAllButton = new Button(this.buttonComposite, 0);
        this.deselectAllButton.setText(Messages.getString("ACIItemUserClassesComposite.deselectAll.button"));
        this.deselectAllButton.setLayoutData((Object)deselectAllButtonGridData);
        this.deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ACIItemUserClassesComposite.this.tableViewer.setCheckedElements((Object[])new ProtectedItem[0]);
                ACIItemUserClassesComposite.this.refreshTable();
            }
        });
        this.reverseSelectionButton = new Button(this.buttonComposite, 0);
        this.reverseSelectionButton.setText(Messages.getString("ACIItemUserClassesComposite.revert.buton"));
        this.reverseSelectionButton.setLayoutData((Object)reverseSelectionButtonGridData);
        this.reverseSelectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArrayList<UserClassWrapper> elements = new ArrayList<UserClassWrapper>();
                elements.addAll(Arrays.asList(ACIItemUserClassesComposite.this.userClassWrappers));
                elements.removeAll(Arrays.asList(ACIItemUserClassesComposite.this.tableViewer.getCheckedElements()));
                ACIItemUserClassesComposite.this.tableViewer.setCheckedElements(elements.toArray());
                ACIItemUserClassesComposite.this.refreshTable();
            }
        });
    }

    public void setContext(ACIItemValueWithContext context) {
        this.context = context;
    }

    public void setUserClasses(Collection<UserClass> userClasses) {
        for (UserClassWrapper userClassWrapper : this.userClassWrappers) {
            this.tableViewer.setChecked((Object)userClassWrapper, false);
        }
        for (UserClass userClass : userClasses) {
            for (UserClassWrapper userClassWrapper : this.userClassWrappers) {
                if (userClassWrapper.getClazz() != userClass.getClass()) continue;
                userClassWrapper.setUserClass(userClass);
                this.tableViewer.setChecked((Object)userClassWrapper, true);
            }
        }
        this.refreshTable();
    }

    public Collection<UserClass> getUserClasses() throws ParseException {
        ArrayList<UserClass> userClasses = new ArrayList<UserClass>();
        for (UserClassWrapper userClassWrapper : this.userClassWrappers) {
            if (!this.tableViewer.getChecked((Object)userClassWrapper)) continue;
            UserClass userClass = userClassWrapper.getUserClass();
            userClasses.add(userClass);
        }
        return userClasses;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        ((GridData)this.getLayoutData()).heightHint = visible ? -1 : 0;
    }

    private UserClassWrapper getSelectedUserClassWrapper() {
        Object element;
        UserClassWrapper userClassWrapper = null;
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        if (!selection.isEmpty() && (element = selection.getFirstElement()) instanceof UserClassWrapper) {
            userClassWrapper = (UserClassWrapper)element;
        }
        return userClassWrapper;
    }

    private void userClassSelected() {
        UserClassWrapper userClassWrapper = this.getSelectedUserClassWrapper();
        if (userClassWrapper == null || !userClassWrapper.isEditable()) {
            this.editButton.setEnabled(false);
        } else {
            this.editButton.setEnabled(true);
        }
    }

    private void userClassChecked() {
        this.refreshTable();
    }

    private void editUserClass() {
        UserClassWrapper userClassWrapper = this.getSelectedUserClassWrapper();
        AbstractDialogStringValueEditor editor = userClassWrapper.getValueEditor();
        if (editor != null) {
            MultiValuedDialog dialog = new MultiValuedDialog(this.getShell(), userClassWrapper.getDisplayName(), userClassWrapper.getValues(), this.context, editor);
            dialog.open();
            this.refreshTable();
        }
    }

    private void refreshTable() {
        this.tableViewer.refresh();
    }

    private class UserClassesLabelProvider
    extends LabelProvider {
        private UserClassesLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof UserClassWrapper) {
                UserClassWrapper wrapper = (UserClassWrapper)element;
                if (ACIItemUserClassesComposite.this.tableViewer.getChecked((Object)wrapper)) {
                    try {
                        wrapper.getUserClass();
                    }
                    catch (ParseException e) {
                        return Activator.getDefault().getImage(Messages.getString("ACIItemUserClassesComposite.error.icon"));
                    }
                }
            }
            return null;
        }
    }
}

