/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.aciitemeditor.model;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.directory.api.ldap.aci.ACIItemParser;
import org.apache.directory.api.ldap.aci.ItemFirstACIItem;
import org.apache.directory.api.ldap.aci.ProtectedItem;
import org.apache.directory.api.ldap.aci.protectedItem.AllAttributeValuesItem;
import org.apache.directory.api.ldap.aci.protectedItem.AllUserAttributeTypesAndValuesItem;
import org.apache.directory.api.ldap.aci.protectedItem.AllUserAttributeTypesItem;
import org.apache.directory.api.ldap.aci.protectedItem.AttributeTypeItem;
import org.apache.directory.api.ldap.aci.protectedItem.AttributeValueItem;
import org.apache.directory.api.ldap.aci.protectedItem.ClassesItem;
import org.apache.directory.api.ldap.aci.protectedItem.EntryItem;
import org.apache.directory.api.ldap.aci.protectedItem.MaxImmSubItem;
import org.apache.directory.api.ldap.aci.protectedItem.MaxValueCountElem;
import org.apache.directory.api.ldap.aci.protectedItem.MaxValueCountItem;
import org.apache.directory.api.ldap.aci.protectedItem.RangeOfValuesItem;
import org.apache.directory.api.ldap.aci.protectedItem.RestrictedByElem;
import org.apache.directory.api.ldap.aci.protectedItem.RestrictedByItem;
import org.apache.directory.api.ldap.aci.protectedItem.SelfValueItem;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.studio.aciitemeditor.model.Messages;
import org.apache.directory.studio.valueeditors.AbstractDialogStringValueEditor;
import org.eclipse.osgi.util.NLS;

public class ProtectedItemWrapper {
    public static final Map<Class<? extends ProtectedItem>, String> classToIdentifierMap;
    public static final Map<Class<? extends ProtectedItem>, String> classToDisplayMap;
    private static final String DUMMY = "{ identificationTag \"id1\", precedence 1, authenticationLevel simple, itemOrUserFirst itemFirst: { protectedItems  { #identifier# #values# }, itemPermissions { { userClasses { allUsers }, grantsAndDenials { grantRead } } } } }";
    private final Class<? extends ProtectedItem> clazz;
    private List<String> values;
    private String valuePrefix;
    private String valueSuffix;
    private AbstractDialogStringValueEditor valueEditor;
    private boolean isMultivalued;

    public ProtectedItemWrapper(Class<? extends ProtectedItem> clazz, boolean isMultivalued, String valuePrefix, String valueSuffix, AbstractDialogStringValueEditor valueEditor) {
        this.clazz = clazz;
        this.isMultivalued = isMultivalued;
        this.valuePrefix = valuePrefix;
        this.valueSuffix = valueSuffix;
        this.valueEditor = valueEditor;
        this.values = new ArrayList<String>();
    }

    public ProtectedItem getProtectedItem() throws ParseException {
        String flatValue = this.getFlatValue();
        String spec = DUMMY;
        spec = spec.replaceAll("#identifier#", this.getIdentifier());
        spec = spec.replaceAll("#values#", flatValue);
        ACIItemParser parser = new ACIItemParser(null);
        ItemFirstACIItem aci = null;
        try {
            aci = (ItemFirstACIItem)parser.parse(spec);
        }
        catch (ParseException e) {
            String msg = NLS.bind((String)Messages.getString("ProtectedItemWrapper.error.message"), (Object[])new String[]{this.getIdentifier(), flatValue});
            throw new ParseException(msg, 0);
        }
        ProtectedItem item = (ProtectedItem)aci.getProtectedItems().iterator().next();
        return item;
    }

    public void setProtectedItem(ProtectedItem item) {
        assert (item.getClass() == this.getClazz());
        this.values.clear();
        if (item.getClass() == AttributeTypeItem.class) {
            AttributeTypeItem at = (AttributeTypeItem)item;
            for (AttributeType attributeType : at) {
                this.values.add(attributeType.getName());
            }
        } else if (item.getClass() == AllAttributeValuesItem.class) {
            AllAttributeValuesItem aav = (AllAttributeValuesItem)item;
            for (AttributeType attributeType : aav) {
                this.values.add(attributeType.toString());
            }
        } else if (item.getClass() == AttributeValueItem.class) {
            AttributeValueItem av = (AttributeValueItem)item;
            for (Attribute entryAttribute : av) {
                this.values.add(entryAttribute.getId() + "=" + entryAttribute.get());
            }
        } else if (item.getClass() == SelfValueItem.class) {
            SelfValueItem sv = (SelfValueItem)item;
            for (AttributeType attributeType : sv) {
                this.values.add(attributeType.toString());
            }
        } else if (item.getClass() == RangeOfValuesItem.class) {
            RangeOfValuesItem rov = (RangeOfValuesItem)item;
            this.values.add(rov.getRefinement().toString());
        } else if (item.getClass() == MaxValueCountItem.class) {
            MaxValueCountItem mvc = (MaxValueCountItem)item;
            for (MaxValueCountElem mvci : mvc) {
                this.values.add(mvci.toString());
            }
        } else if (item.getClass() == MaxImmSubItem.class) {
            MaxImmSubItem mis = (MaxImmSubItem)item;
            this.values.add(Integer.toString(mis.getValue()));
        } else if (item.getClass() == RestrictedByItem.class) {
            RestrictedByItem rb = (RestrictedByItem)item;
            for (RestrictedByElem rbe : rb) {
                this.values.add(rbe.toString());
            }
        } else if (item.getClass() == ClassesItem.class) {
            ClassesItem classes = (ClassesItem)item;
            StringBuilder sb = new StringBuilder();
            classes.getClasses().printRefinementToBuffer(sb);
            this.values.add(sb.toString());
        }
    }

    public String toString() {
        String flatValue = this.getFlatValue();
        if (flatValue.length() > 0) {
            flatValue = flatValue.replace('\r', ' ');
            flatValue = flatValue.replace('\n', ' ');
            flatValue = ": " + flatValue;
            if (flatValue.length() > 40) {
                String temp = flatValue;
                flatValue = temp.substring(0, 20);
                flatValue = flatValue + "...";
                flatValue = flatValue + temp.substring(temp.length() - 20, temp.length());
            }
        }
        return this.getDisplayName() + " " + flatValue;
    }

    private String getFlatValue() {
        if (this.valueEditor == null || this.values.isEmpty()) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        if (this.isMultivalued()) {
            sb.append("{ ");
        }
        Iterator<String> it = this.values.iterator();
        while (it.hasNext()) {
            sb.append(this.valuePrefix);
            String value = it.next();
            sb.append(value);
            sb.append(this.valueSuffix);
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        if (this.isMultivalued()) {
            sb.append(" }");
        }
        return sb.toString();
    }

    public List<String> getValues() {
        return this.values;
    }

    public String getDisplayName() {
        return classToDisplayMap.get(this.clazz);
    }

    public String getIdentifier() {
        return classToIdentifierMap.get(this.clazz);
    }

    public Class<? extends ProtectedItem> getClazz() {
        return this.clazz;
    }

    public boolean isEditable() {
        return this.valueEditor != null;
    }

    public AbstractDialogStringValueEditor getValueEditor() {
        return this.valueEditor;
    }

    public boolean isMultivalued() {
        return this.isMultivalued;
    }

    static {
        HashMap<Class, String> map = new HashMap<Class, String>();
        map.put(EntryItem.class, "entry");
        map.put(AllUserAttributeTypesItem.class, "allUserAttributeTypes");
        map.put(AttributeTypeItem.class, "attributeType");
        map.put(AllAttributeValuesItem.class, "allAttributeValues");
        map.put(AllUserAttributeTypesAndValuesItem.class, "allUserAttributeTypesAndValues");
        map.put(AttributeValueItem.class, "attributeValue");
        map.put(SelfValueItem.class, "selfValue");
        map.put(RangeOfValuesItem.class, "rangeOfValues");
        map.put(MaxValueCountItem.class, "maxValueCount");
        map.put(MaxImmSubItem.class, "maxImmSub");
        map.put(RestrictedByItem.class, "restrictedBy");
        map.put(ClassesItem.class, "classes");
        classToIdentifierMap = Collections.unmodifiableMap(map);
        map = new HashMap();
        map.put(EntryItem.class, Messages.getString("ProtectedItemWrapper.protectedItem.entry.label"));
        map.put(AllUserAttributeTypesItem.class, Messages.getString("ProtectedItemWrapper.protectedItem.allUserAttributeTypes.label"));
        map.put(AttributeTypeItem.class, Messages.getString("ProtectedItemWrapper.protectedItem.attributeType.label"));
        map.put(AllAttributeValuesItem.class, Messages.getString("ProtectedItemWrapper.protectedItem.allAttributeValues.label"));
        map.put(AllUserAttributeTypesAndValuesItem.class, Messages.getString("ProtectedItemWrapper.protectedItem.allUserAttributeTypesAndValues.label"));
        map.put(AttributeValueItem.class, Messages.getString("ProtectedItemWrapper.protectedItem.attributeValue.label"));
        map.put(SelfValueItem.class, Messages.getString("ProtectedItemWrapper.protectedItem.selfValue.label"));
        map.put(RangeOfValuesItem.class, Messages.getString("ProtectedItemWrapper.protectedItem.rangeOfValues.label"));
        map.put(MaxValueCountItem.class, Messages.getString("ProtectedItemWrapper.protectedItem.maxValueCount.label"));
        map.put(MaxImmSubItem.class, Messages.getString("ProtectedItemWrapper.protectedItem.maxImmSub.label"));
        map.put(RestrictedByItem.class, Messages.getString("ProtectedItemWrapper.protectedItem.restrictedBy.label"));
        map.put(ClassesItem.class, Messages.getString("ProtectedItemWrapper.protectedItem.classes.label"));
        classToDisplayMap = Collections.unmodifiableMap(map);
    }
}

