/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.widgets.search;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.directory.studio.common.ui.HistoryUtils;
import org.apache.directory.studio.common.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonActivator;
import org.apache.directory.studio.ldapbrowser.common.widgets.BrowserWidget;
import org.apache.directory.studio.ldapbrowser.common.widgets.DialogContentAssistant;
import org.apache.directory.studio.ldapbrowser.common.widgets.search.ReturningAttributesContentAssistProcessor;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.schema.SchemaUtils;
import org.apache.directory.studio.ldapbrowser.core.utils.Utils;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;

public class ReturningAttributesWidget
extends BrowserWidget {
    private Combo returningAttributesCombo;
    private ReturningAttributesContentAssistProcessor contentAssistProcessor;
    private IBrowserConnection browserConnection;
    private String[] initialReturningAttributes;

    public ReturningAttributesWidget(IBrowserConnection browserConnection, String[] initialReturningAttributes) {
        this.browserConnection = browserConnection;
        this.initialReturningAttributes = initialReturningAttributes;
    }

    public ReturningAttributesWidget() {
        this.browserConnection = null;
        this.initialReturningAttributes = null;
    }

    public void createWidget(Composite parent) {
        this.returningAttributesCombo = BaseWidgetUtils.createCombo((Composite)parent, (String[])new String[0], (int)-1, (int)1);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 1;
        gd.widthHint = 200;
        this.returningAttributesCombo.setLayoutData((Object)gd);
        this.contentAssistProcessor = new ReturningAttributesContentAssistProcessor(null);
        DialogContentAssistant raca = new DialogContentAssistant();
        raca.enableAutoInsert(true);
        raca.enableAutoActivation(true);
        raca.setAutoActivationDelay(500);
        raca.setContentAssistProcessor((IContentAssistProcessor)this.contentAssistProcessor, "__dftl_partition_content_type");
        raca.install(this.returningAttributesCombo);
        String[] history = HistoryUtils.load((IDialogSettings)BrowserCommonActivator.getDefault().getDialogSettings(), (String)"returningAttributesHistory");
        for (int i = 0; i < history.length; ++i) {
            history[i] = Utils.arrayToString((String[])ReturningAttributesWidget.stringToArray(history[i]));
        }
        this.returningAttributesCombo.setItems(history);
        this.returningAttributesCombo.setText(Utils.arrayToString((String[])this.initialReturningAttributes));
        this.returningAttributesCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ReturningAttributesWidget.this.notifyListeners();
            }
        });
        this.setBrowserConnection(this.browserConnection);
    }

    public void setBrowserConnection(IBrowserConnection browserConnection) {
        this.browserConnection = browserConnection;
        ArrayList<String> proposals = new ArrayList<String>();
        if (browserConnection != null) {
            proposals.addAll(SchemaUtils.getNames((Collection)browserConnection.getSchema().getAttributeTypeDescriptions()));
            Collection ocNames = SchemaUtils.getNames((Collection)browserConnection.getSchema().getObjectClassDescriptions());
            for (String ocName : ocNames) {
                proposals.add("@" + ocName);
            }
            proposals.add("+");
            proposals.add("*");
        }
        this.contentAssistProcessor.setProposals(proposals);
    }

    public void setInitialReturningAttributes(String[] initialReturningAttributes) {
        this.initialReturningAttributes = initialReturningAttributes;
        this.returningAttributesCombo.setText(Utils.arrayToString((String[])initialReturningAttributes));
    }

    public void setEnabled(boolean b) {
        this.returningAttributesCombo.setEnabled(b);
    }

    public String[] getReturningAttributes() {
        String s = this.returningAttributesCombo.getText();
        return ReturningAttributesWidget.stringToArray(s);
    }

    public void saveDialogSettings() {
        HistoryUtils.save((IDialogSettings)BrowserCommonActivator.getDefault().getDialogSettings(), (String)"returningAttributesHistory", (String)Utils.arrayToString((String[])this.getReturningAttributes()));
    }

    public void setFocus() {
        this.returningAttributesCombo.setFocus();
    }

    public static String[] stringToArray(String s) {
        if (s == null) {
            return null;
        }
        ArrayList<String> attributeList = new ArrayList<String>();
        StringBuffer temp = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '.' || c == ';' || c == '_' || c == '*' || c == '+' || c == '@') {
                temp.append(c);
                continue;
            }
            if (temp.length() <= 0) continue;
            attributeList.add(temp.toString());
            temp = new StringBuffer();
        }
        if (temp.length() > 0) {
            attributeList.add(temp.toString());
        }
        return attributeList.toArray(new String[attributeList.size()]);
    }
}

