/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor;

import org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor.EntryEditorWidgetTableMetadata;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.ldapbrowser.core.utils.CompoundModification;
import org.apache.directory.studio.valueeditors.ValueEditorManager;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.swt.widgets.Item;

public class EntryEditorWidgetCellModifier
implements ICellModifier {
    private ValueEditorManager valueEditorManager;

    public EntryEditorWidgetCellModifier(ValueEditorManager valueEditorManager) {
        this.valueEditorManager = valueEditorManager;
    }

    public void dispose() {
        this.valueEditorManager = null;
    }

    public boolean canModify(Object element, String property) {
        if (element != null && element instanceof IValue && this.valueEditorManager != null) {
            IValue attributeValue = (IValue)element;
            if (EntryEditorWidgetTableMetadata.KEY_COLUMN_NAME.equals(property)) {
                return false;
            }
            if (EntryEditorWidgetTableMetadata.VALUE_COLUMN_NAME.equals(property)) {
                return this.valueEditorManager.getCurrentValueEditor(attributeValue).getRawValue(attributeValue) != null;
            }
        }
        return false;
    }

    public Object getValue(Object element, String property) {
        if (element != null && element instanceof IValue && this.valueEditorManager != null) {
            IValue attributeValue = (IValue)element;
            Object returnValue = EntryEditorWidgetTableMetadata.KEY_COLUMN_NAME.equals(property) ? attributeValue.getAttribute().getDescription() : (EntryEditorWidgetTableMetadata.VALUE_COLUMN_NAME.equals(property) ? this.valueEditorManager.getCurrentValueEditor(attributeValue).getRawValue(attributeValue) : "");
            return returnValue;
        }
        return null;
    }

    public void modify(Object element, String property, Object newRawValue) {
        if (element != null && element instanceof Item) {
            element = ((Item)element).getData();
        }
        if (newRawValue != null && element != null && element instanceof IValue && this.valueEditorManager != null) {
            IValue oldValue = (IValue)element;
            if (EntryEditorWidgetTableMetadata.VALUE_COLUMN_NAME.equals(property)) {
                new CompoundModification().modifyValue(oldValue, newRawValue);
            }
        }
    }
}

