/***************************************************************************
 *   Copyright (C) 2009 by Emil Beli                                       *
 *   beli0135@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 3 of the License, or     *
 *   any later version.			                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   License at: http://www.gnu.org/licenses/gpl.html                      *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QtGui/QMainWindow>

namespace Ui
{
    class MainWindowClass;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:

    MainWindow(QWidget *parent = 0);
    ~MainWindow();
    void showError(QString text, QString info);
    QString fileTypes;

private:
    Ui::MainWindowClass *ui;
    QString currentSrcDir;
    QString currentDestDir;
    QString version;
    int versionId;
    bool abort;


    void loadSettings();
    void saveSettings();
    void formTranslate();
    void setCustomEnabled(bool enable);

private slots:
    void on_chkFoceAspect_clicked();
    void on_btnAbort_clicked();
    void on_btnAdd_clicked();
    void on_actionSe_ttings_triggered();
    void on_action_About_triggered();
    void on_actionOnline_Help_triggered();
    void on_actionE_xit_triggered();
    void onBtnSrcClick();
    void onBtnDestClick();
    void onCmbChange();
    void startProcessing();
    void qualityChanged();

};

#endif // MAINWINDOW_H
