/*
 * Decompiled with CFR 0.152.
 */
package music.cpp.client;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import music.cpp.client.MusicClient;
import music.cpp.client.StringResource;

public class TipsDialog
extends JDialog {
    static final String iNext = MusicClient.STRINGS.get("IDSTR_NEXT");
    static final String iPrevious = MusicClient.STRINGS.get("IDSTR_PREVIOUS");
    static final String iClose = MusicClient.STRINGS.get("IDSTR_CLOSE");
    static final String iShowTips = MusicClient.STRINGS.get("IDSTR_SHOW_TIPS");
    final int TIPS = 15;
    StringResource sr = null;

    public TipsDialog(final MusicClient musicClient) {
        super(musicClient, MusicClient.STRINGS.get("IDSTR_J_TIP_OF_THE_DAY"), true);
        JPanel jPanel = new JPanel(new BorderLayout()){

            public Dimension getPreferredSize() {
                return new Dimension(600, 200);
            }
        };
        final JPanel jPanel2 = new JPanel(new GridBagLayout());
        final JTextArea jTextArea = new JTextArea(this.getTip(musicClient.currentTip));
        jTextArea.setEditable(false);
        jTextArea.setBackground(jPanel.getBackground());
        jPanel2.add(jTextArea);
        jPanel.add("Center", jPanel2);
        JPanel jPanel3 = new JPanel();
        final JCheckBox jCheckBox = new JCheckBox(iShowTips, musicClient.showTipsAtStartup);
        jPanel3.add(jCheckBox);
        jPanel.add("South", jPanel3);
        JPanel jPanel4 = new JPanel();
        JButton jButton = new JButton(iNext);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jPanel2.invalidate();
                ++musicClient.currentTip;
                if (musicClient.currentTip == 15) {
                    musicClient.currentTip = 0;
                }
                jTextArea.setText(TipsDialog.this.getTip(musicClient.currentTip));
                jPanel2.revalidate();
                jPanel2.repaint();
            }
        });
        jPanel4.add(jButton);
        JButton jButton2 = new JButton(iPrevious);
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jPanel2.invalidate();
                --musicClient.currentTip;
                if (musicClient.currentTip < 0) {
                    musicClient.currentTip = 14;
                }
                jTextArea.setText(TipsDialog.this.getTip(musicClient.currentTip));
                jPanel2.revalidate();
                jPanel2.repaint();
            }
        });
        jPanel4.add(jButton2);
        JButton jButton3 = new JButton(iClose);
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                musicClient.showTipsAtStartup = jCheckBox.isSelected();
                TipsDialog.this.setVisible(false);
            }
        });
        jPanel4.add(jButton3);
        this.getContentPane().add("Center", jPanel);
        this.getContentPane().add("South", jPanel4);
        this.pack();
        this.setLocationRelativeTo(musicClient);
        this.setVisible(true);
    }

    String getTip(int n) {
        return MusicClient.STRINGS.get("IDSTR_TIPS + " + n);
    }
}

