/*
 * Decompiled with CFR 0.152.
 */
package music.cpp.client;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import music.cpp.client.MusicClient;
import music.cpp.client.StringUtil;

class SongLoadingProgress
extends JDialog {
    static final int TYPE_OTHER = 0;
    static final int TYPE_ADD = 1;
    static final int TYPE_REFRESH = 2;
    static final int TYPE_DUPS = 3;
    static final String iFound1Song = MusicClient.STRINGS.get("IDSTR_FOUND_SONG");
    static final String iFoundNSongs = MusicClient.STRINGS.get("IDSTR_FOUND_SONGS");
    static final String iRefreshingOf = MusicClient.STRINGS.get("IDSTR_REFRESHING_OF");
    static final String iScanningOf = MusicClient.STRINGS.get("IDSTR_SCANNING_OF");
    MusicClient client;
    String text;
    int type = 0;
    JLabel label;
    JButton cancel;
    int internalCount = 0;
    int internalTotal = -1;
    public boolean interrupted;
    boolean cleanExit = false;

    public SongLoadingProgress(final MusicClient musicClient, String string, int n) {
        super(musicClient, string, true);
        this.client = musicClient;
        this.text = string;
        this.type = n;
        this.interrupted = false;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                if (!SongLoadingProgress.this.cleanExit) {
                    SongLoadingProgress.this.interrupted = true;
                    musicClient.progressInterrupted = true;
                }
                musicClient.enableMenus(true);
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(false);
        this.label = new JLabel(this.text){

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                if (dimension.width < 250) {
                    dimension.width = 250;
                }
                return dimension;
            }
        };
        this.label.setHorizontalAlignment(0);
        jPanel.add("Center", this.label);
        JPanel jPanel2 = new JPanel();
        jPanel2.setOpaque(false);
        this.cancel = new JButton(MusicClient.iCancel);
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                musicClient.progressInterrupted = true;
                SongLoadingProgress.this.interrupted = true;
                SongLoadingProgress.this.setVisible(false);
                SongLoadingProgress.this.dispose();
                musicClient.progress = null;
                musicClient.enableMenus(true);
            }
        });
        jPanel2.add(this.cancel);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add("Center", jPanel);
        jPanel3.add("South", jPanel2);
        this.getContentPane().add(jPanel3);
        this.pack();
        this.setLocationRelativeTo(musicClient);
        this.setResizable(false);
    }

    public void update(String string, int n, int n2) {
        if (this.interrupted) {
            return;
        }
        int n3 = string.indexOf("%s");
        if (n3 >= 0) {
            string = string.substring(0, n3) + StringUtil.l2ac(n) + string.substring(n3 + 2);
        }
        if (n2 >= 0) {
            string = StringUtil.replace(string, "%s", StringUtil.l2ac(n2));
        }
        final String string2 = string;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SongLoadingProgress.this.label.setText(string2);
            }
        });
    }

    public void add() {
        if (this.interrupted) {
            return;
        }
        ++this.internalCount;
        switch (this.type) {
            case 1: {
                if (this.internalCount == 1) {
                    this.update(iFound1Song, this.internalCount, -1);
                    break;
                }
                this.update(iFoundNSongs, this.internalCount, -1);
                break;
            }
            case 2: {
                this.update(iRefreshingOf, this.internalCount, this.internalTotal);
                break;
            }
            case 3: {
                this.update(iScanningOf, this.internalCount, this.internalTotal);
            }
        }
    }

    public void close() {
        if (!this.interrupted) {
            this.cleanExit = true;
            this.setVisible(false);
            this.dispose();
        }
    }
}

