/*
 * Decompiled with CFR 0.152.
 */
package music.cpp.client;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import music.cpp.client.MusicClient;
import music.cpp.client.ServerImplementation;
import music.cpp.client.WebBrowser;

public class ServicesPanel
extends JPanel {
    static final String iServicesPort = MusicClient.STRINGS.get("IDSTR_SERVICES_PORT");
    static final String iEnabledServices = MusicClient.STRINGS.get("IDSTR_ENABLED_SERVICES");
    static final String iServicesStop = MusicClient.STRINGS.get("IDSTR_SERVICES_STOP");
    static final String iServicesStart = MusicClient.STRINGS.get("IDSTR_SERVICES_START");
    static final String iUnableStartServer = MusicClient.STRINGS.get("IDSTR_UNABLE_START_SERVER");
    static final String iServicesShow = MusicClient.STRINGS.get("IDSTR_SERVICES_SHOW");
    MusicClient client;
    JCheckBox[] cb;
    JTextField port;
    JButton start;
    JButton show;

    public ServicesPanel(MusicClient musicClient) {
        super(new BorderLayout());
        this.client = musicClient;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagLayout gridBagLayout = (GridBagLayout)jPanel.getLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 5, 1, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        JLabel jLabel = new JLabel(iServicesPort);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        this.port = new JTextField(String.valueOf(this.client.mmServerPort)){

            public Color getBackground() {
                return this.isEnabled() ? super.getBackground() : SystemColor.control;
            }

            public Color getForeground() {
                return this.isEnabled() ? super.getForeground() : SystemColor.textInactiveText;
            }
        };
        gridBagLayout.setConstraints(this.port, gridBagConstraints);
        jPanel.add(this.port);
        this.port.setEnabled(!this.client.isMMServerRunning());
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.top += 20;
        jLabel = new JLabel(iEnabledServices);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.insets.top -= 20;
        this.cb = new JCheckBox[this.client.servers.size()];
        for (int i = 0; i < this.client.servers.size(); ++i) {
            ++gridBagConstraints.gridy;
            ServerImplementation serverImplementation = (ServerImplementation)this.client.servers.elementAt(i);
            this.cb[i] = new JCheckBox(serverImplementation.getName(), serverImplementation.isActive());
            gridBagLayout.setConstraints(this.cb[i], gridBagConstraints);
            jPanel.add(this.cb[i]);
            this.cb[i].setEnabled(!this.client.isMMServerRunning());
        }
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 10;
        JPanel jPanel2 = new JPanel();
        this.start = new JButton(this.client.isMMServerRunning() ? iServicesStop : iServicesStart);
        this.start.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!ServicesPanel.this.client.isMMServerRunning()) {
                    int n;
                    ServicesPanel.this.apply();
                    ServicesPanel.this.client.startMMServer();
                    for (n = 0; n < 10 && !ServicesPanel.this.client.isMMServerRunning(); ++n) {
                        try {
                            Thread.sleep(100L);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    if (ServicesPanel.this.client.isMMServerRunning()) {
                        ServicesPanel.this.port.setEnabled(false);
                        for (n = 0; n < ServicesPanel.this.cb.length; ++n) {
                            ServicesPanel.this.cb[n].setEnabled(false);
                        }
                        ServicesPanel.this.start.setText(iServicesStop);
                    } else {
                        ServicesPanel.this.client.showMessage(iUnableStartServer);
                    }
                    ServicesPanel.this.show.setEnabled(true);
                } else {
                    int n;
                    ServicesPanel.this.client.stopMMServer();
                    for (n = 0; n < 10 && ServicesPanel.this.client.isMMServerRunning(); ++n) {
                        try {
                            Thread.sleep(100L);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    if (!ServicesPanel.this.client.isMMServerRunning()) {
                        ServicesPanel.this.port.setEnabled(true);
                        for (n = 0; n < ServicesPanel.this.cb.length; ++n) {
                            ServicesPanel.this.cb[n].setEnabled(true);
                        }
                        ServicesPanel.this.start.setText(iServicesStart);
                    }
                    ServicesPanel.this.show.setEnabled(false);
                }
            }
        });
        this.start.setEnabled(true);
        jPanel2.add(this.start);
        this.show = new JButton(iServicesShow);
        this.show.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ServicesPanel.this.client.isMMServerRunning()) {
                    WebBrowser.browse("http://localhost:" + ServicesPanel.this.client.mmServerPort + "/");
                }
            }
        });
        jPanel2.add(this.show);
        this.show.setEnabled(this.client.isMMServerRunning());
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        this.add("Center", jPanel);
    }

    void apply() {
        try {
            this.client.mmServerPort = Integer.parseInt(this.port.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        for (int i = 0; i < this.client.servers.size(); ++i) {
            ServerImplementation serverImplementation = (ServerImplementation)this.client.servers.elementAt(i);
            serverImplementation.setActive(this.cb[i].isSelected());
        }
    }
}

