/*
 * Decompiled with CFR 0.152.
 */
package music.cpp.client;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class Profile {
    public static final int VERSION = 1;
    static final int DIM = 35;
    public double[] importance;
    private int samples;
    private long id;

    public Profile(long l) {
        this(new double[35], 0, l);
    }

    public Profile(double[] dArray, int n, long l) {
        this.id = l;
        this.importance = dArray;
        this.samples = n;
    }

    long getID() {
        return this.id;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Profile)) {
            return false;
        }
        return this.id == ((Profile)object).id;
    }

    public int hashCode() {
        return (int)this.id;
    }

    public void reset() {
        this.id = 0L;
    }

    public void readExternal(DataInput dataInput) throws IOException {
        byte by = dataInput.readByte();
        switch (by) {
            case 1: {
                this.samples = dataInput.readInt();
                for (int i = 0; i < 35; ++i) {
                    this.importance[i] = dataInput.readDouble();
                }
                break;
            }
            default: {
                throw new IOException();
            }
        }
    }

    public void writeExternal(DataOutput dataOutput) throws IOException {
        dataOutput.writeByte(1);
        dataOutput.writeInt(this.samples);
        for (int i = 0; i < 35; ++i) {
            dataOutput.writeDouble(this.importance[i]);
        }
    }

    public double distanceSq(Profile profile) {
        double d = 0.0;
        for (int i = 0; i < 35; ++i) {
            double d2 = this.importance[i] - profile.importance[i];
            d += d2 * d2;
        }
        return d;
    }

    public double[] getImportance() {
        return this.importance;
    }

    public int getSamples() {
        return this.samples;
    }
}

